from typing import List

import requirements
from packaging import version


class RequirementList(List):
    @classmethod
    def from_file(cls, filepath):
        """
        :param str filepath:
        :rtype: RequirementList
        """
        with open(filepath) as f:
            return cls(requirements.parse(f.read()))

    def __contains__(self, package_name):
        """
        :param str package_name:
        :rtype: bool
        """
        return self.get(package_name) is not None

    def get(self, package_name):
        """
        :param str package_name:
        :rtype: Requirement
        """
        for requirement in self:
            if requirement.name == package_name:
                return requirement

    def get_specs(self, package_name):
        """
        :param str package_name:
        :rtype: typing.List[typing.Optional[str]]
        """
        requirement = self.get(package_name)
        if requirement is not None:
            return requirement.specs

    def get_version(self, package_name):
        """
        :param str package_name:
        :rtype: typing.Optional[packaging.version.Version]
        """
        specs = self.get_specs(package_name)
        if specs:
            return version.parse(specs[0][1])
