"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotToKinesisStreams = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iot = require("@aws-cdk/aws-iot");
const iam = require("@aws-cdk/aws-iam");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
class IotToKinesisStreams extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the IotToKinesisFirehoseToS3 class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Set up the Kinesis Stream
        this.kinesisStream = defaults.buildKinesisStream(this, {
            existingStreamObj: props.existingStreamObj,
            kinesisStreamProps: props.kinesisStreamProps,
        });
        // Setup the IAM Role for IoT Actions
        this.iotActionsRole = new iam.Role(this, 'IotActionsRole', {
            assumedBy: new iam.ServicePrincipal('iot.amazonaws.com'),
        });
        // Setup the IAM policy for IoT Actions
        const iotActionsPolicy = new iam.Policy(this, 'IotActionsPolicy', {
            statements: [new iam.PolicyStatement({
                    actions: [
                        'kinesis:PutRecord'
                    ],
                    resources: [this.kinesisStream.streamArn]
                })
            ]
        });
        // Attach policy to role
        iotActionsPolicy.attachToRole(this.iotActionsRole);
        // Create IoT Rule Props
        const defaultIotTopicProps = defaults.DefaultCfnTopicRuleProps([{
                kinesis: {
                    streamName: this.kinesisStream.streamName,
                    roleArn: this.iotActionsRole.roleArn
                }
            }]);
        const iotTopicProps = defaults.overrideProps(defaultIotTopicProps, props.iotTopicRuleProps, true);
        // Create the IoT topic rule
        this.iotTopicRule = new iot.CfnTopicRule(this, 'IotTopic', iotTopicProps);
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            // Deploy best practices CW Alarms for Kinesis Stream
            this.cloudwatchAlarms = defaults.buildKinesisStreamCWAlarms(this);
        }
    }
}
exports.IotToKinesisStreams = IotToKinesisStreams;
_a = JSII_RTTI_SYMBOL_1;
IotToKinesisStreams[_a] = { fqn: "@aws-solutions-constructs/aws-iot-kinesisstreams.IotToKinesisStreams", version: "1.126.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWVBLHdDQUF3QztBQUN4Qyx3Q0FBd0M7QUFDeEMsd0ZBQXdGO0FBQ3hGLHdDQUEwQztBQUMxQywyREFBMkQ7QUFjM0QsTUFBYSxtQkFBb0IsU0FBUSxnQkFBUzs7Ozs7Ozs7O0lBT2hELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBK0I7UUFDdkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixRQUFRLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBRTNCLDRCQUE0QjtRQUM1QixJQUFJLENBQUMsYUFBYSxHQUFHLFFBQVEsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLEVBQUU7WUFDckQsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtZQUMxQyxrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCO1NBQzdDLENBQUMsQ0FBQztRQUVILHFDQUFxQztRQUNyQyxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUU7WUFDekQsU0FBUyxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG1CQUFtQixDQUFDO1NBQ3pELENBQUMsQ0FBQztRQUVILHVDQUF1QztRQUN2QyxNQUFNLGdCQUFnQixHQUFHLElBQUksR0FBRyxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsa0JBQWtCLEVBQUU7WUFDaEUsVUFBVSxFQUFFLENBQUMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO29CQUNuQyxPQUFPLEVBQUU7d0JBQ1AsbUJBQW1CO3FCQUNwQjtvQkFDRCxTQUFTLEVBQUUsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQztpQkFDMUMsQ0FBQzthQUNEO1NBQUMsQ0FBQyxDQUFDO1FBRU4sd0JBQXdCO1FBQ3hCLGdCQUFnQixDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUM7UUFFbkQsd0JBQXdCO1FBQ3hCLE1BQU0sb0JBQW9CLEdBQUcsUUFBUSxDQUFDLHdCQUF3QixDQUFDLENBQUM7Z0JBQzlELE9BQU8sRUFBRTtvQkFDUCxVQUFVLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxVQUFVO29CQUN6QyxPQUFPLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxPQUFPO2lCQUNyQzthQUNGLENBQUMsQ0FBQyxDQUFDO1FBQ0osTUFBTSxhQUFhLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxvQkFBb0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFFbEcsNEJBQTRCO1FBQzVCLElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxHQUFHLENBQUMsWUFBWSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUUsYUFBYSxDQUFDLENBQUM7UUFFMUUsSUFBSSxLQUFLLENBQUMsc0JBQXNCLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxzQkFBc0IsRUFBRTtZQUM5RSxxREFBcUQ7WUFDckQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFFBQVEsQ0FBQywwQkFBMEIsQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUNuRTtJQUNILENBQUM7O0FBbkRILGtEQW9EQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDIxIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0ICogYXMga2luZXNpcyBmcm9tICdAYXdzLWNkay9hd3Mta2luZXNpcyc7XG5pbXBvcnQgKiBhcyBjbG91ZHdhdGNoIGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZHdhdGNoJztcbmltcG9ydCAqIGFzIGlvdCBmcm9tICdAYXdzLWNkay9hd3MtaW90JztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbi8vIE5vdGU6IFRvIGVuc3VyZSBDREt2MiBjb21wYXRpYmlsaXR5LCBrZWVwIHRoZSBpbXBvcnQgc3RhdGVtZW50IGZvciBDb25zdHJ1Y3Qgc2VwYXJhdGVcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgZGVmYXVsdHMgZnJvbSAnQGF3cy1zb2x1dGlvbnMtY29uc3RydWN0cy9jb3JlJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSW90VG9LaW5lc2lzU3RyZWFtc1Byb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpb3RUb3BpY1J1bGVQcm9wczogaW90LkNmblRvcGljUnVsZVByb3BzO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGV4aXN0aW5nU3RyZWFtT2JqPzoga2luZXNpcy5TdHJlYW07XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBraW5lc2lzU3RyZWFtUHJvcHM/OiBraW5lc2lzLlN0cmVhbVByb3BzIHwgYW55O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY3JlYXRlQ2xvdWRXYXRjaEFsYXJtcz86IGJvb2xlYW47XG59XG5cbmV4cG9ydCBjbGFzcyBJb3RUb0tpbmVzaXNTdHJlYW1zIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGlvdFRvcGljUnVsZTogaW90LkNmblRvcGljUnVsZTtcbiAgcHVibGljIHJlYWRvbmx5IGtpbmVzaXNTdHJlYW06IGtpbmVzaXMuU3RyZWFtO1xuICBwdWJsaWMgcmVhZG9ubHkgY2xvdWR3YXRjaEFsYXJtcz86IGNsb3Vkd2F0Y2guQWxhcm1bXTtcbiAgcHVibGljIHJlYWRvbmx5IGlvdEFjdGlvbnNSb2xlOiBpYW0uUm9sZTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBJb3RUb0tpbmVzaXNTdHJlYW1zUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIGRlZmF1bHRzLkNoZWNrUHJvcHMocHJvcHMpO1xuXG4gICAgLy8gU2V0IHVwIHRoZSBLaW5lc2lzIFN0cmVhbVxuICAgIHRoaXMua2luZXNpc1N0cmVhbSA9IGRlZmF1bHRzLmJ1aWxkS2luZXNpc1N0cmVhbSh0aGlzLCB7XG4gICAgICBleGlzdGluZ1N0cmVhbU9iajogcHJvcHMuZXhpc3RpbmdTdHJlYW1PYmosXG4gICAgICBraW5lc2lzU3RyZWFtUHJvcHM6IHByb3BzLmtpbmVzaXNTdHJlYW1Qcm9wcyxcbiAgICB9KTtcblxuICAgIC8vIFNldHVwIHRoZSBJQU0gUm9sZSBmb3IgSW9UIEFjdGlvbnNcbiAgICB0aGlzLmlvdEFjdGlvbnNSb2xlID0gbmV3IGlhbS5Sb2xlKHRoaXMsICdJb3RBY3Rpb25zUm9sZScsIHtcbiAgICAgIGFzc3VtZWRCeTogbmV3IGlhbS5TZXJ2aWNlUHJpbmNpcGFsKCdpb3QuYW1hem9uYXdzLmNvbScpLFxuICAgIH0pO1xuXG4gICAgLy8gU2V0dXAgdGhlIElBTSBwb2xpY3kgZm9yIElvVCBBY3Rpb25zXG4gICAgY29uc3QgaW90QWN0aW9uc1BvbGljeSA9IG5ldyBpYW0uUG9saWN5KHRoaXMsICdJb3RBY3Rpb25zUG9saWN5Jywge1xuICAgICAgc3RhdGVtZW50czogW25ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgYWN0aW9uczogW1xuICAgICAgICAgICdraW5lc2lzOlB1dFJlY29yZCdcbiAgICAgICAgXSxcbiAgICAgICAgcmVzb3VyY2VzOiBbdGhpcy5raW5lc2lzU3RyZWFtLnN0cmVhbUFybl1cbiAgICAgIH0pXG4gICAgICBdfSk7XG5cbiAgICAvLyBBdHRhY2ggcG9saWN5IHRvIHJvbGVcbiAgICBpb3RBY3Rpb25zUG9saWN5LmF0dGFjaFRvUm9sZSh0aGlzLmlvdEFjdGlvbnNSb2xlKTtcblxuICAgIC8vIENyZWF0ZSBJb1QgUnVsZSBQcm9wc1xuICAgIGNvbnN0IGRlZmF1bHRJb3RUb3BpY1Byb3BzID0gZGVmYXVsdHMuRGVmYXVsdENmblRvcGljUnVsZVByb3BzKFt7XG4gICAgICBraW5lc2lzOiB7XG4gICAgICAgIHN0cmVhbU5hbWU6IHRoaXMua2luZXNpc1N0cmVhbS5zdHJlYW1OYW1lLFxuICAgICAgICByb2xlQXJuOiB0aGlzLmlvdEFjdGlvbnNSb2xlLnJvbGVBcm5cbiAgICAgIH1cbiAgICB9XSk7XG4gICAgY29uc3QgaW90VG9waWNQcm9wcyA9IGRlZmF1bHRzLm92ZXJyaWRlUHJvcHMoZGVmYXVsdElvdFRvcGljUHJvcHMsIHByb3BzLmlvdFRvcGljUnVsZVByb3BzLCB0cnVlKTtcblxuICAgIC8vIENyZWF0ZSB0aGUgSW9UIHRvcGljIHJ1bGVcbiAgICB0aGlzLmlvdFRvcGljUnVsZSA9IG5ldyBpb3QuQ2ZuVG9waWNSdWxlKHRoaXMsICdJb3RUb3BpYycsIGlvdFRvcGljUHJvcHMpO1xuXG4gICAgaWYgKHByb3BzLmNyZWF0ZUNsb3VkV2F0Y2hBbGFybXMgPT09IHVuZGVmaW5lZCB8fCBwcm9wcy5jcmVhdGVDbG91ZFdhdGNoQWxhcm1zKSB7XG4gICAgICAvLyBEZXBsb3kgYmVzdCBwcmFjdGljZXMgQ1cgQWxhcm1zIGZvciBLaW5lc2lzIFN0cmVhbVxuICAgICAgdGhpcy5jbG91ZHdhdGNoQWxhcm1zID0gZGVmYXVsdHMuYnVpbGRLaW5lc2lzU3RyZWFtQ1dBbGFybXModGhpcyk7XG4gICAgfVxuICB9XG59Il19