# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from memsource_cli.models.project_workflow_step_reference import ProjectWorkflowStepReference  # noqa: F401,E501
from memsource_cli.models.provider_reference import ProviderReference  # noqa: F401,E501


class JobPartReferenceV2(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'uid': 'str',
        'status': 'str',
        'providers': 'list[ProviderReference]',
        'target_lang': 'str',
        'workflow_step': 'ProjectWorkflowStepReference',
        'filename': 'str',
        'date_due': 'datetime',
        'date_created': 'datetime',
        'imported': 'bool',
        'continuous': 'bool'
    }

    attribute_map = {
        'uid': 'uid',
        'status': 'status',
        'providers': 'providers',
        'target_lang': 'targetLang',
        'workflow_step': 'workflowStep',
        'filename': 'filename',
        'date_due': 'dateDue',
        'date_created': 'dateCreated',
        'imported': 'imported',
        'continuous': 'continuous'
    }

    def __init__(self, uid=None, status=None, providers=None, target_lang=None, workflow_step=None, filename=None, date_due=None, date_created=None, imported=None, continuous=None):  # noqa: E501
        """JobPartReferenceV2 - a model defined in Swagger"""  # noqa: E501

        self._uid = None
        self._status = None
        self._providers = None
        self._target_lang = None
        self._workflow_step = None
        self._filename = None
        self._date_due = None
        self._date_created = None
        self._imported = None
        self._continuous = None
        self.discriminator = None

        if uid is not None:
            self.uid = uid
        if status is not None:
            self.status = status
        if providers is not None:
            self.providers = providers
        if target_lang is not None:
            self.target_lang = target_lang
        if workflow_step is not None:
            self.workflow_step = workflow_step
        if filename is not None:
            self.filename = filename
        if date_due is not None:
            self.date_due = date_due
        if date_created is not None:
            self.date_created = date_created
        if imported is not None:
            self.imported = imported
        if continuous is not None:
            self.continuous = continuous

    @property
    def uid(self):
        """Gets the uid of this JobPartReferenceV2.  # noqa: E501


        :return: The uid of this JobPartReferenceV2.  # noqa: E501
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this JobPartReferenceV2.


        :param uid: The uid of this JobPartReferenceV2.  # noqa: E501
        :type: str
        """

        self._uid = uid

    @property
    def status(self):
        """Gets the status of this JobPartReferenceV2.  # noqa: E501


        :return: The status of this JobPartReferenceV2.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this JobPartReferenceV2.


        :param status: The status of this JobPartReferenceV2.  # noqa: E501
        :type: str
        """
        allowed_values = ["NEW", "ACCEPTED", "DECLINED", "REJECTED", "DELIVERED", "EMAILED", "COMPLETED", "CANCELLED"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def providers(self):
        """Gets the providers of this JobPartReferenceV2.  # noqa: E501


        :return: The providers of this JobPartReferenceV2.  # noqa: E501
        :rtype: list[ProviderReference]
        """
        return self._providers

    @providers.setter
    def providers(self, providers):
        """Sets the providers of this JobPartReferenceV2.


        :param providers: The providers of this JobPartReferenceV2.  # noqa: E501
        :type: list[ProviderReference]
        """

        self._providers = providers

    @property
    def target_lang(self):
        """Gets the target_lang of this JobPartReferenceV2.  # noqa: E501


        :return: The target_lang of this JobPartReferenceV2.  # noqa: E501
        :rtype: str
        """
        return self._target_lang

    @target_lang.setter
    def target_lang(self, target_lang):
        """Sets the target_lang of this JobPartReferenceV2.


        :param target_lang: The target_lang of this JobPartReferenceV2.  # noqa: E501
        :type: str
        """

        self._target_lang = target_lang

    @property
    def workflow_step(self):
        """Gets the workflow_step of this JobPartReferenceV2.  # noqa: E501


        :return: The workflow_step of this JobPartReferenceV2.  # noqa: E501
        :rtype: ProjectWorkflowStepReference
        """
        return self._workflow_step

    @workflow_step.setter
    def workflow_step(self, workflow_step):
        """Sets the workflow_step of this JobPartReferenceV2.


        :param workflow_step: The workflow_step of this JobPartReferenceV2.  # noqa: E501
        :type: ProjectWorkflowStepReference
        """

        self._workflow_step = workflow_step

    @property
    def filename(self):
        """Gets the filename of this JobPartReferenceV2.  # noqa: E501


        :return: The filename of this JobPartReferenceV2.  # noqa: E501
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """Sets the filename of this JobPartReferenceV2.


        :param filename: The filename of this JobPartReferenceV2.  # noqa: E501
        :type: str
        """

        self._filename = filename

    @property
    def date_due(self):
        """Gets the date_due of this JobPartReferenceV2.  # noqa: E501


        :return: The date_due of this JobPartReferenceV2.  # noqa: E501
        :rtype: datetime
        """
        return self._date_due

    @date_due.setter
    def date_due(self, date_due):
        """Sets the date_due of this JobPartReferenceV2.


        :param date_due: The date_due of this JobPartReferenceV2.  # noqa: E501
        :type: datetime
        """

        self._date_due = date_due

    @property
    def date_created(self):
        """Gets the date_created of this JobPartReferenceV2.  # noqa: E501


        :return: The date_created of this JobPartReferenceV2.  # noqa: E501
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """Sets the date_created of this JobPartReferenceV2.


        :param date_created: The date_created of this JobPartReferenceV2.  # noqa: E501
        :type: datetime
        """

        self._date_created = date_created

    @property
    def imported(self):
        """Gets the imported of this JobPartReferenceV2.  # noqa: E501

        Default: false  # noqa: E501

        :return: The imported of this JobPartReferenceV2.  # noqa: E501
        :rtype: bool
        """
        return self._imported

    @imported.setter
    def imported(self, imported):
        """Sets the imported of this JobPartReferenceV2.

        Default: false  # noqa: E501

        :param imported: The imported of this JobPartReferenceV2.  # noqa: E501
        :type: bool
        """

        self._imported = imported

    @property
    def continuous(self):
        """Gets the continuous of this JobPartReferenceV2.  # noqa: E501


        :return: The continuous of this JobPartReferenceV2.  # noqa: E501
        :rtype: bool
        """
        return self._continuous

    @continuous.setter
    def continuous(self, continuous):
        """Sets the continuous of this JobPartReferenceV2.


        :param continuous: The continuous of this JobPartReferenceV2.  # noqa: E501
        :type: bool
        """

        self._continuous = continuous

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(JobPartReferenceV2, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobPartReferenceV2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
