# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from memsource_cli.api_client import ApiClient


class TermBaseApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def browse_terms(self, term_base_id, **kwargs):  # noqa: E501
        """Browse term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.browse_terms(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param BrowseRequestDto body:
        :return: BrowseResponseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.browse_terms_with_http_info(term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.browse_terms_with_http_info(term_base_id, **kwargs)  # noqa: E501
            return data

    def browse_terms_with_http_info(self, term_base_id, **kwargs):  # noqa: E501
        """Browse term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.browse_terms_with_http_info(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param BrowseRequestDto body:
        :return: BrowseResponseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method browse_terms" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `browse_terms`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/browse', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BrowseResponseListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clear_term_base(self, term_base_id, **kwargs):  # noqa: E501
        """Clear term base  # noqa: E501

        Deletes all terms  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_term_base(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.clear_term_base_with_http_info(term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.clear_term_base_with_http_info(term_base_id, **kwargs)  # noqa: E501
            return data

    def clear_term_base_with_http_info(self, term_base_id, **kwargs):  # noqa: E501
        """Clear term base  # noqa: E501

        Deletes all terms  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_term_base_with_http_info(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clear_term_base" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `clear_term_base`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/terms', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_term(self, term_base_id, **kwargs):  # noqa: E501
        """Create term  # noqa: E501

        Set conceptId to assign the term to an existing concept, otherwise a new concept will be created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_term(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param TermCreateDto body:
        :return: TermDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_term_with_http_info(term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_term_with_http_info(term_base_id, **kwargs)  # noqa: E501
            return data

    def create_term_with_http_info(self, term_base_id, **kwargs):  # noqa: E501
        """Create term  # noqa: E501

        Set conceptId to assign the term to an existing concept, otherwise a new concept will be created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_term_with_http_info(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param TermCreateDto body:
        :return: TermDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_term" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `create_term`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/terms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TermDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_term_base(self, **kwargs):  # noqa: E501
        """Create term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_term_base(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TermBaseEditDto body:
        :return: TermBaseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_term_base_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_term_base_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_term_base_with_http_info(self, **kwargs):  # noqa: E501
        """Create term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_term_base_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TermBaseEditDto body:
        :return: TermBaseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_term_base" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TermBaseDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_term_by_job(self, job_uid, project_uid, **kwargs):  # noqa: E501
        """Create term in job's term bases  # noqa: E501

        Create new term in the write term base assigned to the job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_term_by_job(job_uid, project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str project_uid: (required)
        :param CreateTermsDto body:
        :return: TermPairDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_term_by_job_with_http_info(job_uid, project_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.create_term_by_job_with_http_info(job_uid, project_uid, **kwargs)  # noqa: E501
            return data

    def create_term_by_job_with_http_info(self, job_uid, project_uid, **kwargs):  # noqa: E501
        """Create term in job's term bases  # noqa: E501

        Create new term in the write term base assigned to the job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_term_by_job_with_http_info(job_uid, project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str project_uid: (required)
        :param CreateTermsDto body:
        :return: TermPairDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'project_uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_term_by_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `create_term_by_job`")  # noqa: E501
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `create_term_by_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/jobs/{jobUid}/termBases/createByJob', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TermPairDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_concept(self, term_base_id, concept_id, **kwargs):  # noqa: E501
        """Delete concept  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_concept(term_base_id, concept_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str concept_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_concept_with_http_info(term_base_id, concept_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_concept_with_http_info(term_base_id, concept_id, **kwargs)  # noqa: E501
            return data

    def delete_concept_with_http_info(self, term_base_id, concept_id, **kwargs):  # noqa: E501
        """Delete concept  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_concept_with_http_info(term_base_id, concept_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str concept_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'concept_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_concept" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `delete_concept`")  # noqa: E501
        # verify the required parameter 'concept_id' is set
        if ('concept_id' not in params or
                params['concept_id'] is None):
            raise ValueError("Missing the required parameter `concept_id` when calling `delete_concept`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501
        if 'concept_id' in params:
            path_params['conceptId'] = params['concept_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/concepts/{conceptId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_concepts(self, term_base_id, **kwargs):  # noqa: E501
        """Delete concepts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_concepts(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param ConceptListReference body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_concepts_with_http_info(term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_concepts_with_http_info(term_base_id, **kwargs)  # noqa: E501
            return data

    def delete_concepts_with_http_info(self, term_base_id, **kwargs):  # noqa: E501
        """Delete concepts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_concepts_with_http_info(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param ConceptListReference body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_concepts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `delete_concepts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/concepts', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_term(self, term_base_id, term_id, **kwargs):  # noqa: E501
        """Delete term  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_term(term_base_id, term_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str term_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_term_with_http_info(term_base_id, term_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_term_with_http_info(term_base_id, term_id, **kwargs)  # noqa: E501
            return data

    def delete_term_with_http_info(self, term_base_id, term_id, **kwargs):  # noqa: E501
        """Delete term  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_term_with_http_info(term_base_id, term_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str term_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'term_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_term" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `delete_term`")  # noqa: E501
        # verify the required parameter 'term_id' is set
        if ('term_id' not in params or
                params['term_id'] is None):
            raise ValueError("Missing the required parameter `term_id` when calling `delete_term`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501
        if 'term_id' in params:
            path_params['termId'] = params['term_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/terms/{termId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_term_base(self, term_base_id, **kwargs):  # noqa: E501
        """Delete term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_term_base(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param bool purge: purge=false - the Termbase is can later be restored,                      \"purge=true - the Termbase is completely deleted and cannot be restored
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_term_base_with_http_info(term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_term_base_with_http_info(term_base_id, **kwargs)  # noqa: E501
            return data

    def delete_term_base_with_http_info(self, term_base_id, **kwargs):  # noqa: E501
        """Delete term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_term_base_with_http_info(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param bool purge: purge=false - the Termbase is can later be restored,                      \"purge=true - the Termbase is completely deleted and cannot be restored
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'purge']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_term_base" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `delete_term_base`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []
        if 'purge' in params:
            query_params.append(('purge', params['purge']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_term_base(self, term_base_id, **kwargs):  # noqa: E501
        """Export term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_term_base(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str format:
        :param str charset:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_term_base_with_http_info(term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_term_base_with_http_info(term_base_id, **kwargs)  # noqa: E501
            return data

    def export_term_base_with_http_info(self, term_base_id, **kwargs):  # noqa: E501
        """Export term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_term_base_with_http_info(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str format:
        :param str charset:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'format', 'charset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_term_base" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `export_term_base`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'charset' in params:
            query_params.append(('charset', params['charset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_last_background_task(self, term_base_id, **kwargs):  # noqa: E501
        """Last import status  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_last_background_task(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :return: BackgroundTasksTbDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_last_background_task_with_http_info(term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_last_background_task_with_http_info(term_base_id, **kwargs)  # noqa: E501
            return data

    def get_last_background_task_with_http_info(self, term_base_id, **kwargs):  # noqa: E501
        """Last import status  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_last_background_task_with_http_info(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :return: BackgroundTasksTbDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_last_background_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `get_last_background_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/lastBackgroundTask', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BackgroundTasksTbDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_template_term_bases(self, project_template_id, **kwargs):  # noqa: E501
        """Get term bases  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_template_term_bases(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: ProjectTemplateTermBaseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_template_term_bases_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_template_term_bases_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def get_project_template_term_bases_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Get term bases  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_template_term_bases_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: ProjectTemplateTermBaseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_template_term_bases" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `get_project_template_term_bases`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}/termBases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectTemplateTermBaseListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_term(self, term_base_id, term_id, **kwargs):  # noqa: E501
        """Get term  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_term(term_base_id, term_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str term_id: (required)
        :return: TermDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_term_with_http_info(term_base_id, term_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_term_with_http_info(term_base_id, term_id, **kwargs)  # noqa: E501
            return data

    def get_term_with_http_info(self, term_base_id, term_id, **kwargs):  # noqa: E501
        """Get term  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_term_with_http_info(term_base_id, term_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str term_id: (required)
        :return: TermDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'term_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_term" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `get_term`")  # noqa: E501
        # verify the required parameter 'term_id' is set
        if ('term_id' not in params or
                params['term_id'] is None):
            raise ValueError("Missing the required parameter `term_id` when calling `get_term`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501
        if 'term_id' in params:
            path_params['termId'] = params['term_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/terms/{termId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TermDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_term_base(self, term_base_id, **kwargs):  # noqa: E501
        """Get term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_term_base(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :return: TermBaseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_term_base_with_http_info(term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_term_base_with_http_info(term_base_id, **kwargs)  # noqa: E501
            return data

    def get_term_base_with_http_info(self, term_base_id, **kwargs):  # noqa: E501
        """Get term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_term_base_with_http_info(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :return: TermBaseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_term_base" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `get_term_base`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TermBaseDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_term_base_metadata(self, term_base_id, **kwargs):  # noqa: E501
        """Get term base metadata  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_term_base_metadata(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :return: MetadataTbDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_term_base_metadata_with_http_info(term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_term_base_metadata_with_http_info(term_base_id, **kwargs)  # noqa: E501
            return data

    def get_term_base_metadata_with_http_info(self, term_base_id, **kwargs):  # noqa: E501
        """Get term base metadata  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_term_base_metadata_with_http_info(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :return: MetadataTbDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_term_base_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `get_term_base_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataTbDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_translation_resources(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """Get translation resources  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_translation_resources(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :return: TranslationResourcesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_translation_resources_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_translation_resources_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
            return data

    def get_translation_resources_with_http_info(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """Get translation resources  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_translation_resources_with_http_info(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :return: TranslationResourcesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_uid', 'job_uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_translation_resources" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `get_translation_resources`")  # noqa: E501
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `get_translation_resources`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/jobs/{jobUid}/translationResources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TranslationResourcesDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_term_base(self, content_disposition, term_base_id, **kwargs):  # noqa: E501
        """Upload term base  # noqa: E501

         Terms can be imported from XLS/XLSX and TBX file formats into a term base. See <a target=\"_blank\" href=\"https://help.memsource.com/hc/en-us/articles/115003681851-Term-Bases\">Memsource Wiki</a>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_term_base(content_disposition, term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str content_disposition: must match pattern `filename\\*=UTF-8''(.+)` (required)
        :param int term_base_id: (required)
        :param InputStream body:
        :param str charset:
        :param bool strict_lang_matching:
        :param bool update_terms:
        :return: ImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_term_base_with_http_info(content_disposition, term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.import_term_base_with_http_info(content_disposition, term_base_id, **kwargs)  # noqa: E501
            return data

    def import_term_base_with_http_info(self, content_disposition, term_base_id, **kwargs):  # noqa: E501
        """Upload term base  # noqa: E501

         Terms can be imported from XLS/XLSX and TBX file formats into a term base. See <a target=\"_blank\" href=\"https://help.memsource.com/hc/en-us/articles/115003681851-Term-Bases\">Memsource Wiki</a>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_term_base_with_http_info(content_disposition, term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str content_disposition: must match pattern `filename\\*=UTF-8''(.+)` (required)
        :param int term_base_id: (required)
        :param InputStream body:
        :param str charset:
        :param bool strict_lang_matching:
        :param bool update_terms:
        :return: ImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['content_disposition', 'term_base_id', 'body', 'charset', 'strict_lang_matching', 'update_terms']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_term_base" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'content_disposition' is set
        if ('content_disposition' not in params or
                params['content_disposition'] is None):
            raise ValueError("Missing the required parameter `content_disposition` when calling `import_term_base`")  # noqa: E501
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `import_term_base`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []
        if 'charset' in params:
            query_params.append(('charset', params['charset']))  # noqa: E501
        if 'strict_lang_matching' in params:
            query_params.append(('strictLangMatching', params['strict_lang_matching']))  # noqa: E501
        if 'update_terms' in params:
            query_params.append(('updateTerms', params['update_terms']))  # noqa: E501

        header_params = {}
        if 'content_disposition' in params:
            header_params['Content-Disposition'] = params['content_disposition']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_term_bases(self, **kwargs):  # noqa: E501
        """List term bases  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_term_bases(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name:
        :param list[str] lang: Language of the term base
        :param str client_id:
        :param str domain_id:
        :param str sub_domain_id:
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoTermBaseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_term_bases_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_term_bases_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_term_bases_with_http_info(self, **kwargs):  # noqa: E501
        """List term bases  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_term_bases_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name:
        :param list[str] lang: Language of the term base
        :param str client_id:
        :param str domain_id:
        :param str sub_domain_id:
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoTermBaseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'lang', 'client_id', 'domain_id', 'sub_domain_id', 'page_number', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_term_bases" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_size' in params and params['page_size'] > 50:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_term_bases`, must be a value less than or equal to `50`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_term_bases`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'lang' in params:
            query_params.append(('lang', params['lang']))  # noqa: E501
            collection_formats['lang'] = 'multi'  # noqa: E501
        if 'client_id' in params:
            query_params.append(('clientId', params['client_id']))  # noqa: E501
        if 'domain_id' in params:
            query_params.append(('domainId', params['domain_id']))  # noqa: E501
        if 'sub_domain_id' in params:
            query_params.append(('subDomainId', params['sub_domain_id']))  # noqa: E501
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDtoTermBaseDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_terms_of_concept(self, term_base_id, concept_id, **kwargs):  # noqa: E501
        """Get terms of concept  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_terms_of_concept(term_base_id, concept_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str concept_id: (required)
        :return: ConceptDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_terms_of_concept_with_http_info(term_base_id, concept_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_terms_of_concept_with_http_info(term_base_id, concept_id, **kwargs)  # noqa: E501
            return data

    def list_terms_of_concept_with_http_info(self, term_base_id, concept_id, **kwargs):  # noqa: E501
        """Get terms of concept  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_terms_of_concept_with_http_info(term_base_id, concept_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str concept_id: (required)
        :return: ConceptDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'concept_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_terms_of_concept" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `list_terms_of_concept`")  # noqa: E501
        # verify the required parameter 'concept_id' is set
        if ('concept_id' not in params or
                params['concept_id'] is None):
            raise ValueError("Missing the required parameter `concept_id` when calling `list_terms_of_concept`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501
        if 'concept_id' in params:
            path_params['conceptId'] = params['concept_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/concepts/{conceptId}/terms', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConceptDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_terms(self, term_base_id, **kwargs):  # noqa: E501
        """Search term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_terms(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param TermBaseSearchRequestDto body:
        :return: SearchResponseListTbDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_terms_with_http_info(term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.search_terms_with_http_info(term_base_id, **kwargs)  # noqa: E501
            return data

    def search_terms_with_http_info(self, term_base_id, **kwargs):  # noqa: E501
        """Search term base  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_terms_with_http_info(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param TermBaseSearchRequestDto body:
        :return: SearchResponseListTbDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_terms" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `search_terms`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchResponseListTbDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_terms_by_job1(self, job_uid, project_uid, **kwargs):  # noqa: E501
        """Search job's term bases  # noqa: E501

        Search all read term bases assigned to the job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_terms_by_job1(job_uid, project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str project_uid: (required)
        :param SearchTbByJobRequestDto body:
        :return: SearchTbResponseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_terms_by_job1_with_http_info(job_uid, project_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.search_terms_by_job1_with_http_info(job_uid, project_uid, **kwargs)  # noqa: E501
            return data

    def search_terms_by_job1_with_http_info(self, job_uid, project_uid, **kwargs):  # noqa: E501
        """Search job's term bases  # noqa: E501

        Search all read term bases assigned to the job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_terms_by_job1_with_http_info(job_uid, project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str project_uid: (required)
        :param SearchTbByJobRequestDto body:
        :return: SearchTbResponseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'project_uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_terms_by_job1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `search_terms_by_job1`")  # noqa: E501
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `search_terms_by_job1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v2/projects/{projectUid}/jobs/{jobUid}/termBases/searchByJob', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchTbResponseListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_terms_in_text_by_job_v2(self, job_uid, project_uid, **kwargs):  # noqa: E501
        """Search terms in text  # noqa: E501

        Search in text in all read term bases assigned to the job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_terms_in_text_by_job_v2(job_uid, project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str project_uid: (required)
        :param SearchTbInTextByJobRequestDto body:
        :return: SearchInTextResponseList2Dto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_terms_in_text_by_job_v2_with_http_info(job_uid, project_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.search_terms_in_text_by_job_v2_with_http_info(job_uid, project_uid, **kwargs)  # noqa: E501
            return data

    def search_terms_in_text_by_job_v2_with_http_info(self, job_uid, project_uid, **kwargs):  # noqa: E501
        """Search terms in text  # noqa: E501

        Search in text in all read term bases assigned to the job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_terms_in_text_by_job_v2_with_http_info(job_uid, project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str project_uid: (required)
        :param SearchTbInTextByJobRequestDto body:
        :return: SearchInTextResponseList2Dto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'project_uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_terms_in_text_by_job_v2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `search_terms_in_text_by_job_v2`")  # noqa: E501
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `search_terms_in_text_by_job_v2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v2/projects/{projectUid}/jobs/{jobUid}/termBases/searchInTextByJob', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchInTextResponseList2Dto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_project_template_term_bases(self, project_template_id, **kwargs):  # noqa: E501
        """Edit term bases in project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_project_template_term_bases(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :param SetProjectTemplateTermBaseDto body:
        :return: ProjectTemplateTermBaseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_project_template_term_bases_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_project_template_term_bases_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def set_project_template_term_bases_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Edit term bases in project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_project_template_term_bases_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :param SetProjectTemplateTermBaseDto body:
        :return: ProjectTemplateTermBaseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_project_template_term_bases" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `set_project_template_term_bases`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}/termBases', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectTemplateTermBaseListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_term(self, term_base_id, term_id, **kwargs):  # noqa: E501
        """Edit term  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_term(term_base_id, term_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str term_id: (required)
        :param TermEditDto body:
        :return: TermDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_term_with_http_info(term_base_id, term_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_term_with_http_info(term_base_id, term_id, **kwargs)  # noqa: E501
            return data

    def update_term_with_http_info(self, term_base_id, term_id, **kwargs):  # noqa: E501
        """Edit term  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_term_with_http_info(term_base_id, term_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param str term_id: (required)
        :param TermEditDto body:
        :return: TermDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'term_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_term" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `update_term`")  # noqa: E501
        # verify the required parameter 'term_id' is set
        if ('term_id' not in params or
                params['term_id'] is None):
            raise ValueError("Missing the required parameter `term_id` when calling `update_term`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501
        if 'term_id' in params:
            path_params['termId'] = params['term_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}/terms/{termId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TermDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_term_base(self, term_base_id, **kwargs):  # noqa: E501
        """Edit term base  # noqa: E501

        It is possible to add new languages only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_term_base(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param TermBaseEditDto body:
        :return: TermBaseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_term_base_with_http_info(term_base_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_term_base_with_http_info(term_base_id, **kwargs)  # noqa: E501
            return data

    def update_term_base_with_http_info(self, term_base_id, **kwargs):  # noqa: E501
        """Edit term base  # noqa: E501

        It is possible to add new languages only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_term_base_with_http_info(term_base_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int term_base_id: (required)
        :param TermBaseEditDto body:
        :return: TermBaseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term_base_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_term_base" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term_base_id' is set
        if ('term_base_id' not in params or
                params['term_base_id'] is None):
            raise ValueError("Missing the required parameter `term_base_id` when calling `update_term_base`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'term_base_id' in params:
            path_params['termBaseId'] = params['term_base_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/termBases/{termBaseId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TermBaseDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
