# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from memsource_cli.api_client import ApiClient


class AnalysisApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def batch_edit_analyses(self, **kwargs):  # noqa: E501
        """Edit analyses (batch)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_edit_analyses(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BulkEditAnalyseDto body:
        :return: list[AnalyseDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.batch_edit_analyses_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.batch_edit_analyses_with_http_info(**kwargs)  # noqa: E501
            return data

    def batch_edit_analyses_with_http_info(self, **kwargs):  # noqa: E501
        """Edit analyses (batch)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_edit_analyses_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BulkEditAnalyseDto body:
        :return: list[AnalyseDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_edit_analyses" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/analyses/bulk', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AnalyseDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bulk_delete_analyses(self, **kwargs):  # noqa: E501
        """Delete analyses (batch)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_analyses(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BulkDeleteAnalyseDto body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_delete_analyses_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.bulk_delete_analyses_with_http_info(**kwargs)  # noqa: E501
            return data

    def bulk_delete_analyses_with_http_info(self, **kwargs):  # noqa: E501
        """Delete analyses (batch)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_analyses_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BulkDeleteAnalyseDto body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_delete_analyses" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/analyses/bulk', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_analyse_async(self, **kwargs):  # noqa: E501
        """Create analysis  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_analyse_async(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAnalyseAsyncDto body:
        :return: AsyncAnalyseResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_analyse_async_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_analyse_async_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_analyse_async_with_http_info(self, **kwargs):  # noqa: E501
        """Create analysis  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_analyse_async_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAnalyseAsyncDto body:
        :return: AsyncAnalyseResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_analyse_async" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/analyses', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncAnalyseResponseDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_analyses_for_langs(self, **kwargs):  # noqa: E501
        """Create analyses by languages  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_analyses_for_langs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAnalyseListAsyncDto body:
        :return: AsyncAnalyseListResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_analyses_for_langs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_analyses_for_langs_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_analyses_for_langs_with_http_info(self, **kwargs):  # noqa: E501
        """Create analyses by languages  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_analyses_for_langs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAnalyseListAsyncDto body:
        :return: AsyncAnalyseListResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_analyses_for_langs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/analyses/byLanguages', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncAnalyseListResponseDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_analyses_for_providers(self, **kwargs):  # noqa: E501
        """Create analyses by providers  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_analyses_for_providers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAnalyseListAsyncDto body:
        :return: AsyncAnalyseListResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_analyses_for_providers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_analyses_for_providers_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_analyses_for_providers_with_http_info(self, **kwargs):  # noqa: E501
        """Create analyses by providers  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_analyses_for_providers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAnalyseListAsyncDto body:
        :return: AsyncAnalyseListResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_analyses_for_providers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/analyses/byProviders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncAnalyseListResponseDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete(self, analyse_id, **kwargs):  # noqa: E501
        """Delete analysis  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(analyse_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analyse_id: (required)
        :param bool purge:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_with_http_info(analyse_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_with_http_info(analyse_id, **kwargs)  # noqa: E501
            return data

    def delete_with_http_info(self, analyse_id, **kwargs):  # noqa: E501
        """Delete analysis  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_with_http_info(analyse_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analyse_id: (required)
        :param bool purge:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['analyse_id', 'purge', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'analyse_id' is set
        if ('analyse_id' not in params or
                params['analyse_id'] is None):
            raise ValueError("Missing the required parameter `analyse_id` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analyse_id' in params:
            path_params['analyseId'] = params['analyse_id']  # noqa: E501

        query_params = []
        if 'purge' in params:
            query_params.append(('purge', params['purge']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/analyses/{analyseId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_analyse(self, analyse_id, format, **kwargs):  # noqa: E501
        """Download analysis  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_analyse(analyse_id, format, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int analyse_id: (required)
        :param str format: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_analyse_with_http_info(analyse_id, format, **kwargs)  # noqa: E501
        else:
            (data) = self.download_analyse_with_http_info(analyse_id, format, **kwargs)  # noqa: E501
            return data

    def download_analyse_with_http_info(self, analyse_id, format, **kwargs):  # noqa: E501
        """Download analysis  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_analyse_with_http_info(analyse_id, format, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int analyse_id: (required)
        :param str format: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['analyse_id', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_analyse" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'analyse_id' is set
        if ('analyse_id' not in params or
                params['analyse_id'] is None):
            raise ValueError("Missing the required parameter `analyse_id` when calling `download_analyse`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in params or
                params['format'] is None):
            raise ValueError("Missing the required parameter `format` when calling `download_analyse`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analyse_id' in params:
            path_params['analyseId'] = params['analyse_id']  # noqa: E501

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/analyses/{analyseId}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analyse_language_part(self, analyse_id, analyse_language_part_id, **kwargs):  # noqa: E501
        """Get analysis language part  # noqa: E501

        Returns analysis language pair  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analyse_language_part(analyse_id, analyse_language_part_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int analyse_id: (required)
        :param int analyse_language_part_id: (required)
        :return: AnalyseLanguagePartDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_analyse_language_part_with_http_info(analyse_id, analyse_language_part_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_analyse_language_part_with_http_info(analyse_id, analyse_language_part_id, **kwargs)  # noqa: E501
            return data

    def get_analyse_language_part_with_http_info(self, analyse_id, analyse_language_part_id, **kwargs):  # noqa: E501
        """Get analysis language part  # noqa: E501

        Returns analysis language pair  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analyse_language_part_with_http_info(analyse_id, analyse_language_part_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int analyse_id: (required)
        :param int analyse_language_part_id: (required)
        :return: AnalyseLanguagePartDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['analyse_id', 'analyse_language_part_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analyse_language_part" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'analyse_id' is set
        if ('analyse_id' not in params or
                params['analyse_id'] is None):
            raise ValueError("Missing the required parameter `analyse_id` when calling `get_analyse_language_part`")  # noqa: E501
        # verify the required parameter 'analyse_language_part_id' is set
        if ('analyse_language_part_id' not in params or
                params['analyse_language_part_id'] is None):
            raise ValueError("Missing the required parameter `analyse_language_part_id` when calling `get_analyse_language_part`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analyse_id' in params:
            path_params['analyseId'] = params['analyse_id']  # noqa: E501
        if 'analyse_language_part_id' in params:
            path_params['analyseLanguagePartId'] = params['analyse_language_part_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/analyses/{analyseId}/analyseLanguageParts/{analyseLanguagePartId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnalyseLanguagePartDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analyse_v2(self, analyse_id, **kwargs):  # noqa: E501
        """Get analysis  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analyse_v2(analyse_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int analyse_id: (required)
        :return: AnalyseV2Dto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_analyse_v2_with_http_info(analyse_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_analyse_v2_with_http_info(analyse_id, **kwargs)  # noqa: E501
            return data

    def get_analyse_v2_with_http_info(self, analyse_id, **kwargs):  # noqa: E501
        """Get analysis  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analyse_v2_with_http_info(analyse_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int analyse_id: (required)
        :return: AnalyseV2Dto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['analyse_id', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analyse_v2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'analyse_id' is set
        if ('analyse_id' not in params or
                params['analyse_id'] is None):
            raise ValueError("Missing the required parameter `analyse_id` when calling `get_analyse_v2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analyse_id' in params:
            path_params['analyseId'] = params['analyse_id']  # noqa: E501

        query_params = []
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v2/analyses/{analyseId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnalyseV2Dto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_part_analyse(self, analyse_id, job_uid, **kwargs):  # noqa: E501
        """Get jobs analysis  # noqa: E501

        Returns job's analyse  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_part_analyse(analyse_id, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int analyse_id: (required)
        :param str job_uid: (required)
        :return: AnalyseJobDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_job_part_analyse_with_http_info(analyse_id, job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_job_part_analyse_with_http_info(analyse_id, job_uid, **kwargs)  # noqa: E501
            return data

    def get_job_part_analyse_with_http_info(self, analyse_id, job_uid, **kwargs):  # noqa: E501
        """Get jobs analysis  # noqa: E501

        Returns job's analyse  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_part_analyse_with_http_info(analyse_id, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int analyse_id: (required)
        :param str job_uid: (required)
        :return: AnalyseJobDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['analyse_id', 'job_uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_part_analyse" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'analyse_id' is set
        if ('analyse_id' not in params or
                params['analyse_id'] is None):
            raise ValueError("Missing the required parameter `analyse_id` when calling `get_job_part_analyse`")  # noqa: E501
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `get_job_part_analyse`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analyse_id' in params:
            path_params['analyseId'] = params['analyse_id']  # noqa: E501
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/analyses/{analyseId}/jobs/{jobUid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnalyseJobDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_by_project_v2(self, project_uid, **kwargs):  # noqa: E501
        """List analyses by project  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_by_project_v2(project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param int page_number:
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoAnalyseV2Dto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_by_project_v2_with_http_info(project_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_by_project_v2_with_http_info(project_uid, **kwargs)  # noqa: E501
            return data

    def list_by_project_v2_with_http_info(self, project_uid, **kwargs):  # noqa: E501
        """List analyses by project  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_by_project_v2_with_http_info(project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param int page_number:
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoAnalyseV2Dto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_uid', 'page_number', 'page_size', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_by_project_v2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `list_by_project_v2`")  # noqa: E501

        if 'page_number' in params and params['page_number'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_number` when calling `list_by_project_v2`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 50:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_by_project_v2`, must be a value less than or equal to `50`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_by_project_v2`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501

        query_params = []
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v2/projects/{projectUid}/analyses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDtoAnalyseV2Dto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_job_parts(self, analyse_id, analyse_language_part_id, **kwargs):  # noqa: E501
        """List jobs of analyses  # noqa: E501

        Returns list of job's analyses  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_job_parts(analyse_id, analyse_language_part_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int analyse_id: (required)
        :param int analyse_language_part_id: (required)
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoAnalyseJobDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_job_parts_with_http_info(analyse_id, analyse_language_part_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_job_parts_with_http_info(analyse_id, analyse_language_part_id, **kwargs)  # noqa: E501
            return data

    def list_job_parts_with_http_info(self, analyse_id, analyse_language_part_id, **kwargs):  # noqa: E501
        """List jobs of analyses  # noqa: E501

        Returns list of job's analyses  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_job_parts_with_http_info(analyse_id, analyse_language_part_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int analyse_id: (required)
        :param int analyse_language_part_id: (required)
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoAnalyseJobDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['analyse_id', 'analyse_language_part_id', 'page_number', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_job_parts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'analyse_id' is set
        if ('analyse_id' not in params or
                params['analyse_id'] is None):
            raise ValueError("Missing the required parameter `analyse_id` when calling `list_job_parts`")  # noqa: E501
        # verify the required parameter 'analyse_language_part_id' is set
        if ('analyse_language_part_id' not in params or
                params['analyse_language_part_id'] is None):
            raise ValueError("Missing the required parameter `analyse_language_part_id` when calling `list_job_parts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analyse_id' in params:
            path_params['analyseId'] = params['analyse_id']  # noqa: E501
        if 'analyse_language_part_id' in params:
            path_params['analyseLanguagePartId'] = params['analyse_language_part_id']  # noqa: E501

        query_params = []
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/analyses/{analyseId}/analyseLanguageParts/{analyseLanguagePartId}/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDtoAnalyseJobDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_part_analyse1(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """List analyses  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_part_analyse1(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :param int page_number:
        :param int page_size:
        :return: PageDtoAnalyseV2Dto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_part_analyse1_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_part_analyse1_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
            return data

    def list_part_analyse1_with_http_info(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """List analyses  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_part_analyse1_with_http_info(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :param int page_number:
        :param int page_size:
        :return: PageDtoAnalyseV2Dto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_uid', 'job_uid', 'page_number', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_part_analyse1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `list_part_analyse1`")  # noqa: E501
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `list_part_analyse1`")  # noqa: E501

        if 'page_number' in params and params['page_number'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_number` when calling `list_part_analyse1`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 50:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_part_analyse1`, must be a value less than or equal to `50`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_part_analyse1`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v2/projects/{projectUid}/jobs/{jobUid}/analyses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDtoAnalyseV2Dto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
