from user_agent import base
from datetime import datetime

#
base.OS_PLATFORM.update(
    {
        "win": base.OS_PLATFORM["win"]
        + (
            "Windows NT 10.0",  # Windows 10
            "Windows NT 11.0",  # Windows 11
        ),
        "mac": base.OS_PLATFORM["mac"]
        + (
            "Macintosh; Intel Mac OS X 10.13",
            "Macintosh; Intel Mac OS X 10.14",
            "Macintosh; Intel Mac OS X 10.15",
        ),
        "android": base.OS_PLATFORM["android"]
        + (
            "Android 7.1.2",  # 2016-12-05
            "Android 8.0",  #
            "Android 8.1",  #
            "Android 9",  #
            "Android 10",  #
            "Android 11",  #
        ),
    }
)
# https://zh.wikipedia.org/wiki/Firefox%E7%89%88%E6%9C%AC%E5%8E%86%E5%8F%B2
base.FIREFOX_VERSION = base.FIREFOX_VERSION + (
    ("52.0", datetime(2017, 3, 7)),
    ("53.0", datetime(2017, 4, 19)),
    ("54.0", datetime(2017, 6, 13)),
    ("55.0", datetime(2017, 8, 8)),
    ("56.0", datetime(2017, 9, 28)),
    ("57.0", datetime(2017, 11, 14)),
    ("58.0", datetime(2018, 1, 23)),
    ("59.0", datetime(2018, 3, 13)),
    ("60.0", datetime(2018, 5, 9)),
    ("61.0", datetime(2018, 6, 26)),
    ("62.0", datetime(2018, 9, 5)),
    ("63.0", datetime(2018, 10, 23)),
    ("64.0", datetime(2018, 12, 11)),
    ("65.0", datetime(2019, 1, 29)),
    ("66.0", datetime(2019, 3, 19)),
    ("67.0", datetime(2019, 5, 21)),
    ("68.0", datetime(2019, 7, 13)),
    ("69.0", datetime(2019, 9, 3)),
    ("70.0", datetime(2019, 10, 22)),
    ("71.0", datetime(2019, 12, 3)),
    ("72.0", datetime(2020, 1, 7)),
    ("73.0", datetime(2020, 2, 11)),
    ("74.0", datetime(2020, 3, 10)),
    ("75.0", datetime(2020, 4, 7)),
    ("76.0", datetime(2020, 5, 5)),
    ("77.0", datetime(2020, 6, 2)),
    ("78.0", datetime(2020, 6, 30)),
    ("79.0", datetime(2020, 7, 28)),
    ("80.0", datetime(2020, 8, 25)),
    ("81.0", datetime(2020, 9, 22)),
    ("82.0", datetime(2020, 10, 20)),
    ("83.0", datetime(2020, 11, 17)),
    ("84.0", datetime(2020, 12, 15)),
    ("85.0", datetime(2021, 1, 26)),
    ("86.0", datetime(2021, 2, 23)),
    ("87.0", datetime(2021, 3, 23)),
    ("88.0", datetime(2021, 4, 20)),
    ("89.0", datetime(2021, 6, 1)),
    ("90.0", datetime(2021, 7, 13)),
    ("91.0", datetime(2021, 8, 10)),
    ("92.0", datetime(2021, 9, 7)),
    ("93.0", datetime(2021, 10, 5)),
    ("94.0", datetime(2021, 11, 2)),
)
# https://google_chrome.zh.downloadastro.com/old_versions/
base.CHROME_BUILD = base.CHROME_BUILD + (
    (57, 2987, 2987),  # 2017-03-30
    (58, 3029, 3029),  # 2017-05-18
    (59, 3071, 3071),  # 2017-07-18
    (60, 3112, 3112),  # 2017-09-14
    (61, 3163, 3163),  # 2017-10-07
    (62, 3202, 3202),  # 2017-11-14
    (63, 3239, 3239),  # 2018-01-05
    (64, 3251, 3282),  # 2017-10-28
    (65, 3325, 3325),  # 2018-03-23
    (66, 3359, 3359),  # 2018-05-18
    (67, 3396, 3396),  # 2018-06-27
    (68, 3440, 3440),  # 2018-08-10
    (69, 3497, 3497),  # 2018-09-21
    (70, 3538, 3538),  # 2018-11-21
    (71, 3578, 3578),  # 2018-12-14
    (72, 3626, 3626),  # 2019-03-01
    (73, 3683, 3683),  # 2019-04-05
    (74, 3729, 3729),  # 2019-05-23
    (75, 3770, 3770),  # 2019-07-18
    (76, 3809, 3809),  # 2019-09-06
    (77, 3865, 3865),  # 2019-10-11
    (78, 3904, 3904),  # 2019-11-21
    (79, 3945, 3945),  # 2020-01-18
    (80, 3987, 3987),  # 2020-04-03
    (81, 4044, 4044),  # 2020-05-07
    (83, 4103, 4103),  # 2020-06-26
    (84, 4147, 4147),  # 2020-08-21
    (85, 4183, 4183),  # 2020-09-23
    (86, 4240, 4240),  # 2020-11-13
    (87, 4280, 4280),  # 2021-01-10
    (89, 4389, 4389),  # 2021-03-06
    (89, 4389, 4389),  # 2021-03-14
    (89, 4389, 4389),  # 2021-04-09
    (90, 4430, 4430),  # 2021-04-16
    (90, 4430, 4430),  # 2021-04-23
    (90, 4430, 4430),  # 2021-05-12
    (91, 4472, 4472),  # 2021-05-27
    (91, 4472, 4472),  # 2021-06-11
    (91, 4472, 4472),  # 2021-06-18
    (91, 4472, 4472),  # 2021-06-24
    (91, 4472, 4472),  # 2021-07-15
    (92, 4515, 4515),  # 2021-07-21
    (92, 4515, 4515),  # 2021-08-05
    (92, 4515, 4515),  # 2021-08-20
    (93, 4577, 4577),  # 2021-09-03
    (94, 4606, 4606),  # 2021-09-25
    (94, 4606, 4606),  # 2021-10-07
    (95, 4638, 4638),  # 2021-10-22
)
#
base.MACOSX_CHROME_BUILD_RANGE.update(
    {
        "10.13": (0, 6),
        "10.14": (0, 6),
        "10.15": (0, 7),
        "11.0": (0, 2),
    }
)

generate_user_agent = base.generate_user_agent
generate_navigator = base.generate_navigator
generate_navigator_js = base.generate_navigator_js
