# Wisconsin Autonomous CLI

This repository holds the WA CLI tool. This tool is expandable and is primarily used to reduce repetitive processes or implements helpful scripts to doing various tasks (like installing packages, etc.).

## Documentation

- [Home](https://wisconsinautonomous.github.io/wa_cli/index.html)
- [Installation](https://wisconsinautonomous.github.io/wa_cli/install.html)
- [Usage Guide](https://wisconsinautonomous.github.io/wa_cli/autoapi/wa_cli/index.html)
- [PyPI](https://pypi.org/project/wa-cli/)
- [Github](https://github.com/WisconsinAutonomous/wa_cli)

## Installation

To setup the WA cli, it is fairly simple. You simply need Python3 installed on your system, and then run the following command:

```
pip3 install wa_cli
```

## Developing

To develop the WA cli, you can do the following.

### Clone the repo

First, clone the wa\_cli repo locally:

```bash
git clone git@github.com:uwsbel/wa_cli.git
cd wa_cli
```

### Install the wa_cli package

_**Note: This installs the  repository using symlinks. This means you can edit the files and test the changes without reinstalling the tool.**_

```bash
python setup.py develop
```

## License 
`wa_cli` is made available under the MIT License. For more details, see [LICENSE](https://github.com/WisconsinAutonomous/wa_cli/blob/develop/LICENSE).

## Support

Contact [Wisconsin Autonomous](mailto:wisconsinautonomous@studentorg.wisc.edu) for any questions or concerns regarding the contents of this repository.

## See Also

Stay up to date with our technical info by following our [blog](https://wa.wisc.edu/blog).

Follow us on [Facebook](https://www.facebook.com/wisconsinautonomous/), [Instagram](https://www.instagram.com/wisconsinautonomous/), and [LinkedIn](https://www.linkedin.com/company/wisconsin-autonomous/about/)!

<br>

<div>
	<img src="https://github.com/WisconsinAutonomous/wa-resources/blob/master/Images/WA.png?raw=true" alt="Wisconsin Autonomous Logo" class="readme-img" height="100px">  
	<img src="https://github.com/WisconsinAutonomous/wa-resources/blob/master/Images/UWCrest.png?raw=true" alt="University of Wisconsin - Madison Crest" class="readme-img" height="100px" align="right">
</div>
