#!/usr/bin/env python3
# -*- coding:utf-8 -*-
import os
from stem.util import term


def start():
    """
        提供能直接连接外网的网络代理
        # TODO: 目前生效的之后socks5代理。其他的如http和 mix 代理，外网的连接测试时，不能使用。
        *     可能的原因：
        *          iptables设置问题，
        *          GFW 防火墙
        *          clash 配置文件

    """
    print(term.format("启动 direct socks5 server (directs5) 服务",
          term.Color.RED), flush=True)
    os.system('cp -r ~/.config/clash /tmp/clash')

    with open('/tmp/clash/config_direct.yaml', 'w') as f:
        f.write("""
# port: 41890
mixed-port: 41080
# socks-port: 41080
allow-lan: true
bind-address: '0.0.0.0'
mode: direct
authentication:
    - "mt:feihuo321"
    - "user2:8ujaho&hkXXHA28276"
log-level: info
ipv6: false
# external-controller: 0.0.0.0:9090
secret: "feihuo321"
proxies: 
proxy-groups:
rules:
    - IP-CIDR,127.0.0.0/8,DIRECT
    - IP-CIDR,10.12.12.0/24,DIRECT
    - MATCH,DIRECT
""")
    os.system(
        "sudo -u debian-tor clash -d /tmp/clash -f /tmp/clash/config_direct.yaml &")


if __name__ == '__main__':
    start()
