"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrustBoundaryType = exports.TrustBoundary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const model_1 = require("./model");
const resource_1 = require("./resource");
class TrustBoundary extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.type = props.type;
        this.tags = props.tags;
        this.technicalAssetsInside = new Set();
        this.trustBoundariesNested = new Set();
        if (this.tags && this.tags.length > 0) {
            model_1.Model.of(this).addTags(...this.tags);
        }
    }
    addTechnicalAssets(...assets) {
        assets.forEach((a) => {
            if (a._trustBoundary && this !== a._trustBoundary) {
                return this.addTrustBoundary(a._trustBoundary);
            }
            this.technicalAssetsInside.add(a);
        });
    }
    addTrustBoundary(boundary) {
        this.trustBoundariesNested.add(boundary);
    }
    isWithinCloud() {
        return [
            TrustBoundaryType.NETWORK_CLOUD_PROVIDER,
            TrustBoundaryType.NETWORK_CLOUD_SECURITY_GROUP,
        ].includes(this.type);
    }
    isNetworkBoundary() {
        return [
            TrustBoundaryType.NETWORK_ON_PREM,
            TrustBoundaryType.NETWORK_DEDICATED_HOSTER,
            TrustBoundaryType.NETWORK_VIRTUAL_LAN,
            TrustBoundaryType.NETWORK_CLOUD_PROVIDER,
            TrustBoundaryType.NETWORK_CLOUD_SECURITY_GROUP,
            TrustBoundaryType.NETWORK_POLICY_NAMESPACE_ISOLATION,
        ].includes(this.type);
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.title]: {
                id: this.id,
                description: this.description ?? null,
                type: this.type,
                tags: Array.from(new Set(this.tags)),
                technical_assets_inside: Array.from(this.technicalAssetsInside).map((a) => a.id),
                trust_boundaries_nested: Array.from(this.trustBoundariesNested).map((t) => t.id),
            },
        };
    }
}
exports.TrustBoundary = TrustBoundary;
_a = JSII_RTTI_SYMBOL_1;
TrustBoundary[_a] = { fqn: "cdktg.TrustBoundary", version: "0.0.40" };
var TrustBoundaryType;
(function (TrustBoundaryType) {
    TrustBoundaryType["NETWORK_ON_PREM"] = "network-on-prem";
    TrustBoundaryType["NETWORK_DEDICATED_HOSTER"] = "network-dedicated-hoster";
    TrustBoundaryType["NETWORK_VIRTUAL_LAN"] = "network-virtual-lan";
    TrustBoundaryType["NETWORK_CLOUD_PROVIDER"] = "network-cloud-provider";
    TrustBoundaryType["NETWORK_CLOUD_SECURITY_GROUP"] = "network-cloud-security-group";
    TrustBoundaryType["NETWORK_POLICY_NAMESPACE_ISOLATION"] = "network-policy-namespace-isolation";
    TrustBoundaryType["EXECUTION_ENVIRONMENT"] = "execution-environment";
})(TrustBoundaryType = exports.TrustBoundaryType || (exports.TrustBoundaryType = {}));
//# sourceMappingURL=data:application/json;base64,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