"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.Encryption = exports.Machine = exports.Technology = exports.Size = exports.TechnicalAssetType = exports.TechnicalAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const communication_1 = require("./communication");
const model_1 = require("./model");
const resource_1 = require("./resource");
const scope_1 = require("./scope");
class TechnicalAsset extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.type = props.type;
        this.usage = props.usage;
        this.humanUse = props.humanUse;
        this.internet = props.internet;
        this.scope = props.scope ?? scope_1.Scope.inScope();
        this.size = props.size;
        this.technology = props.technology;
        this.tags = props.tags;
        this.machine = props.machine;
        this.encryption = props.encryption;
        this.owner = props.owner;
        this.ciaTriad = props.ciaTriad;
        this.multiTenant = props.multiTenant;
        this.redundant = props.redundant;
        this.customDevelopedParts = props.customDevelopedParts ?? false;
        this.dataFormatsAccepted = props.dataFormatsAccepted;
        this.dataAssetsProcessed = new Set();
        this.dataAssetsStored = new Set();
        this.communications = new Array();
        if (this.tags && this.tags.length > 0) {
            model_1.Model.of(this).addTags(...this.tags);
        }
        if (props.trustBoundary) {
            this.trustBoundary = props.trustBoundary;
            this.trustBoundary.addTechnicalAssets(this);
        }
    }
    processes(...assets) {
        assets.forEach((a) => {
            this.dataAssetsProcessed.add(a);
        });
    }
    stores(...assets) {
        assets.forEach((a) => {
            this.dataAssetsStored.add(a);
        });
    }
    isWebApplication() {
        return [
            Technology.WEB_SERVER,
            Technology.WEB_APPLICATION,
            Technology.APPLICATION_SERVER,
            Technology.ERP,
            Technology.CMS,
            Technology.IDENTITIY_PROVIDER,
            Technology.REPORT_ENGINE,
        ].includes(this.technology);
    }
    isWebService() {
        return [Technology.WEB_SERVICE_REST, Technology.WEB_SERVICE_SOAP].includes(this.technology);
    }
    isTrafficForwarding() {
        return [
            Technology.LOAD_BALANCER,
            Technology.REVERSE_PROXY,
            Technology.WAF,
        ].includes(this.technology);
    }
    isInScope() {
        return this.scope === scope_1.Scope.inScope();
    }
    get highestIntegrity() {
        let { integrity: highest } = this.ciaTriad;
        this.dataAssetsProcessed.forEach((a) => {
            if (a.ciaTriad.hasHigherIntegrity(highest)) {
                highest = a.ciaTriad.integrity;
            }
        });
        this.dataAssetsStored.forEach((a) => {
            if (a.ciaTriad.hasHigherIntegrity(highest)) {
                highest = a.ciaTriad.integrity;
            }
        });
        return highest;
    }
    get highestAvailability() {
        let { availability: highest } = this.ciaTriad;
        this.dataAssetsProcessed.forEach((a) => {
            if (a.ciaTriad.hasHigherAvailabilty(highest)) {
                highest = a.ciaTriad.availability;
            }
        });
        this.dataAssetsStored.forEach((a) => {
            if (a.ciaTriad.hasHigherAvailabilty(highest)) {
                highest = a.ciaTriad.availability;
            }
        });
        return highest;
    }
    communicatesWith(id, target, options) {
        const communication = new communication_1.Communication(this, id, {
            source: this,
            target: target,
            ...options,
        });
        this.communications.push(communication);
        return communication;
    }
    /**
     * @internal
     */
    get _trustBoundary() {
        return this.trustBoundary;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const threagile = {
            [this.title]: {
                id: this.id,
                description: this.description ?? null,
                type: this.type,
                usage: this.usage,
                used_as_client_by_human: this.humanUse,
                ...this.scope?._toThreagile(),
                size: this.size,
                technology: this.technology,
                tags: Array.from(new Set(this.tags)),
                internet: this.internet,
                machine: this.machine,
                encryption: this.encryption,
                owner: this.owner,
                ...this.ciaTriad._toThreagile(),
                multi_tenant: this.multiTenant,
                redundant: this.redundant,
                custom_developed_parts: this.customDevelopedParts,
                data_assets_processed: Array.from(this.dataAssetsProcessed).map((a) => a.id),
                data_assets_stored: Array.from(this.dataAssetsStored).map((a) => a.id),
                data_formats_accepted: this.dataFormatsAccepted,
            },
        };
        threagile[this.title].communication_links = this.communications.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        return threagile;
    }
}
exports.TechnicalAsset = TechnicalAsset;
_a = JSII_RTTI_SYMBOL_1;
TechnicalAsset[_a] = { fqn: "cdktg.TechnicalAsset", version: "0.0.40" };
var TechnicalAssetType;
(function (TechnicalAssetType) {
    TechnicalAssetType["EXTERNAL_ENTITY"] = "external-entity";
    TechnicalAssetType["PROCESS"] = "process";
    TechnicalAssetType["DATASTORE"] = "datastore";
})(TechnicalAssetType = exports.TechnicalAssetType || (exports.TechnicalAssetType = {}));
var Size;
(function (Size) {
    Size["SYSTEM"] = "system";
    Size["SERVICE"] = "service";
    Size["APPLICATION"] = "application";
    Size["COMPONENT"] = "component";
})(Size = exports.Size || (exports.Size = {}));
var Technology;
(function (Technology) {
    Technology["UNKNOWN"] = "unknown-technology";
    Technology["CLIENT_SYSTEM"] = "client-system";
    Technology["BROWSER"] = "browser";
    Technology["DESKTOP"] = "desktop";
    Technology["MOBILE_APP"] = "mobile-app";
    Technology["DEVOPS_CLIENT"] = "devops-client";
    Technology["WEB_SERVER"] = "web-server";
    Technology["WEB_APPLICATION"] = "web-application";
    Technology["APPLICATION_SERVER"] = "application-server";
    Technology["DATABASE"] = "database";
    Technology["FILE_SERVER"] = "file-server";
    Technology["LOCAL_FILE_SERVER"] = "local-file-system";
    Technology["ERP"] = "erp";
    Technology["CMS"] = "cms";
    Technology["WEB_SERVICE_REST"] = "web-service-rest";
    Technology["WEB_SERVICE_SOAP"] = "web-service-soap";
    Technology["EJB"] = "ejb";
    Technology["SEARCH_INDEX"] = "search-index";
    Technology["SEARCH_ENGINE"] = "search-engine";
    Technology["SERVICE_REGISTRY"] = "service-registry";
    Technology["REVERSE_PROXY"] = "reverse-proxy";
    Technology["LOAD_BALANCER"] = "load-balancer";
    Technology["BUILD_PIPELINE"] = "build-pipeline";
    Technology["SOURCECODE_REPOSITORY"] = "sourcecode-repository";
    Technology["ARTIFACT_REGISTRY"] = "artifact-registry";
    Technology["CODE_INSPECTION_PLATFORM"] = "code-inspection-platform";
    Technology["MONITORING"] = "monitoring";
    Technology["LDAP_SERVER"] = "ldap-server";
    Technology["CONTAINER_PLATFORM"] = "container-platform";
    Technology["BATCH_PROCESSING"] = "batch-processing";
    Technology["EVENT_LISTENER"] = "event-listener";
    Technology["IDENTITIY_PROVIDER"] = "identity-provider";
    Technology["IDENTITY_STORE_LDAP"] = "identity-store-ldap";
    Technology["IDENTITY_STORE_DATABASE"] = "identity-store-database";
    Technology["TOOL"] = "tool";
    Technology["CLI"] = "cli";
    Technology["TASK"] = "task";
    Technology["FUNCTION"] = "function";
    Technology["GATEWAY"] = "gateway";
    Technology["IOT_DEVICE"] = "iot-device";
    Technology["MESSAGE_QUEUE"] = "message-queue";
    Technology["STREAM_PROCESSING"] = "stream-processing";
    Technology["SERVICE_MESH"] = "service-mesh";
    Technology["DATA_LAKE"] = "data-lake";
    Technology["REPORT_ENGINE"] = "report-engine";
    Technology["AI"] = "ai";
    Technology["MAIL_SERVER"] = "mail-server";
    Technology["VAULT"] = "vault";
    Technology["HASM"] = "hsm";
    Technology["WAF"] = "waf";
    Technology["IDS"] = "ids";
    Technology["IPS"] = "ips";
    Technology["SCHEDULER"] = "scheduler";
    Technology["MAINFRAME"] = "mainframe";
    Technology["BLOCK_STORAGE"] = "block-storage";
    Technology["LIBRARY"] = "library";
})(Technology = exports.Technology || (exports.Technology = {}));
var Machine;
(function (Machine) {
    Machine["PHYSICAL"] = "physical";
    Machine["VIRTUAL"] = "virtual";
    Machine["CONTAINER"] = "container";
    Machine["SERVERLESS"] = "serverless";
})(Machine = exports.Machine || (exports.Machine = {}));
var Encryption;
(function (Encryption) {
    Encryption["NONE"] = "none";
    Encryption["TRANSPARENT"] = "transparent";
    Encryption["SYMMETRIC_SHARED_KEY"] = "data-with-symmetric-shared-key";
    Encryption["ASYMMETRIC_SHARED_KEY"] = "data-with-asymmetric-shared-key";
    Encryption["ENDUSER_INDIVIDUAL_KEY"] = "data-with-enduser-individual-key";
})(Encryption = exports.Encryption || (exports.Encryption = {}));
var DataFormat;
(function (DataFormat) {
    DataFormat["JSON"] = "json";
    DataFormat["XML"] = "xml";
    DataFormat["SERIALIZATION"] = "serialization";
    DataFormat["FILE"] = "file";
    DataFormat["CSV"] = "csv";
})(DataFormat = exports.DataFormat || (exports.DataFormat = {}));
//# sourceMappingURL=data:application/json;base64,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