import { Construct } from "constructs";
import { Integrity, Availability, CIATriad } from "./cia-triad";
import { Communication, CommunicationOptions } from "./communication";
import { DataAsset } from "./data-asset";
import { Resource, ResourceProps } from "./resource";
import { Scope } from "./scope";
import * as spec from "./spec/threatgile.generated";
import { TrustBoundary } from "./trust-boundary";
import { Usage } from "./usage";
export interface TechnicalAssetProps extends ResourceProps {
    readonly type: TechnicalAssetType;
    readonly usage: Usage;
    readonly humanUse: boolean;
    readonly scope?: Scope;
    readonly size: Size;
    readonly technology: Technology;
    readonly tags?: string[];
    readonly internet: boolean;
    readonly machine: Machine;
    readonly encryption: Encryption;
    readonly owner?: string;
    readonly ciaTriad: CIATriad;
    readonly multiTenant: boolean;
    readonly redundant: boolean;
    readonly trustBoundary?: TrustBoundary;
    readonly customDevelopedParts?: boolean;
    readonly dataFormatsAccepted?: DataFormat[];
}
export declare class TechnicalAsset extends Resource {
    readonly type: TechnicalAssetType;
    readonly usage: Usage;
    readonly internet: boolean;
    readonly humanUse: boolean;
    readonly scope?: Scope;
    readonly size: Size;
    readonly technology: Technology;
    readonly tags?: string[];
    readonly machine: Machine;
    readonly encryption: Encryption;
    readonly owner?: string;
    readonly ciaTriad: CIATriad;
    readonly multiTenant: boolean;
    readonly redundant: boolean;
    readonly customDevelopedParts: boolean;
    readonly dataFormatsAccepted?: DataFormat[];
    protected trustBoundary?: TrustBoundary;
    private dataAssetsProcessed;
    private dataAssetsStored;
    private communications;
    constructor(scope: Construct, id: string, props: TechnicalAssetProps);
    processes(...assets: DataAsset[]): void;
    stores(...assets: DataAsset[]): void;
    isWebApplication(): boolean;
    isWebService(): boolean;
    isTrafficForwarding(): boolean;
    isInScope(): boolean;
    get highestIntegrity(): Integrity;
    get highestAvailability(): Availability;
    communicatesWith(id: string, target: TechnicalAsset, options: CommunicationOptions): Communication;
    /**
     * @internal
     */
    get _trustBoundary(): TrustBoundary | undefined;
    /**
     * @internal
     */
    _toThreagile(): spec.Threagile["technical_assets"];
}
export declare enum TechnicalAssetType {
    EXTERNAL_ENTITY = "external-entity",
    PROCESS = "process",
    DATASTORE = "datastore"
}
export declare enum Size {
    SYSTEM = "system",
    SERVICE = "service",
    APPLICATION = "application",
    COMPONENT = "component"
}
export declare enum Technology {
    UNKNOWN = "unknown-technology",
    CLIENT_SYSTEM = "client-system",
    BROWSER = "browser",
    DESKTOP = "desktop",
    MOBILE_APP = "mobile-app",
    DEVOPS_CLIENT = "devops-client",
    WEB_SERVER = "web-server",
    WEB_APPLICATION = "web-application",
    APPLICATION_SERVER = "application-server",
    DATABASE = "database",
    FILE_SERVER = "file-server",
    LOCAL_FILE_SERVER = "local-file-system",
    ERP = "erp",
    CMS = "cms",
    WEB_SERVICE_REST = "web-service-rest",
    WEB_SERVICE_SOAP = "web-service-soap",
    EJB = "ejb",
    SEARCH_INDEX = "search-index",
    SEARCH_ENGINE = "search-engine",
    SERVICE_REGISTRY = "service-registry",
    REVERSE_PROXY = "reverse-proxy",
    LOAD_BALANCER = "load-balancer",
    BUILD_PIPELINE = "build-pipeline",
    SOURCECODE_REPOSITORY = "sourcecode-repository",
    ARTIFACT_REGISTRY = "artifact-registry",
    CODE_INSPECTION_PLATFORM = "code-inspection-platform",
    MONITORING = "monitoring",
    LDAP_SERVER = "ldap-server",
    CONTAINER_PLATFORM = "container-platform",
    BATCH_PROCESSING = "batch-processing",
    EVENT_LISTENER = "event-listener",
    IDENTITIY_PROVIDER = "identity-provider",
    IDENTITY_STORE_LDAP = "identity-store-ldap",
    IDENTITY_STORE_DATABASE = "identity-store-database",
    TOOL = "tool",
    CLI = "cli",
    TASK = "task",
    FUNCTION = "function",
    GATEWAY = "gateway",
    IOT_DEVICE = "iot-device",
    MESSAGE_QUEUE = "message-queue",
    STREAM_PROCESSING = "stream-processing",
    SERVICE_MESH = "service-mesh",
    DATA_LAKE = "data-lake",
    REPORT_ENGINE = "report-engine",
    AI = "ai",
    MAIL_SERVER = "mail-server",
    VAULT = "vault",
    HASM = "hsm",
    WAF = "waf",
    IDS = "ids",
    IPS = "ips",
    SCHEDULER = "scheduler",
    MAINFRAME = "mainframe",
    BLOCK_STORAGE = "block-storage",
    LIBRARY = "library"
}
export declare enum Machine {
    PHYSICAL = "physical",
    VIRTUAL = "virtual",
    CONTAINER = "container",
    SERVERLESS = "serverless"
}
export declare enum Encryption {
    NONE = "none",
    TRANSPARENT = "transparent",
    SYMMETRIC_SHARED_KEY = "data-with-symmetric-shared-key",
    ASYMMETRIC_SHARED_KEY = "data-with-asymmetric-shared-key",
    ENDUSER_INDIVIDUAL_KEY = "data-with-enduser-individual-key"
}
export declare enum DataFormat {
    JSON = "json",
    XML = "xml",
    SERIALIZATION = "serialization",
    FILE = "file",
    CSV = "csv"
}
