"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedRuntime = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const model_1 = require("./model");
const resource_1 = require("./resource");
class SharedRuntime extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.tags = props.tags;
        this.technicalAssetsRunning = new Set();
        if (this.tags && this.tags.length > 0) {
            model_1.Model.of(this).addTags(...this.tags);
        }
    }
    runs(...assets) {
        assets.forEach((a) => {
            this.technicalAssetsRunning.add(a);
        });
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.title]: {
                id: this.id,
                description: this.description ?? null,
                tags: Array.from(new Set(this.tags)),
                technical_assets_running: Array.from(this.technicalAssetsRunning).map((a) => a.id),
            },
        };
    }
}
exports.SharedRuntime = SharedRuntime;
_a = JSII_RTTI_SYMBOL_1;
SharedRuntime[_a] = { fqn: "cdktg.SharedRuntime", version: "0.0.40" };
//# sourceMappingURL=data:application/json;base64,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