"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RiskAspect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const annotations_1 = require("./annotations");
const communication_1 = require("./communication");
class RiskAspect {
    visit(node) {
        if (communication_1.Communication.isCommunicationl(node)) {
            // When a technical communication link does not send or receive any data assets, this is
            // an indicator for an unnecessary communication link (or for an incomplete model).
            if (!node.hasDataAssets()) {
                if (node.source.isInScope() || node.target.isInScope()) {
                    annotations_1.Annotations.of(node).addWarning("Unnecessary Communication Link");
                }
            }
        }
    }
}
exports.RiskAspect = RiskAspect;
_a = JSII_RTTI_SYMBOL_1;
RiskAspect[_a] = { fqn: "cdktg.RiskAspect", version: "0.0.40" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmlza3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcmlza3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSwrQ0FBNEM7QUFFNUMsbURBQWdEO0FBRWhELE1BQWEsVUFBVTtJQUNyQixLQUFLLENBQUMsSUFBZ0I7UUFDcEIsSUFBSSw2QkFBYSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxFQUFFO1lBQ3hDLHdGQUF3RjtZQUN4RixtRkFBbUY7WUFDbkYsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUUsRUFBRTtnQkFDekIsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsRUFBRSxJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxFQUFFLEVBQUU7b0JBQ3RELHlCQUFXLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO2lCQUNuRTthQUNGO1NBQ0Y7SUFDSCxDQUFDOztBQVhILGdDQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSUNvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBBbm5vdGF0aW9ucyB9IGZyb20gXCIuL2Fubm90YXRpb25zXCI7XG5pbXBvcnQgeyBJQXNwZWN0IH0gZnJvbSBcIi4vYXNwZWN0XCI7XG5pbXBvcnQgeyBDb21tdW5pY2F0aW9uIH0gZnJvbSBcIi4vY29tbXVuaWNhdGlvblwiO1xuXG5leHBvcnQgY2xhc3MgUmlza0FzcGVjdCBpbXBsZW1lbnRzIElBc3BlY3Qge1xuICB2aXNpdChub2RlOiBJQ29uc3RydWN0KTogdm9pZCB7XG4gICAgaWYgKENvbW11bmljYXRpb24uaXNDb21tdW5pY2F0aW9ubChub2RlKSkge1xuICAgICAgLy8gV2hlbiBhIHRlY2huaWNhbCBjb21tdW5pY2F0aW9uIGxpbmsgZG9lcyBub3Qgc2VuZCBvciByZWNlaXZlIGFueSBkYXRhIGFzc2V0cywgdGhpcyBpc1xuICAgICAgLy8gYW4gaW5kaWNhdG9yIGZvciBhbiB1bm5lY2Vzc2FyeSBjb21tdW5pY2F0aW9uIGxpbmsgKG9yIGZvciBhbiBpbmNvbXBsZXRlIG1vZGVsKS5cbiAgICAgIGlmICghbm9kZS5oYXNEYXRhQXNzZXRzKCkpIHtcbiAgICAgICAgaWYgKG5vZGUuc291cmNlLmlzSW5TY29wZSgpIHx8IG5vZGUudGFyZ2V0LmlzSW5TY29wZSgpKSB7XG4gICAgICAgICAgQW5ub3RhdGlvbnMub2Yobm9kZSkuYWRkV2FybmluZyhcIlVubmVjZXNzYXJ5IENvbW11bmljYXRpb24gTGlua1wiKTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgfVxufVxuIl19