"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataBreachProbability = exports.ExploitationImpact = exports.ExploitationLikelihood = exports.Severity = exports.Stride = exports.RiskFunction = exports.RiskCategory = exports.Risk = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_asset_1 = require("./data-asset");
const resource_1 = require("./resource");
const shared_runtime_1 = require("./shared-runtime");
const technical_asset_1 = require("./technical-asset");
const trust_boundary_1 = require("./trust-boundary");
class Risk {
    constructor(id, props) {
        this.id = id;
        this.severity = props.severity;
        this.exploitationLikelihood = props.exploitationLikelihood;
        this.exploitationImpact = props.exploitationImpact;
        this.dataBreachProbability = props.dataBreachProbability;
        this.dataBreachTechnicalAssets = props.dataBreachTechnicalAssets;
        this.mostRelevantTechnicalAsset = props.mostRelevantTechnicalAsset;
        this.mostRelevantDataAsset = props.mostRelevantDataAsset;
        this.mostRelevantCommunicationLink = props.mostRelevantCommunicationLink;
        this.mostRelevantTrustBoundary = props.mostRelevantTrustBoundary;
        this.mostRelevantSharedRuntime = props.mostRelevantSharedRuntime;
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.id]: {
                severity: this.severity,
                exploitation_likelihood: this.exploitationLikelihood,
                exploitation_impact: this.exploitationImpact,
                data_breach_probability: this.dataBreachProbability,
                data_breach_technical_assets: this.dataBreachTechnicalAssets.map((a) => a.id),
                most_relevant_data_asset: this.mostRelevantDataAsset?.id,
                most_relevant_technical_asset: this.mostRelevantTechnicalAsset?.id,
                most_relevant_communication_link: this.mostRelevantCommunicationLink?.id,
                most_relevant_trust_boundary: this.mostRelevantTrustBoundary?.id,
                most_relevant_shared_runtime: this.mostRelevantSharedRuntime?.id,
            },
        };
    }
}
exports.Risk = Risk;
_a = JSII_RTTI_SYMBOL_1;
Risk[_a] = { fqn: "cdktg.Risk", version: "0.0.40" };
class RiskCategory extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.impact = props.impact;
        this.asvs = props.asvs;
        this.cheatSheet = props.cheatSheet;
        this.action = props.action;
        this.mitigation = props.mitigation;
        this.check = props.check;
        this.function = props.function;
        this.stride = props.stride;
        this.detectionLogic = props.detectionLogic;
        this.riskAssessment = props.riskAssessment;
        this.falsePositives = props.falsePositives;
        this.modelFailurePossibleReason = props.modelFailurePossibleReason;
        this.cwe = props.cwe;
        this.risks = new Array();
    }
    identifiedAtDataAsset(target, options) {
        this.identifiedAtResource(target, options);
    }
    identifiedAtTechnicalAsset(target, options) {
        this.identifiedAtResource(target, options);
    }
    identifiedAtTrustBoundary(target, options) {
        this.identifiedAtResource(target, options);
    }
    identifiedAtSharedRuntime(target, options) {
        this.identifiedAtResource(target, options);
    }
    addIdentifiedRisk(risk) {
        this.risks.push(risk);
    }
    identifiedAtResource(target, options) {
        this.addIdentifiedRisk(new Risk(`<b>${this.node.id}</b> risk at <b>${target.node.id}</b>`, {
            ...options,
            mostRelevantDataAsset: target instanceof data_asset_1.DataAsset ? target : undefined,
            mostRelevantTechnicalAsset: target instanceof technical_asset_1.TechnicalAsset ? target : undefined,
            mostRelevantTrustBoundary: target instanceof trust_boundary_1.TrustBoundary ? target : undefined,
            mostRelevantSharedRuntime: target instanceof shared_runtime_1.SharedRuntime ? target : undefined,
        }));
    }
    /**
     * @internal
     */
    _toThreagile() {
        const threagile = {
            [this.title]: {
                id: this.id,
                description: this.description,
                impact: this.impact,
                asvs: this.asvs,
                cheat_sheet: this.cheatSheet,
                action: this.action,
                mitigation: this.mitigation,
                check: this.check,
                function: this.function,
                stride: this.stride,
                detection_logic: this.detectionLogic,
                risk_assessment: this.riskAssessment,
                false_positives: this.falsePositives,
                model_failure_possible_reason: this.modelFailurePossibleReason ?? false,
                cwe: this.cwe,
            },
        };
        threagile[this.node.id].risks_identified = this.risks.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        return threagile;
    }
}
exports.RiskCategory = RiskCategory;
_b = JSII_RTTI_SYMBOL_1;
RiskCategory[_b] = { fqn: "cdktg.RiskCategory", version: "0.0.40" };
var RiskFunction;
(function (RiskFunction) {
    RiskFunction["BUSINESS_SIDE"] = "business-side";
    RiskFunction["ARCHITECTURE"] = "architecture";
    RiskFunction["DEVELOPMENT"] = "development";
    RiskFunction["OPERATIONS"] = "operations";
})(RiskFunction = exports.RiskFunction || (exports.RiskFunction = {}));
var Stride;
(function (Stride) {
    Stride["SPOOFING"] = "spoofing";
    Stride["TAMPERING"] = "tampering";
    Stride["REPUDIATION"] = "repudiation";
    Stride["INFORMATION_DISCLOSURE"] = "information-disclosure";
    Stride["DENIAL_OF_SERVICE"] = "denial-of-service";
    Stride["ELEVATION_OF_PRIVILEGE"] = "elevation-of-privilege";
})(Stride = exports.Stride || (exports.Stride = {}));
var Severity;
(function (Severity) {
    Severity["LOW"] = "low";
    Severity["MEDIUM"] = "medium";
    Severity["ELEVATED"] = "elevated";
    Severity["HIGH"] = "high";
    Severity["CRITICAL"] = "critical";
})(Severity = exports.Severity || (exports.Severity = {}));
var ExploitationLikelihood;
(function (ExploitationLikelihood) {
    ExploitationLikelihood["UNLIKELY"] = "unlikely";
    ExploitationLikelihood["LIKELY"] = "likely";
    ExploitationLikelihood["VERY_LIKELY"] = "very-likely";
    ExploitationLikelihood["FREQUENT"] = "frequent";
})(ExploitationLikelihood = exports.ExploitationLikelihood || (exports.ExploitationLikelihood = {}));
var ExploitationImpact;
(function (ExploitationImpact) {
    ExploitationImpact["LOW"] = "low";
    ExploitationImpact["MEDIUM"] = "medium";
    ExploitationImpact["HIGH"] = "high";
    ExploitationImpact["VERY_HIGH"] = "very-high";
})(ExploitationImpact = exports.ExploitationImpact || (exports.ExploitationImpact = {}));
var DataBreachProbability;
(function (DataBreachProbability) {
    DataBreachProbability["IMPROBABLE"] = "improbable";
    DataBreachProbability["POSSIBLE"] = "possible";
    DataBreachProbability["PROBABLE"] = "probable";
})(DataBreachProbability = exports.DataBreachProbability || (exports.DataBreachProbability = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmlzay1jYXRlZ29yeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9yaXNrLWNhdGVnb3J5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBRUEsNkNBQXlDO0FBRXpDLHlDQUFxRDtBQUNyRCxxREFBaUQ7QUFFakQsdURBQW1EO0FBQ25ELHFEQUFpRDtBQWtCakQsTUFBYSxJQUFJO0lBYWYsWUFBWSxFQUFVLEVBQUUsS0FBZ0I7UUFDdEMsSUFBSSxDQUFDLEVBQUUsR0FBRyxFQUFFLENBQUM7UUFDYixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxzQkFBc0IsQ0FBQztRQUMzRCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO1FBQ25ELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMscUJBQXFCLENBQUM7UUFDekQsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQztRQUNqRSxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDLDBCQUEwQixDQUFDO1FBQ25FLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMscUJBQXFCLENBQUM7UUFDekQsSUFBSSxDQUFDLDZCQUE2QixHQUFHLEtBQUssQ0FBQyw2QkFBNkIsQ0FBQztRQUN6RSxJQUFJLENBQUMseUJBQXlCLEdBQUcsS0FBSyxDQUFDLHlCQUF5QixDQUFDO1FBQ2pFLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxLQUFLLENBQUMseUJBQXlCLENBQUM7SUFDbkUsQ0FBQztJQUVEOztPQUVHO0lBQ0ksWUFBWTtRQUNqQixPQUFPO1lBQ0wsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLEVBQUU7Z0JBQ1QsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO2dCQUN2Qix1QkFBdUIsRUFBRSxJQUFJLENBQUMsc0JBQXNCO2dCQUNwRCxtQkFBbUIsRUFBRSxJQUFJLENBQUMsa0JBQWtCO2dCQUM1Qyx1QkFBdUIsRUFBRSxJQUFJLENBQUMscUJBQXFCO2dCQUNuRCw0QkFBNEIsRUFBRSxJQUFJLENBQUMseUJBQXlCLENBQUMsR0FBRyxDQUM5RCxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FDWjtnQkFDRCx3QkFBd0IsRUFBRSxJQUFJLENBQUMscUJBQXFCLEVBQUUsRUFBRTtnQkFDeEQsNkJBQTZCLEVBQUUsSUFBSSxDQUFDLDBCQUEwQixFQUFFLEVBQUU7Z0JBQ2xFLGdDQUFnQyxFQUM5QixJQUFJLENBQUMsNkJBQTZCLEVBQUUsRUFBRTtnQkFDeEMsNEJBQTRCLEVBQUUsSUFBSSxDQUFDLHlCQUF5QixFQUFFLEVBQUU7Z0JBQ2hFLDRCQUE0QixFQUFFLElBQUksQ0FBQyx5QkFBeUIsRUFBRSxFQUFFO2FBQ2pFO1NBQ0YsQ0FBQztJQUNKLENBQUM7O0FBaERILG9CQWlEQzs7O0FBa0JELE1BQWEsWUFBYSxTQUFRLG1CQUFRO0lBaUJ4QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCO1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ25DLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7UUFDM0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFDM0MsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEtBQUssQ0FBQywwQkFBMEIsQ0FBQztRQUNuRSxJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQyxHQUFHLENBQUM7UUFFckIsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLEtBQUssRUFBUSxDQUFDO0lBQ2pDLENBQUM7SUFFTSxxQkFBcUIsQ0FBQyxNQUFpQixFQUFFLE9BQW9CO1FBQ2xFLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxNQUFNLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVNLDBCQUEwQixDQUMvQixNQUFzQixFQUN0QixPQUFvQjtRQUVwQixJQUFJLENBQUMsb0JBQW9CLENBQUMsTUFBTSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFTSx5QkFBeUIsQ0FDOUIsTUFBcUIsRUFDckIsT0FBb0I7UUFFcEIsSUFBSSxDQUFDLG9CQUFvQixDQUFDLE1BQU0sRUFBRSxPQUFPLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0seUJBQXlCLENBQzlCLE1BQXFCLEVBQ3JCLE9BQW9CO1FBRXBCLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxNQUFNLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVNLGlCQUFpQixDQUFDLElBQVU7UUFDakMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDeEIsQ0FBQztJQUVPLG9CQUFvQixDQUFDLE1BQWdCLEVBQUUsT0FBb0I7UUFDakUsSUFBSSxDQUFDLGlCQUFpQixDQUNwQixJQUFJLElBQUksQ0FBQyxNQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxtQkFBbUIsTUFBTSxDQUFDLElBQUksQ0FBQyxFQUFFLE1BQU0sRUFBRTtZQUNsRSxHQUFHLE9BQU87WUFDVixxQkFBcUIsRUFBRSxNQUFNLFlBQVksc0JBQVMsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQ3ZFLDBCQUEwQixFQUN4QixNQUFNLFlBQVksZ0NBQWMsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQ3ZELHlCQUF5QixFQUN2QixNQUFNLFlBQVksOEJBQWEsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQ3RELHlCQUF5QixFQUN2QixNQUFNLFlBQVksOEJBQWEsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxTQUFTO1NBQ3ZELENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVEOztPQUVHO0lBQ0ksWUFBWTtRQUNqQixNQUFNLFNBQVMsR0FBUTtZQUNyQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsRUFBRTtnQkFDWixFQUFFLEVBQUUsSUFBSSxDQUFDLEVBQUU7Z0JBQ1gsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO2dCQUM3QixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07Z0JBQ25CLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtnQkFDZixXQUFXLEVBQUUsSUFBSSxDQUFDLFVBQVU7Z0JBQzVCLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtnQkFDbkIsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO2dCQUMzQixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUs7Z0JBQ2pCLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtnQkFDdkIsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO2dCQUNuQixlQUFlLEVBQUUsSUFBSSxDQUFDLGNBQWM7Z0JBQ3BDLGVBQWUsRUFBRSxJQUFJLENBQUMsY0FBYztnQkFDcEMsZUFBZSxFQUFFLElBQUksQ0FBQyxjQUFjO2dCQUNwQyw2QkFBNkIsRUFBRSxJQUFJLENBQUMsMEJBQTBCLElBQUksS0FBSztnQkFDdkUsR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO2FBQ2Q7U0FDRixDQUFDO1FBRUYsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQzFELENBQUMsSUFBSSxFQUFFLE9BQU8sRUFBRSxFQUFFLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLFlBQVksRUFBRSxDQUFDLEVBQzlELEVBQUUsQ0FDSCxDQUFDO1FBRUYsT0FBTyxTQUFTLENBQUM7SUFDbkIsQ0FBQzs7QUEvR0gsb0NBZ0hDOzs7QUFFRCxJQUFZLFlBS1g7QUFMRCxXQUFZLFlBQVk7SUFDdEIsK0NBQStCLENBQUE7SUFDL0IsNkNBQTZCLENBQUE7SUFDN0IsMkNBQTJCLENBQUE7SUFDM0IseUNBQXlCLENBQUE7QUFDM0IsQ0FBQyxFQUxXLFlBQVksR0FBWixvQkFBWSxLQUFaLG9CQUFZLFFBS3ZCO0FBRUQsSUFBWSxNQU9YO0FBUEQsV0FBWSxNQUFNO0lBQ2hCLCtCQUFxQixDQUFBO0lBQ3JCLGlDQUF1QixDQUFBO0lBQ3ZCLHFDQUEyQixDQUFBO0lBQzNCLDJEQUFpRCxDQUFBO0lBQ2pELGlEQUF1QyxDQUFBO0lBQ3ZDLDJEQUFpRCxDQUFBO0FBQ25ELENBQUMsRUFQVyxNQUFNLEdBQU4sY0FBTSxLQUFOLGNBQU0sUUFPakI7QUFFRCxJQUFZLFFBTVg7QUFORCxXQUFZLFFBQVE7SUFDbEIsdUJBQVcsQ0FBQTtJQUNYLDZCQUFpQixDQUFBO0lBQ2pCLGlDQUFxQixDQUFBO0lBQ3JCLHlCQUFhLENBQUE7SUFDYixpQ0FBcUIsQ0FBQTtBQUN2QixDQUFDLEVBTlcsUUFBUSxHQUFSLGdCQUFRLEtBQVIsZ0JBQVEsUUFNbkI7QUFFRCxJQUFZLHNCQUtYO0FBTEQsV0FBWSxzQkFBc0I7SUFDaEMsK0NBQXFCLENBQUE7SUFDckIsMkNBQWlCLENBQUE7SUFDakIscURBQTJCLENBQUE7SUFDM0IsK0NBQXFCLENBQUE7QUFDdkIsQ0FBQyxFQUxXLHNCQUFzQixHQUF0Qiw4QkFBc0IsS0FBdEIsOEJBQXNCLFFBS2pDO0FBRUQsSUFBWSxrQkFLWDtBQUxELFdBQVksa0JBQWtCO0lBQzVCLGlDQUFXLENBQUE7SUFDWCx1Q0FBaUIsQ0FBQTtJQUNqQixtQ0FBYSxDQUFBO0lBQ2IsNkNBQXVCLENBQUE7QUFDekIsQ0FBQyxFQUxXLGtCQUFrQixHQUFsQiwwQkFBa0IsS0FBbEIsMEJBQWtCLFFBSzdCO0FBRUQsSUFBWSxxQkFJWDtBQUpELFdBQVkscUJBQXFCO0lBQy9CLGtEQUF5QixDQUFBO0lBQ3pCLDhDQUFxQixDQUFBO0lBQ3JCLDhDQUFxQixDQUFBO0FBQ3ZCLENBQUMsRUFKVyxxQkFBcUIsR0FBckIsNkJBQXFCLEtBQXJCLDZCQUFxQixRQUloQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBDb21tdW5pY2F0aW9uIH0gZnJvbSBcIi4vY29tbXVuaWNhdGlvblwiO1xuaW1wb3J0IHsgRGF0YUFzc2V0IH0gZnJvbSBcIi4vZGF0YS1hc3NldFwiO1xuXG5pbXBvcnQgeyBSZXNvdXJjZSwgUmVzb3VyY2VQcm9wcyB9IGZyb20gXCIuL3Jlc291cmNlXCI7XG5pbXBvcnQgeyBTaGFyZWRSdW50aW1lIH0gZnJvbSBcIi4vc2hhcmVkLXJ1bnRpbWVcIjtcbmltcG9ydCAqIGFzIHNwZWMgZnJvbSBcIi4vc3BlYy90aHJlYXRnaWxlLmdlbmVyYXRlZFwiO1xuaW1wb3J0IHsgVGVjaG5pY2FsQXNzZXQgfSBmcm9tIFwiLi90ZWNobmljYWwtYXNzZXRcIjtcbmltcG9ydCB7IFRydXN0Qm91bmRhcnkgfSBmcm9tIFwiLi90cnVzdC1ib3VuZGFyeVwiO1xuXG5leHBvcnQgaW50ZXJmYWNlIFJpc2tPcHRpb25zIHtcbiAgcmVhZG9ubHkgc2V2ZXJpdHk6IFNldmVyaXR5O1xuICByZWFkb25seSBleHBsb2l0YXRpb25MaWtlbGlob29kOiBFeHBsb2l0YXRpb25MaWtlbGlob29kO1xuICByZWFkb25seSBleHBsb2l0YXRpb25JbXBhY3Q6IEV4cGxvaXRhdGlvbkltcGFjdDtcbiAgcmVhZG9ubHkgZGF0YUJyZWFjaFByb2JhYmlsaXR5OiBEYXRhQnJlYWNoUHJvYmFiaWxpdHk7XG4gIHJlYWRvbmx5IGRhdGFCcmVhY2hUZWNobmljYWxBc3NldHM6IFRlY2huaWNhbEFzc2V0W107XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmlza1Byb3BzIGV4dGVuZHMgUmlza09wdGlvbnMge1xuICByZWFkb25seSBtb3N0UmVsZXZhbnRUZWNobmljYWxBc3NldD86IFRlY2huaWNhbEFzc2V0O1xuICByZWFkb25seSBtb3N0UmVsZXZhbnREYXRhQXNzZXQ/OiBEYXRhQXNzZXQ7XG4gIHJlYWRvbmx5IG1vc3RSZWxldmFudENvbW11bmljYXRpb25MaW5rPzogQ29tbXVuaWNhdGlvbjtcbiAgcmVhZG9ubHkgbW9zdFJlbGV2YW50VHJ1c3RCb3VuZGFyeT86IFRydXN0Qm91bmRhcnk7XG4gIHJlYWRvbmx5IG1vc3RSZWxldmFudFNoYXJlZFJ1bnRpbWU/OiBTaGFyZWRSdW50aW1lO1xufVxuXG5leHBvcnQgY2xhc3MgUmlzayB7XG4gIHB1YmxpYyByZWFkb25seSBpZDogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgc2V2ZXJpdHk6IFNldmVyaXR5O1xuICBwdWJsaWMgcmVhZG9ubHkgZXhwbG9pdGF0aW9uTGlrZWxpaG9vZDogRXhwbG9pdGF0aW9uTGlrZWxpaG9vZDtcbiAgcHVibGljIHJlYWRvbmx5IGV4cGxvaXRhdGlvbkltcGFjdDogRXhwbG9pdGF0aW9uSW1wYWN0O1xuICBwdWJsaWMgcmVhZG9ubHkgZGF0YUJyZWFjaFByb2JhYmlsaXR5OiBEYXRhQnJlYWNoUHJvYmFiaWxpdHk7XG4gIHB1YmxpYyByZWFkb25seSBkYXRhQnJlYWNoVGVjaG5pY2FsQXNzZXRzOiBUZWNobmljYWxBc3NldFtdO1xuICBwdWJsaWMgcmVhZG9ubHkgbW9zdFJlbGV2YW50VGVjaG5pY2FsQXNzZXQ/OiBUZWNobmljYWxBc3NldDtcbiAgcHVibGljIHJlYWRvbmx5IG1vc3RSZWxldmFudERhdGFBc3NldD86IERhdGFBc3NldDtcbiAgcHVibGljIHJlYWRvbmx5IG1vc3RSZWxldmFudENvbW11bmljYXRpb25MaW5rPzogQ29tbXVuaWNhdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IG1vc3RSZWxldmFudFRydXN0Qm91bmRhcnk/OiBUcnVzdEJvdW5kYXJ5O1xuICBwdWJsaWMgcmVhZG9ubHkgbW9zdFJlbGV2YW50U2hhcmVkUnVudGltZT86IFNoYXJlZFJ1bnRpbWU7XG5cbiAgY29uc3RydWN0b3IoaWQ6IHN0cmluZywgcHJvcHM6IFJpc2tQcm9wcykge1xuICAgIHRoaXMuaWQgPSBpZDtcbiAgICB0aGlzLnNldmVyaXR5ID0gcHJvcHMuc2V2ZXJpdHk7XG4gICAgdGhpcy5leHBsb2l0YXRpb25MaWtlbGlob29kID0gcHJvcHMuZXhwbG9pdGF0aW9uTGlrZWxpaG9vZDtcbiAgICB0aGlzLmV4cGxvaXRhdGlvbkltcGFjdCA9IHByb3BzLmV4cGxvaXRhdGlvbkltcGFjdDtcbiAgICB0aGlzLmRhdGFCcmVhY2hQcm9iYWJpbGl0eSA9IHByb3BzLmRhdGFCcmVhY2hQcm9iYWJpbGl0eTtcbiAgICB0aGlzLmRhdGFCcmVhY2hUZWNobmljYWxBc3NldHMgPSBwcm9wcy5kYXRhQnJlYWNoVGVjaG5pY2FsQXNzZXRzO1xuICAgIHRoaXMubW9zdFJlbGV2YW50VGVjaG5pY2FsQXNzZXQgPSBwcm9wcy5tb3N0UmVsZXZhbnRUZWNobmljYWxBc3NldDtcbiAgICB0aGlzLm1vc3RSZWxldmFudERhdGFBc3NldCA9IHByb3BzLm1vc3RSZWxldmFudERhdGFBc3NldDtcbiAgICB0aGlzLm1vc3RSZWxldmFudENvbW11bmljYXRpb25MaW5rID0gcHJvcHMubW9zdFJlbGV2YW50Q29tbXVuaWNhdGlvbkxpbms7XG4gICAgdGhpcy5tb3N0UmVsZXZhbnRUcnVzdEJvdW5kYXJ5ID0gcHJvcHMubW9zdFJlbGV2YW50VHJ1c3RCb3VuZGFyeTtcbiAgICB0aGlzLm1vc3RSZWxldmFudFNoYXJlZFJ1bnRpbWUgPSBwcm9wcy5tb3N0UmVsZXZhbnRTaGFyZWRSdW50aW1lO1xuICB9XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIF90b1RocmVhZ2lsZSgpIHtcbiAgICByZXR1cm4ge1xuICAgICAgW3RoaXMuaWRdOiB7XG4gICAgICAgIHNldmVyaXR5OiB0aGlzLnNldmVyaXR5LFxuICAgICAgICBleHBsb2l0YXRpb25fbGlrZWxpaG9vZDogdGhpcy5leHBsb2l0YXRpb25MaWtlbGlob29kLFxuICAgICAgICBleHBsb2l0YXRpb25faW1wYWN0OiB0aGlzLmV4cGxvaXRhdGlvbkltcGFjdCxcbiAgICAgICAgZGF0YV9icmVhY2hfcHJvYmFiaWxpdHk6IHRoaXMuZGF0YUJyZWFjaFByb2JhYmlsaXR5LFxuICAgICAgICBkYXRhX2JyZWFjaF90ZWNobmljYWxfYXNzZXRzOiB0aGlzLmRhdGFCcmVhY2hUZWNobmljYWxBc3NldHMubWFwKFxuICAgICAgICAgIChhKSA9PiBhLmlkXG4gICAgICAgICksXG4gICAgICAgIG1vc3RfcmVsZXZhbnRfZGF0YV9hc3NldDogdGhpcy5tb3N0UmVsZXZhbnREYXRhQXNzZXQ/LmlkLFxuICAgICAgICBtb3N0X3JlbGV2YW50X3RlY2huaWNhbF9hc3NldDogdGhpcy5tb3N0UmVsZXZhbnRUZWNobmljYWxBc3NldD8uaWQsXG4gICAgICAgIG1vc3RfcmVsZXZhbnRfY29tbXVuaWNhdGlvbl9saW5rOlxuICAgICAgICAgIHRoaXMubW9zdFJlbGV2YW50Q29tbXVuaWNhdGlvbkxpbms/LmlkLFxuICAgICAgICBtb3N0X3JlbGV2YW50X3RydXN0X2JvdW5kYXJ5OiB0aGlzLm1vc3RSZWxldmFudFRydXN0Qm91bmRhcnk/LmlkLFxuICAgICAgICBtb3N0X3JlbGV2YW50X3NoYXJlZF9ydW50aW1lOiB0aGlzLm1vc3RSZWxldmFudFNoYXJlZFJ1bnRpbWU/LmlkLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmlza0NhdGVnb3J5UHJvcHMgZXh0ZW5kcyBSZXNvdXJjZVByb3BzIHtcbiAgcmVhZG9ubHkgaW1wYWN0OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGFzdnM6IHN0cmluZztcbiAgcmVhZG9ubHkgY2hlYXRTaGVldDogc3RyaW5nO1xuICByZWFkb25seSBhY3Rpb246IHN0cmluZztcbiAgcmVhZG9ubHkgbWl0aWdhdGlvbjogc3RyaW5nO1xuICByZWFkb25seSBjaGVjazogc3RyaW5nO1xuICByZWFkb25seSBmdW5jdGlvbjogUmlza0Z1bmN0aW9uO1xuICByZWFkb25seSBzdHJpZGU6IFN0cmlkZTtcbiAgcmVhZG9ubHkgZGV0ZWN0aW9uTG9naWM6IHN0cmluZztcbiAgcmVhZG9ubHkgcmlza0Fzc2Vzc21lbnQ6IHN0cmluZztcbiAgcmVhZG9ubHkgZmFsc2VQb3NpdGl2ZXM6IHN0cmluZztcbiAgcmVhZG9ubHkgbW9kZWxGYWlsdXJlUG9zc2libGVSZWFzb24/OiBib29sZWFuO1xuICByZWFkb25seSBjd2U6IG51bWJlcjtcbn1cblxuZXhwb3J0IGNsYXNzIFJpc2tDYXRlZ29yeSBleHRlbmRzIFJlc291cmNlIHtcbiAgcHVibGljIHJlYWRvbmx5IGltcGFjdDogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgYXN2czogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgY2hlYXRTaGVldDogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgYWN0aW9uOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBtaXRpZ2F0aW9uOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBjaGVjazogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgZnVuY3Rpb246IFJpc2tGdW5jdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IHN0cmlkZTogU3RyaWRlO1xuICBwdWJsaWMgcmVhZG9ubHkgZGV0ZWN0aW9uTG9naWM6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IHJpc2tBc3Nlc3NtZW50OiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBmYWxzZVBvc2l0aXZlczogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgbW9kZWxGYWlsdXJlUG9zc2libGVSZWFzb24/OiBib29sZWFuO1xuICBwdWJsaWMgcmVhZG9ubHkgY3dlOiBudW1iZXI7XG5cbiAgcHJpdmF0ZSByaXNrczogUmlza1tdO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSaXNrQ2F0ZWdvcnlQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgdGhpcy5pbXBhY3QgPSBwcm9wcy5pbXBhY3Q7XG4gICAgdGhpcy5hc3ZzID0gcHJvcHMuYXN2cztcbiAgICB0aGlzLmNoZWF0U2hlZXQgPSBwcm9wcy5jaGVhdFNoZWV0O1xuICAgIHRoaXMuYWN0aW9uID0gcHJvcHMuYWN0aW9uO1xuICAgIHRoaXMubWl0aWdhdGlvbiA9IHByb3BzLm1pdGlnYXRpb247XG4gICAgdGhpcy5jaGVjayA9IHByb3BzLmNoZWNrO1xuICAgIHRoaXMuZnVuY3Rpb24gPSBwcm9wcy5mdW5jdGlvbjtcbiAgICB0aGlzLnN0cmlkZSA9IHByb3BzLnN0cmlkZTtcbiAgICB0aGlzLmRldGVjdGlvbkxvZ2ljID0gcHJvcHMuZGV0ZWN0aW9uTG9naWM7XG4gICAgdGhpcy5yaXNrQXNzZXNzbWVudCA9IHByb3BzLnJpc2tBc3Nlc3NtZW50O1xuICAgIHRoaXMuZmFsc2VQb3NpdGl2ZXMgPSBwcm9wcy5mYWxzZVBvc2l0aXZlcztcbiAgICB0aGlzLm1vZGVsRmFpbHVyZVBvc3NpYmxlUmVhc29uID0gcHJvcHMubW9kZWxGYWlsdXJlUG9zc2libGVSZWFzb247XG4gICAgdGhpcy5jd2UgPSBwcm9wcy5jd2U7XG5cbiAgICB0aGlzLnJpc2tzID0gbmV3IEFycmF5PFJpc2s+KCk7XG4gIH1cblxuICBwdWJsaWMgaWRlbnRpZmllZEF0RGF0YUFzc2V0KHRhcmdldDogRGF0YUFzc2V0LCBvcHRpb25zOiBSaXNrT3B0aW9ucykge1xuICAgIHRoaXMuaWRlbnRpZmllZEF0UmVzb3VyY2UodGFyZ2V0LCBvcHRpb25zKTtcbiAgfVxuXG4gIHB1YmxpYyBpZGVudGlmaWVkQXRUZWNobmljYWxBc3NldChcbiAgICB0YXJnZXQ6IFRlY2huaWNhbEFzc2V0LFxuICAgIG9wdGlvbnM6IFJpc2tPcHRpb25zXG4gICkge1xuICAgIHRoaXMuaWRlbnRpZmllZEF0UmVzb3VyY2UodGFyZ2V0LCBvcHRpb25zKTtcbiAgfVxuXG4gIHB1YmxpYyBpZGVudGlmaWVkQXRUcnVzdEJvdW5kYXJ5KFxuICAgIHRhcmdldDogU2hhcmVkUnVudGltZSxcbiAgICBvcHRpb25zOiBSaXNrT3B0aW9uc1xuICApIHtcbiAgICB0aGlzLmlkZW50aWZpZWRBdFJlc291cmNlKHRhcmdldCwgb3B0aW9ucyk7XG4gIH1cblxuICBwdWJsaWMgaWRlbnRpZmllZEF0U2hhcmVkUnVudGltZShcbiAgICB0YXJnZXQ6IFNoYXJlZFJ1bnRpbWUsXG4gICAgb3B0aW9uczogUmlza09wdGlvbnNcbiAgKSB7XG4gICAgdGhpcy5pZGVudGlmaWVkQXRSZXNvdXJjZSh0YXJnZXQsIG9wdGlvbnMpO1xuICB9XG5cbiAgcHVibGljIGFkZElkZW50aWZpZWRSaXNrKHJpc2s6IFJpc2spIHtcbiAgICB0aGlzLnJpc2tzLnB1c2gocmlzayk7XG4gIH1cblxuICBwcml2YXRlIGlkZW50aWZpZWRBdFJlc291cmNlKHRhcmdldDogUmVzb3VyY2UsIG9wdGlvbnM6IFJpc2tPcHRpb25zKSB7XG4gICAgdGhpcy5hZGRJZGVudGlmaWVkUmlzayhcbiAgICAgIG5ldyBSaXNrKGA8Yj4ke3RoaXMubm9kZS5pZH08L2I+IHJpc2sgYXQgPGI+JHt0YXJnZXQubm9kZS5pZH08L2I+YCwge1xuICAgICAgICAuLi5vcHRpb25zLFxuICAgICAgICBtb3N0UmVsZXZhbnREYXRhQXNzZXQ6IHRhcmdldCBpbnN0YW5jZW9mIERhdGFBc3NldCA/IHRhcmdldCA6IHVuZGVmaW5lZCxcbiAgICAgICAgbW9zdFJlbGV2YW50VGVjaG5pY2FsQXNzZXQ6XG4gICAgICAgICAgdGFyZ2V0IGluc3RhbmNlb2YgVGVjaG5pY2FsQXNzZXQgPyB0YXJnZXQgOiB1bmRlZmluZWQsXG4gICAgICAgIG1vc3RSZWxldmFudFRydXN0Qm91bmRhcnk6XG4gICAgICAgICAgdGFyZ2V0IGluc3RhbmNlb2YgVHJ1c3RCb3VuZGFyeSA/IHRhcmdldCA6IHVuZGVmaW5lZCxcbiAgICAgICAgbW9zdFJlbGV2YW50U2hhcmVkUnVudGltZTpcbiAgICAgICAgICB0YXJnZXQgaW5zdGFuY2VvZiBTaGFyZWRSdW50aW1lID8gdGFyZ2V0IDogdW5kZWZpbmVkLFxuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIF90b1RocmVhZ2lsZSgpOiBzcGVjLlRocmVhZ2lsZVtcImluZGl2aWR1YWxfcmlza19jYXRlZ29yaWVzXCJdIHtcbiAgICBjb25zdCB0aHJlYWdpbGU6IGFueSA9IHtcbiAgICAgIFt0aGlzLnRpdGxlXToge1xuICAgICAgICBpZDogdGhpcy5pZCxcbiAgICAgICAgZGVzY3JpcHRpb246IHRoaXMuZGVzY3JpcHRpb24sXG4gICAgICAgIGltcGFjdDogdGhpcy5pbXBhY3QsXG4gICAgICAgIGFzdnM6IHRoaXMuYXN2cyxcbiAgICAgICAgY2hlYXRfc2hlZXQ6IHRoaXMuY2hlYXRTaGVldCxcbiAgICAgICAgYWN0aW9uOiB0aGlzLmFjdGlvbixcbiAgICAgICAgbWl0aWdhdGlvbjogdGhpcy5taXRpZ2F0aW9uLFxuICAgICAgICBjaGVjazogdGhpcy5jaGVjayxcbiAgICAgICAgZnVuY3Rpb246IHRoaXMuZnVuY3Rpb24sXG4gICAgICAgIHN0cmlkZTogdGhpcy5zdHJpZGUsXG4gICAgICAgIGRldGVjdGlvbl9sb2dpYzogdGhpcy5kZXRlY3Rpb25Mb2dpYyxcbiAgICAgICAgcmlza19hc3Nlc3NtZW50OiB0aGlzLnJpc2tBc3Nlc3NtZW50LFxuICAgICAgICBmYWxzZV9wb3NpdGl2ZXM6IHRoaXMuZmFsc2VQb3NpdGl2ZXMsXG4gICAgICAgIG1vZGVsX2ZhaWx1cmVfcG9zc2libGVfcmVhc29uOiB0aGlzLm1vZGVsRmFpbHVyZVBvc3NpYmxlUmVhc29uID8/IGZhbHNlLFxuICAgICAgICBjd2U6IHRoaXMuY3dlLFxuICAgICAgfSxcbiAgICB9O1xuXG4gICAgdGhyZWFnaWxlW3RoaXMubm9kZS5pZF0ucmlza3NfaWRlbnRpZmllZCA9IHRoaXMucmlza3MucmVkdWNlKFxuICAgICAgKHByZXYsIGN1cnJlbnQpID0+IE9iamVjdC5hc3NpZ24ocHJldiwgY3VycmVudC5fdG9UaHJlYWdpbGUoKSksXG4gICAgICB7fVxuICAgICk7XG5cbiAgICByZXR1cm4gdGhyZWFnaWxlO1xuICB9XG59XG5cbmV4cG9ydCBlbnVtIFJpc2tGdW5jdGlvbiB7XG4gIEJVU0lORVNTX1NJREUgPSBcImJ1c2luZXNzLXNpZGVcIixcbiAgQVJDSElURUNUVVJFID0gXCJhcmNoaXRlY3R1cmVcIixcbiAgREVWRUxPUE1FTlQgPSBcImRldmVsb3BtZW50XCIsXG4gIE9QRVJBVElPTlMgPSBcIm9wZXJhdGlvbnNcIixcbn1cblxuZXhwb3J0IGVudW0gU3RyaWRlIHtcbiAgU1BPT0ZJTkcgPSBcInNwb29maW5nXCIsXG4gIFRBTVBFUklORyA9IFwidGFtcGVyaW5nXCIsXG4gIFJFUFVESUFUSU9OID0gXCJyZXB1ZGlhdGlvblwiLFxuICBJTkZPUk1BVElPTl9ESVNDTE9TVVJFID0gXCJpbmZvcm1hdGlvbi1kaXNjbG9zdXJlXCIsXG4gIERFTklBTF9PRl9TRVJWSUNFID0gXCJkZW5pYWwtb2Ytc2VydmljZVwiLFxuICBFTEVWQVRJT05fT0ZfUFJJVklMRUdFID0gXCJlbGV2YXRpb24tb2YtcHJpdmlsZWdlXCIsXG59XG5cbmV4cG9ydCBlbnVtIFNldmVyaXR5IHtcbiAgTE9XID0gXCJsb3dcIixcbiAgTUVESVVNID0gXCJtZWRpdW1cIixcbiAgRUxFVkFURUQgPSBcImVsZXZhdGVkXCIsXG4gIEhJR0ggPSBcImhpZ2hcIixcbiAgQ1JJVElDQUwgPSBcImNyaXRpY2FsXCIsXG59XG5cbmV4cG9ydCBlbnVtIEV4cGxvaXRhdGlvbkxpa2VsaWhvb2Qge1xuICBVTkxJS0VMWSA9IFwidW5saWtlbHlcIixcbiAgTElLRUxZID0gXCJsaWtlbHlcIixcbiAgVkVSWV9MSUtFTFkgPSBcInZlcnktbGlrZWx5XCIsXG4gIEZSRVFVRU5UID0gXCJmcmVxdWVudFwiLFxufVxuXG5leHBvcnQgZW51bSBFeHBsb2l0YXRpb25JbXBhY3Qge1xuICBMT1cgPSBcImxvd1wiLFxuICBNRURJVU0gPSBcIm1lZGl1bVwiLFxuICBISUdIID0gXCJoaWdoXCIsXG4gIFZFUllfSElHSCA9IFwidmVyeS1oaWdoXCIsXG59XG5cbmV4cG9ydCBlbnVtIERhdGFCcmVhY2hQcm9iYWJpbGl0eSB7XG4gIElNUFJPQkFCTEUgPSBcImltcHJvYmFibGVcIixcbiAgUE9TU0lCTEUgPSBcInBvc3NpYmxlXCIsXG4gIFBST0JBQkxFID0gXCJwcm9iYWJsZVwiLFxufVxuIl19