"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Project = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const fs = require("fs-extra");
const common_1 = require("./common");
const manifest_1 = require("./manifest");
const model_1 = require("./model");
class Project extends constructs_1.Construct {
    constructor(props = {}) {
        super(undefined, "");
        this.outdir = props.outdir ?? common_1.CDKTG_OUT_DIR;
        this.skipValidation = props.skipValidation;
        if (!fs.existsSync(this.outdir)) {
            fs.mkdirSync(this.outdir, { recursive: true });
        }
        this.manifest = new manifest_1.Manifest(common_1.CDKTG_VERSION, this.outdir);
    }
    /**
     * Synthesizes the model to the output directory
     */
    synth() {
        const session = {
            outdir: this.outdir,
            skipValidation: this.skipValidation,
            manifest: this.manifest,
        };
        const models = this.node
            .findAll()
            .filter((c) => c instanceof model_1.Model);
        models.forEach((model) => model.synthesizer.synthesize(session));
        this.manifest.writeToFile();
    }
}
exports.Project = Project;
_a = JSII_RTTI_SYMBOL_1;
Project[_a] = { fqn: "cdktg.Project", version: "0.0.40" };
//# sourceMappingURL=data:application/json;base64,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