"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageType = exports.Vault = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("..");
class Vault extends __1.TechnicalAsset {
    constructor(scope, id, props) {
        super(scope, id, {
            description: props.vendor ? `${props.vendor} Vault` : "No Name Vault",
            type: __1.TechnicalAssetType.PROCESS,
            usage: __1.Usage.DEVOPS,
            humanUse: false,
            tags: props.tags,
            size: __1.Size.SERVICE,
            technology: __1.Technology.VAULT,
            internet: false,
            machine: __1.Machine.VIRTUAL,
            encryption: __1.Encryption.TRANSPARENT,
            owner: "",
            ciaTriad: new __1.CIATriad({
                confidentiality: __1.Confidentiality.STRICTLY_CONFIDENTIAL,
                integrity: __1.Integrity.CRITICAL,
                availability: __1.Availability.CRITICAL,
                justification: "Vault components are rated as 'strictly-confidential'.",
            }),
            multiTenant: props.multiTenant,
            redundant: false,
            customDevelopedParts: false,
        });
        this.authentication = props.authtentication;
        this.configurationSecrets = new __1.DataAsset(this, "Configuration Secrets", {
            description: "Configuration secrets (like credentials, keys, certificates, etc.) secured and managed by a vault",
            usage: __1.Usage.DEVOPS,
            origin: "",
            owner: "",
            quantity: __1.Quantity.VERY_FEW,
            ciaTriad: new __1.CIATriad({
                confidentiality: __1.Confidentiality.STRICTLY_CONFIDENTIAL,
                integrity: __1.Integrity.CRITICAL,
                availability: __1.Availability.CRITICAL,
                justification: "Configuration secrets are rated as being 'strictly-confidential'.",
            }),
        });
        this.processes(this.configurationSecrets);
        if (props.storageType === StorageType.IN_MEMORY) {
            this.stores(this.configurationSecrets);
        }
        if (props.storageType === StorageType.FILESYSTEM ||
            props.storageType === StorageType.DATABASE) {
            this.vaultStorage = new __1.TechnicalAsset(this, "Vault Storage", {
                description: "Vault Storage",
                type: __1.TechnicalAssetType.DATASTORE,
                usage: __1.Usage.DEVOPS,
                humanUse: false,
                size: __1.Size.COMPONENT,
                technology: props.storageType === StorageType.FILESYSTEM
                    ? __1.Technology.FILE_SERVER
                    : __1.Technology.DATABASE,
                internet: false,
                machine: __1.Machine.VIRTUAL,
                encryption: __1.Encryption.SYMMETRIC_SHARED_KEY,
                owner: "",
                ciaTriad: new __1.CIATriad({
                    confidentiality: __1.Confidentiality.CONFIDENTIAL,
                    integrity: __1.Integrity.CRITICAL,
                    availability: __1.Availability.CRITICAL,
                    justification: "Vault components are only rated as 'confidential' as vaults usually apply a trust barrier to encrypt all data-at-rest with a vault key.",
                }),
                multiTenant: props.multiTenant,
                redundant: false,
                customDevelopedParts: false,
            });
            this.vaultStorage.stores(this.configurationSecrets);
            const vaultStorageAccess = this.communicatesWith("Vault Storage Access", this.vaultStorage, {
                description: "Vault Storage Access",
                protocol: props.storageType === StorageType.FILESYSTEM
                    ? __1.Protocol.LOCAL_FILE_ACCESS
                    : __1.Protocol.SQL_ACCESS_PROTOCOL,
                authentication: __1.Authentication.CREDENTIALS,
                authorization: __1.Authorization.TECHNICAL_USER,
                vpn: false,
                ipFiltered: false,
                readonly: false,
                usage: __1.Usage.DEVOPS,
            });
            vaultStorageAccess.sends(this.configurationSecrets);
            vaultStorageAccess.receives(this.configurationSecrets);
        }
        if (props.storageType === StorageType.FILESYSTEM) {
            const vaultEnvironment = new __1.TrustBoundary(this, "Vault Environment", {
                description: "Vault Environment",
                type: __1.TrustBoundaryType.EXECUTION_ENVIRONMENT,
            });
            vaultEnvironment.addTechnicalAssets(this, this.vaultStorage);
            if (props.trustBoundary) {
                // nest as execution-environment trust boundary
                props.trustBoundary.addTrustBoundary(vaultEnvironment);
            }
        }
        else {
            if (props.trustBoundary) {
                // place assets inside directly
                props.trustBoundary.addTechnicalAssets(this);
                if (this.vaultStorage) {
                    props.trustBoundary.addTechnicalAssets(this.vaultStorage);
                }
            }
        }
    }
    isUsedBy(client) {
        const vaultAccessTraffic = client.communicatesWith(`Vault Access Traffic by (${client.node.id})`, this, {
            description: `Vault Access Traffic by (${client.node.id})`,
            protocol: __1.Protocol.HTTPS,
            authentication: this.authentication,
            authorization: __1.Authorization.TECHNICAL_USER,
            vpn: false,
            ipFiltered: false,
            readonly: true,
            usage: __1.Usage.DEVOPS,
        });
        vaultAccessTraffic.receives(this.configurationSecrets);
    }
}
exports.Vault = Vault;
_a = JSII_RTTI_SYMBOL_1;
Vault[_a] = { fqn: "cdktg.plus.Vault", version: "0.0.40" };
var StorageType;
(function (StorageType) {
    /**
     * Cloud Provider (storage buckets or similar)
     */
    StorageType[StorageType["CLOUD_PROVIDER"] = 1] = "CLOUD_PROVIDER";
    /**
     * Container Platform (orchestration platform managed storage)
     */
    StorageType[StorageType["CONTAINER_PLATFORM"] = 2] = "CONTAINER_PLATFORM";
    /**
     * Database (SQL-DB, NoSQL-DB, object store or similar)
     */
    StorageType[StorageType["DATABASE"] = 3] = "DATABASE";
    /**
     * Filesystem (local or remote)
     */
    StorageType[StorageType["FILESYSTEM"] = 4] = "FILESYSTEM";
    /**
     * In-Memory (no persistent storage of secrets)
     */
    StorageType[StorageType["IN_MEMORY"] = 5] = "IN_MEMORY";
    /**
     * Service Registry
     */
    StorageType[StorageType["SERVICE_REGISTRY"] = 6] = "SERVICE_REGISTRY";
})(StorageType = exports.StorageType || (exports.StorageType = {}));
//# sourceMappingURL=data:application/json;base64,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