import { Construct } from "constructs";
import { Authentication, DataAsset, TechnicalAsset, TrustBoundary } from "..";
export interface VaultProps {
    readonly vendor?: string;
    readonly storageType: StorageType;
    readonly authtentication: Authentication;
    readonly multiTenant: boolean;
    readonly tags?: string[];
    readonly trustBoundary?: TrustBoundary;
}
export declare class Vault extends TechnicalAsset {
    readonly configurationSecrets: DataAsset;
    readonly vaultStorage?: TechnicalAsset;
    private authentication;
    constructor(scope: Construct, id: string, props: VaultProps);
    isUsedBy(client: TechnicalAsset): void;
}
export declare enum StorageType {
    /**
     * Cloud Provider (storage buckets or similar)
     */
    CLOUD_PROVIDER = 1,
    /**
     * Container Platform (orchestration platform managed storage)
     */
    CONTAINER_PLATFORM = 2,
    /**
     * Database (SQL-DB, NoSQL-DB, object store or similar)
     */
    DATABASE = 3,
    /**
     * Filesystem (local or remote)
     */
    FILESYSTEM = 4,
    /**
     * In-Memory (no persistent storage of secrets)
     */
    IN_MEMORY = 5,
    /**
     * Service Registry
     */
    SERVICE_REGISTRY = 6
}
