"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationLoadBalancer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("..");
const security_group_1 = require("./security-group");
class ApplicationLoadBalancer extends __1.TechnicalAsset {
    constructor(scope, id, props) {
        super(scope, id, {
            description: props.description,
            type: __1.TechnicalAssetType.PROCESS,
            usage: __1.Usage.BUSINESS,
            humanUse: false,
            size: __1.Size.COMPONENT,
            technology: props.waf ? __1.Technology.WAF : __1.Technology.LOAD_BALANCER,
            tags: props.tags,
            internet: false,
            machine: __1.Machine.VIRTUAL,
            encryption: __1.Encryption.NONE,
            owner: "",
            ciaTriad: props.ciaTriad,
            multiTenant: true,
            redundant: true,
            customDevelopedParts: false,
        });
        this.securityGroup = this.trustBoundary =
            props.securityGroup ?? new security_group_1.SecurityGroup(this, `${id} SG`);
        this.securityGroup.addTechnicalAssets(this);
    }
}
exports.ApplicationLoadBalancer = ApplicationLoadBalancer;
_a = JSII_RTTI_SYMBOL_1;
ApplicationLoadBalancer[_a] = { fqn: "cdktg.plus_aws.ApplicationLoadBalancer", version: "0.0.40" };
//# sourceMappingURL=data:application/json;base64,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