"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Quantity = exports.DataAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const model_1 = require("./model");
const resource_1 = require("./resource");
class DataAsset extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.usage = props.usage;
        this.tags = props.tags;
        this.origin = props.origin;
        this.owner = props.owner;
        this.quantity = props.quantity;
        this.ciaTriad = props.ciaTriad;
        if (this.tags && this.tags.length > 0) {
            model_1.Model.of(this).addTags(...this.tags);
        }
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.title]: {
                id: this.id,
                description: this.description ?? null,
                usage: this.usage,
                tags: Array.from(new Set(this.tags)),
                origin: this.origin,
                owner: this.owner,
                quantity: this.quantity,
                ...this.ciaTriad._toThreagile(),
            },
        };
    }
}
exports.DataAsset = DataAsset;
_a = JSII_RTTI_SYMBOL_1;
DataAsset[_a] = { fqn: "cdktg.DataAsset", version: "0.0.40" };
var Quantity;
(function (Quantity) {
    Quantity["VERY_FEW"] = "very-few";
    Quantity["FEW"] = "few";
    Quantity["MANY"] = "many";
    Quantity["VERY_MANY"] = "very-many";
})(Quantity = exports.Quantity || (exports.Quantity = {}));
//# sourceMappingURL=data:application/json;base64,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