"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorization = exports.Authentication = exports.Protocol = exports.Communication = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const COMMUNICATION_SYMBOL = Symbol.for("cdktg/Communication");
class Communication extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.id = createId(props.source.id, id);
        this.title = id;
        this.source = props.source;
        this.target = props.target;
        this.description = props.description;
        this.protocol = props.protocol;
        this.authentication = props.authentication;
        this.authorization = props.authorization;
        this.vpn = props.vpn;
        this.ipFiltered = props.ipFiltered;
        this.readonly = props.readonly;
        this.usage = props.usage;
        this.dataAssetsSent = new Set();
        this.dataAssetsReceived = new Set();
    }
    static isCommunicationl(x) {
        return x !== null && typeof x === "object" && COMMUNICATION_SYMBOL in x;
    }
    sends(...assets) {
        assets.forEach((a) => {
            this.dataAssetsSent.add(a);
        });
    }
    receives(...assets) {
        assets.forEach((a) => {
            this.dataAssetsReceived.add(a);
        });
    }
    hasDataAssets() {
        return this.dataAssetsSent.size > 0 || this.dataAssetsReceived.size > 0;
    }
    isEncrypted() {
        return [
            Protocol.HTTPS,
            Protocol.WSS,
            Protocol.JDBC_ENCRYPTED,
            Protocol.ODBC_ENCRYPTED,
            Protocol.NOSQL_ACCESS_PROTOCOL_ENCRYPTED,
            Protocol.SQL_ACCESS_PROTOCOL_ENCRYPTED,
            Protocol.BINARY_ENCRYPTED,
            Protocol.TEXT_ENCRYPTED,
            Protocol.SSH,
            Protocol.SSH_TUNNEL,
            Protocol.FTPS,
            Protocol.SCP,
            Protocol.LDAPS,
            Protocol.REVERSE_PROXY_WEB_PROTOCOL_ENCRYPTED,
            Protocol.IIOP_ENCRYPTED,
            Protocol.JRMP_ENCRYPTED,
            Protocol.SMB_ENCRYPTED,
            Protocol.SMTP_ENCRYPTED,
            Protocol.POP3_ENCRYPTED,
            Protocol.IMAP_ENCRYPTED,
        ].includes(this.protocol);
    }
    isProcessLocal() {
        return [
            Protocol.IN_PROCESS_LIBRARY_CALL,
            Protocol.LOCAL_FILE_ACCESS,
            Protocol.CONTAINER_SPAWNING,
        ].includes(this.protocol);
    }
    isBidirectional() {
        return this.dataAssetsSent.size > 0 && this.dataAssetsReceived.size > 0;
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.title]: {
                target: this.target.id,
                description: this.description,
                protocol: this.protocol,
                authentication: this.authentication,
                authorization: this.authorization,
                vpn: this.vpn,
                ipFiltered: this.ipFiltered,
                readonly: this.readonly,
                usage: this.usage,
                data_assets_sent: Array.from(this.dataAssetsSent).map((a) => a.id),
                data_assets_received: Array.from(this.dataAssetsReceived).map((a) => a.id),
            },
        };
    }
}
exports.Communication = Communication;
_a = JSII_RTTI_SYMBOL_1;
Communication[_a] = { fqn: "cdktg.Communication", version: "0.0.40" };
function createId(sourceAssetId, title) {
    return sourceAssetId + ">" + title.toLowerCase();
}
var Protocol;
(function (Protocol) {
    Protocol["UNKNOEN"] = "unknown-protocol";
    Protocol["HTTP"] = "http";
    Protocol["HTTPS"] = "https";
    Protocol["WS"] = "ws";
    Protocol["WSS"] = "wss";
    Protocol["REVERSE_PROXY_WEB_PROTOCOL"] = "reverse-proxy-web-protocol";
    Protocol["REVERSE_PROXY_WEB_PROTOCOL_ENCRYPTED"] = "reverse-proxy-web-protocol-encrypted";
    Protocol["MQTT"] = "mqtt";
    Protocol["JDBC"] = "jdbc";
    Protocol["JDBC_ENCRYPTED"] = "jdbc-encrypted";
    Protocol["ODBC"] = "odbc";
    Protocol["ODBC_ENCRYPTED"] = "odbc-encrypted";
    Protocol["SQL_ACCESS_PROTOCOL"] = "sql-access-protocol";
    Protocol["SQL_ACCESS_PROTOCOL_ENCRYPTED"] = "sql-access-protocol-encrypted";
    Protocol["NOSQL_ACCESS_PROTOCOL"] = "nosql-access-protocol";
    Protocol["NOSQL_ACCESS_PROTOCOL_ENCRYPTED"] = "nosql-access-protocol-encrypted";
    Protocol["BINARY"] = "binary";
    Protocol["BINARY_ENCRYPTED"] = "binary-encrypted";
    Protocol["TEXT"] = "text";
    Protocol["TEXT_ENCRYPTED"] = "text-encrypted";
    Protocol["SSH"] = "ssh";
    Protocol["SSH_TUNNEL"] = "ssh-tunnel";
    Protocol["SMTP"] = "smtp";
    Protocol["SMTP_ENCRYPTED"] = "smtp-encrypted";
    Protocol["POP3"] = "pop3";
    Protocol["POP3_ENCRYPTED"] = "pop3-encrypted";
    Protocol["IMAP"] = "imap";
    Protocol["IMAP_ENCRYPTED"] = "imap-encrypted";
    Protocol["FTP"] = "ftp";
    Protocol["FTPS"] = "ftps";
    Protocol["SFTP"] = "sftp";
    Protocol["SCP"] = "scp";
    Protocol["LDAP"] = "ldap";
    Protocol["LDAPS"] = "ldaps";
    Protocol["JMS"] = "jms";
    Protocol["NFS"] = "nfs";
    Protocol["SMB"] = "smb";
    Protocol["SMB_ENCRYPTED"] = "smb-encrypted";
    Protocol["LOCAL_FILE_ACCESS"] = "local-file-access";
    Protocol["NRPE"] = "nrpe";
    Protocol["XMPP"] = "xmpp";
    Protocol["IIOP"] = "iiop";
    Protocol["IIOP_ENCRYPTED"] = "iiop-encrypted";
    Protocol["JRMP"] = "jrmp";
    Protocol["JRMP_ENCRYPTED"] = "jrmp-encrypted";
    Protocol["IN_PROCESS_LIBRARY_CALL"] = "in-process-library-call";
    Protocol["CONTAINER_SPAWNING"] = "container-spawning";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
var Authentication;
(function (Authentication) {
    Authentication["NONE"] = "none";
    Authentication["CREDENTIALS"] = "credentials";
    Authentication["SESSION_ID"] = "session-id";
    Authentication["TOKEN"] = "token";
    Authentication["CLIENT_CERTIFICATE"] = "client-certificate";
    Authentication["TWO_FACTOR"] = "two-factor";
    Authentication["EXTERNALIZED"] = "externalized";
})(Authentication = exports.Authentication || (exports.Authentication = {}));
var Authorization;
(function (Authorization) {
    Authorization["NONE"] = "none";
    Authorization["TECHNICAL_USER"] = "technical-user";
    Authorization["ENDUSER_IDENTITY_PROPAGATION"] = "enduser-identity-propagation";
})(Authorization = exports.Authorization || (exports.Authorization = {}));
//# sourceMappingURL=data:application/json;base64,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