import { Construct } from "constructs";
import { DataAsset } from "./data-asset";
import { TechnicalAsset } from "./technical-asset";
import { Usage } from "./usage";
export interface CommunicationOptions {
    readonly description: string;
    readonly protocol: Protocol;
    readonly authentication: Authentication;
    readonly authorization: Authorization;
    readonly vpn: boolean;
    readonly ipFiltered: boolean;
    readonly readonly: boolean;
    readonly usage: Usage;
}
export interface CommunicationProps extends CommunicationOptions {
    readonly source: TechnicalAsset;
    readonly target: TechnicalAsset;
}
export declare class Communication extends Construct {
    static isCommunicationl(x: any): x is Communication;
    readonly id: string;
    readonly title: string;
    readonly source: TechnicalAsset;
    readonly target: TechnicalAsset;
    readonly description: string;
    readonly protocol: Protocol;
    readonly authentication: Authentication;
    readonly authorization: Authorization;
    readonly vpn: boolean;
    readonly ipFiltered: boolean;
    readonly readonly: boolean;
    readonly usage: Usage;
    private dataAssetsSent;
    private dataAssetsReceived;
    constructor(scope: Construct, id: string, props: CommunicationProps);
    sends(...assets: DataAsset[]): void;
    receives(...assets: DataAsset[]): void;
    hasDataAssets(): boolean;
    isEncrypted(): boolean;
    isProcessLocal(): boolean;
    isBidirectional(): boolean;
    /**
     * @internal
     */
    _toThreagile(): {
        [x: string]: {
            target: string;
            description: string;
            protocol: Protocol;
            authentication: Authentication;
            authorization: Authorization;
            vpn: boolean;
            ipFiltered: boolean;
            readonly: boolean;
            usage: Usage;
            data_assets_sent: string[];
            data_assets_received: string[];
        };
    };
}
export declare enum Protocol {
    UNKNOEN = "unknown-protocol",
    HTTP = "http",
    HTTPS = "https",
    WS = "ws",
    WSS = "wss",
    REVERSE_PROXY_WEB_PROTOCOL = "reverse-proxy-web-protocol",
    REVERSE_PROXY_WEB_PROTOCOL_ENCRYPTED = "reverse-proxy-web-protocol-encrypted",
    MQTT = "mqtt",
    JDBC = "jdbc",
    JDBC_ENCRYPTED = "jdbc-encrypted",
    ODBC = "odbc",
    ODBC_ENCRYPTED = "odbc-encrypted",
    SQL_ACCESS_PROTOCOL = "sql-access-protocol",
    SQL_ACCESS_PROTOCOL_ENCRYPTED = "sql-access-protocol-encrypted",
    NOSQL_ACCESS_PROTOCOL = "nosql-access-protocol",
    NOSQL_ACCESS_PROTOCOL_ENCRYPTED = "nosql-access-protocol-encrypted",
    BINARY = "binary",
    BINARY_ENCRYPTED = "binary-encrypted",
    TEXT = "text",
    TEXT_ENCRYPTED = "text-encrypted",
    SSH = "ssh",
    SSH_TUNNEL = "ssh-tunnel",
    SMTP = "smtp",
    SMTP_ENCRYPTED = "smtp-encrypted",
    POP3 = "pop3",
    POP3_ENCRYPTED = "pop3-encrypted",
    IMAP = "imap",
    IMAP_ENCRYPTED = "imap-encrypted",
    FTP = "ftp",
    FTPS = "ftps",
    SFTP = "sftp",
    SCP = "scp",
    LDAP = "ldap",
    LDAPS = "ldaps",
    JMS = "jms",
    NFS = "nfs",
    SMB = "smb",
    SMB_ENCRYPTED = "smb-encrypted",
    LOCAL_FILE_ACCESS = "local-file-access",
    NRPE = "nrpe",
    XMPP = "xmpp",
    IIOP = "iiop",
    IIOP_ENCRYPTED = "iiop-encrypted",
    JRMP = "jrmp",
    JRMP_ENCRYPTED = "jrmp-encrypted",
    IN_PROCESS_LIBRARY_CALL = "in-process-library-call",
    CONTAINER_SPAWNING = "container-spawning"
}
export declare enum Authentication {
    NONE = "none",
    CREDENTIALS = "credentials",
    SESSION_ID = "session-id",
    TOKEN = "token",
    CLIENT_CERTIFICATE = "client-certificate",
    TWO_FACTOR = "two-factor",
    EXTERNALIZED = "externalized"
}
export declare enum Authorization {
    NONE = "none",
    TECHNICAL_USER = "technical-user",
    ENDUSER_IDENTITY_PROPAGATION = "enduser-identity-propagation"
}
