"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InitCommand = void 0;
const path = require("path");
const fs = require("fs-extra");
const common_1 = require("../common");
class InitCommand {
    constructor() {
        this.command = "init";
        this.describe = "create a new cdk-threagile project";
        this.builder = (args) => {
            args.option("language", {
                type: "string",
                describe: "",
                default: "typescript",
            });
            return args;
        };
        this.handler = async (args) => {
            const gitIgnoreContent = [
                "node_modules",
                ".env",
                ".venv",
                "dist",
                ".cdktg.out",
                ".DS_Store",
            ];
            const requirementsTxtContent = [
                "constructs>=10.0.0",
                `cdktg>=${common_1.CDKTG_VERSION}`,
            ];
            const envContent = "CDKTG_THREAGILE_BASE_URL=";
            fs.writeFileSync(".env", envContent);
            fs.writeFileSync(".gitignore", gitIgnoreContent.join("\n"));
            if (args.language === "python") {
                fs.writeFileSync("requirements.txt", requirementsTxtContent.join("\n"));
                fs.writeJSONSync("package.json", createPackageJson(args.language), {
                    spaces: 4,
                });
                fs.writeFileSync("threagile.py", `import cdktg

project = cdktg.Project()

# Define threat model here

project.synth()
`);
                return;
            }
            fs.writeJSONSync("package.json", createPackageJson(args.language), {
                spaces: 4,
            });
            fs.writeFileSync("threagile.ts", `import { Project } from 'cdktg'

const project = new Project();

// Define threat model here

project.synth();
`);
        };
    }
}
exports.InitCommand = InitCommand;
function createPackageJson(language) {
    const cdktgJson = fs.readJsonSync(path.join(__dirname, "..", "..", "package.json"));
    const scripts = {
        cdktg: "cdktg",
        synth: "cdktg synth threagile.ts",
        ping: "cdktg ping",
        "model:check": "cdktg check",
        "model:analyze": "cdktg analyze",
    };
    if (language === "python") {
        return {
            scripts,
            devDependencies: {
                cdktg: `^${common_1.CDKTG_VERSION}`,
            },
        };
    }
    return {
        scripts,
        dependencies: {
            cdktg: `^${common_1.CDKTG_VERSION}`,
            constructs: cdktgJson.peerDependencies.constructs,
        },
        devDependencies: {
            typescript: cdktgJson.devDependencies.typescript,
        },
    };
}
//# sourceMappingURL=data:application/json;base64,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