"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dotenv_1 = require("dotenv");
const yargs = require("yargs");
const analyze_1 = require("./analyze");
const check_1 = require("./check");
const init_1 = require("./init");
const ping_1 = require("./ping");
const synth_1 = require("./synth");
async function main() {
    dotenv_1.config(); //.env
    const ya = yargs;
    ya.command(new init_1.InitCommand());
    ya.command(new synth_1.SynthCommand());
    ya.command(new ping_1.PingCommand());
    ya.command(new check_1.CheckCommand());
    ya.command(new analyze_1.AnalyzeCommand());
    ya.recommendCommands();
    ya.strictCommands();
    ya.showHelpOnFail(false);
    ya.completion();
    ya.help();
    // do not use the default yargs '--version' implementation since it is
    // global by default (it appears on all subcommands)
    ya.version(false);
    ya.option("version", {
        type: "boolean",
        description: "Show version number",
        global: false,
    });
    const args = ya.argv;
    if (args.debug) {
        process.env.DEBUG = "true";
    }
}
main().catch((e) => {
    console.error(e.message);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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