"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckCommand = void 0;
const path = require("path");
const threagile_1 = require("../api/threagile");
const common_1 = require("../common");
const manifest_1 = require("../manifest");
class CheckCommand {
    constructor() {
        this.command = "check";
        this.describe = "check the models";
        this.builder = (args) => {
            args.option("url", { type: "string", alias: "u", describe: "" });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            const api = new threagile_1.Threagile(url);
            const manifest = manifest_1.Manifest.fromPath(common_1.CDKTG_OUT_DIR);
            for (const k in manifest.models) {
                try {
                    const modelManifest = manifest.models[k];
                    const resp = await api.check(path.join(".cdktg.out", modelManifest.synthesizedModelPath));
                    console.log(`Results for model "${modelManifest.name}":`);
                    if (resp.status === 200) {
                        console.log(`✅  ${resp.data.message}\n`);
                    }
                    else {
                        console.log(`❌  ${resp.data.message}\n`);
                    }
                }
                catch (e) {
                    console.log(`❌  ${e.message}`);
                }
            }
        };
    }
}
exports.CheckCommand = CheckCommand;
//# sourceMappingURL=data:application/json;base64,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