"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnalyzeCommand = void 0;
const path = require("path");
const AdmZip = require("adm-zip");
const fs = require("fs-extra");
const threagile_1 = require("../api/threagile");
const common_1 = require("../common");
const manifest_1 = require("../manifest");
class AnalyzeCommand {
    constructor() {
        this.command = "analyze";
        this.describe = "analyze the models";
        this.builder = (args) => {
            args.option("url", {
                type: "string",
                alias: "u",
                describe: "URL of the threagile rest api",
            });
            args.option("output", {
                type: "string",
                alias: "o",
                describe: "",
                default: "dist",
            });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            fs.mkdirSync(args.output, { recursive: true });
            const api = new threagile_1.Threagile(url);
            const manifest = manifest_1.Manifest.fromPath(common_1.CDKTG_OUT_DIR);
            for (const k in manifest.models) {
                try {
                    const modelManifest = manifest.models[k];
                    const resp = await api.analyze(path.join(common_1.CDKTG_OUT_DIR, modelManifest.synthesizedModelPath));
                    if (resp.status === 400) {
                        console.log(`❌  Errors for model "${k}":`);
                        console.log(resp.data.error);
                        continue;
                    }
                    const zip = new AdmZip(resp.data);
                    zip.extractAllTo(path.join(args.output, modelManifest.sanitizedName));
                }
                catch (e) {
                    console.log(`❌  ${e.message}`);
                }
            }
        };
    }
}
exports.AnalyzeCommand = AnalyzeCommand;
//# sourceMappingURL=data:application/json;base64,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