"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Availability = exports.Integrity = exports.Confidentiality = exports.CIATriad = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class CIATriad {
    constructor(props) {
        this.confidentiality = props.confidentiality;
        this.integrity = props.integrity;
        this.availability = props.availability;
        this.justification = props.justification;
    }
    hasHigherConfidentiality(confidentiality) {
        const confidentialityRank = {
            [Confidentiality.PUBLIC]: 0,
            [Confidentiality.INTERNAL]: 1,
            [Confidentiality.RESTRICTED]: 2,
            [Confidentiality.CONFIDENTIAL]: 3,
            [Confidentiality.STRICTLY_CONFIDENTIAL]: 4,
        };
        const thisRank = confidentialityRank[this.confidentiality];
        const thatRank = confidentialityRank[confidentiality];
        return thisRank > thatRank;
    }
    hasHigherIntegrity(integrity) {
        const integrityRank = {
            [Integrity.ARCHIVE]: 0,
            [Integrity.OPERATIONAL]: 1,
            [Integrity.IMPORTANT]: 2,
            [Integrity.CRITICAL]: 3,
            [Integrity.MISSION_CRITICAL]: 4,
        };
        const thisRank = integrityRank[this.integrity];
        const thatRank = integrityRank[integrity];
        return thisRank > thatRank;
    }
    hasHigherAvailabilty(availability) {
        const availabilityRank = {
            [Availability.ARCHIVE]: 0,
            [Availability.OPERATIONAL]: 1,
            [Availability.IMPORTANT]: 2,
            [Availability.CRITICAL]: 3,
            [Availability.MISSION_CRITICAL]: 4,
        };
        const thisRank = availabilityRank[this.availability];
        const thatRank = availabilityRank[availability];
        return thisRank > thatRank;
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            confidentiality: this.confidentiality,
            integrity: this.integrity,
            availability: this.availability,
            justification_cia_rating: this.justification,
        };
    }
}
exports.CIATriad = CIATriad;
_a = JSII_RTTI_SYMBOL_1;
CIATriad[_a] = { fqn: "cdktg.CIATriad", version: "0.0.40" };
var Confidentiality;
(function (Confidentiality) {
    Confidentiality["PUBLIC"] = "public";
    Confidentiality["INTERNAL"] = "internal";
    Confidentiality["RESTRICTED"] = "restricted";
    Confidentiality["CONFIDENTIAL"] = "confidential";
    Confidentiality["STRICTLY_CONFIDENTIAL"] = "strictly-confidential";
})(Confidentiality = exports.Confidentiality || (exports.Confidentiality = {}));
var Integrity;
(function (Integrity) {
    Integrity["ARCHIVE"] = "archive";
    Integrity["OPERATIONAL"] = "operational";
    Integrity["IMPORTANT"] = "important";
    Integrity["CRITICAL"] = "critical";
    Integrity["MISSION_CRITICAL"] = "mission-critical";
})(Integrity = exports.Integrity || (exports.Integrity = {}));
var Availability;
(function (Availability) {
    Availability["ARCHIVE"] = "archive";
    Availability["OPERATIONAL"] = "operational";
    Availability["IMPORTANT"] = "important";
    Availability["CRITICAL"] = "critical";
    Availability["MISSION_CRITICAL"] = "mission-critical";
})(Availability = exports.Availability || (exports.Availability = {}));
//# sourceMappingURL=data:application/json;base64,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