"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Threagile = void 0;
const fs = require("fs-extra");
const generated_1 = require("./generated");
class Threagile {
    constructor(baseURL) {
        if (!baseURL) {
            throw new Error("Base url is missing!");
        }
        const configuration = new generated_1.Configuration({
            basePath: baseURL,
        });
        this.metaApi = new generated_1.MetaApi(configuration);
        this.directApi = new generated_1.DirectApi(configuration);
    }
    async ping() {
        return this.metaApi.metaPingGet();
    }
    async check(filename) {
        if (!fs.existsSync(filename)) {
            throw new Error(`File ${filename} not exist!`);
        }
        const file = fs.createReadStream(filename);
        return this.directApi.directCheckPost(file);
    }
    async analyze(filename, dpi = 120) {
        if (!fs.existsSync(filename)) {
            throw new Error(`File ${filename} not exist!`);
        }
        const file = fs.createReadStream(filename);
        return this.directApi.directAnalyzePost(dpi, file, {
            responseType: "arraybuffer",
        });
    }
}
exports.Threagile = Threagile;
//# sourceMappingURL=data:application/json;base64,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