import click

from gama_cli.helpers import get_project_root
from pathlib import Path
import os
import random


def write_file(path: str, content: str):
    project_root = get_project_root() or Path()
    click.echo(f"Writing file {project_root / path}")
    with open(project_root / path, "w") as f:
        f.write(content)


class Setup:
    def __init__(self, cli: click.Group):
        @cli.group(help="Setup commands")
        def setup():
            pass

        @setup.command(name="secrets")
        @click.argument("pat")
        def secrets(pat: str):  # type: ignore
            """Setup the .secrets files as docker secrets needs these to build containers"""
            write_file(".secrets/API_TOKEN_GITHUB", pat)

            greenroom_apt_conf = "\n".join(
                [
                    "machine raw.githubusercontent.com/Greenroom-Robotics",
                    f"login {pat}",
                    "password",
                ]
            )
            write_file(".secrets/apt.conf", greenroom_apt_conf)

        @setup.command(name="env")
        def env():  # type: ignore
            """Setup the .env file"""

            random_domain_id_int = random.randint(0, 10000)
            env = "\n".join(
                [
                    f"DISPLAY={os.environ['DISPLAY']}",
                    f"ROS_DOMAIN_ID={random_domain_id_int}",
                ]
            )
            write_file(".env", env)
