"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegManifestSynthesizer = void 0;
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
const manifest_writer_1 = require("./manifest-writer");
const emptyManifest = {
    version: '',
    testCases: {},
};
class IntegManifestSynthesizer {
    constructor(testCases, enableLookups) {
        this.testCases = testCases;
        this.enableLookups = enableLookups;
    }
    synthesize(session) {
        const manifest = {
            enableLookups: this.enableLookups,
            ...this.testCases
                .map(tc => tc.manifest)
                .reduce(mergeManifests, emptyManifest),
        };
        const snapshotDir = session.assembly.outdir;
        manifest_writer_1.IntegManifestWriter.write(manifest, snapshotDir);
    }
}
exports.IntegManifestSynthesizer = IntegManifestSynthesizer;
function mergeManifests(m1, m2) {
    return {
        version: cloud_assembly_schema_1.Manifest.version(),
        testCases: { ...m1.testCases, ...m2.testCases },
    };
}
//# sourceMappingURL=data:application/json;base64,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