#MIT License
#Copyright (c) 2021 Ripe

"""
List of All Supported Language Codes and Default Configurations.

Reference : 
    - https://cloud.google.com/translate/docs/languages

"""
headers  = {
'User-Agent': 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',
'Accept-Encoding': 'gzip, deflate', 
'Accept': '*/*', 
'Connection': 'keep-alive'
}
endpoint = 'translate.google.com'
tdlpoint = 'translate.google.'
client   = 'dict-chrome-ex'
method   = ['single', 't']
key = [
'client'
't',
'translate',
'gts',
'tts']
supported_gts_lang = {
"Language": "ISO-639-1 Code",
"Afrikaans": "af",
"Albanian": "sq",
"Amharic": "am",
"Arabic": "ar",
"Armenian": "hy",
"Azerbaijani": "az",
"Basque": "eu",
"Belarusian": "be",
"Bengali": "bn",
"Bosnian": "bs",
"Bulgarian": "bg",
"Catalan": "ca",
"Cebuano  (ISO-639-2)": "ceb",
"Chinese (Simplified)": "zh-CN",
"Chinese (Simplified) (BCP-47)": "zh",
"Chinese (Traditional) (BCP-47)": "zh-TW",
"Corsican": "co",
"Croatian": "hr",
"Czech": "cs",
"Danish": "da",
"Dutch": "nl",
"English": "en",
"Esperanto": "eo",
"Estonian": "et",
"Finnish": "fi",
"French": "fr",
"Frisian": "fy",
"Galician": "gl",
"Georgian": "ka",
"German": "de",
"Greek": "el",
"Gujarati": "gu",
"Haitian Creole": "ht",
"Hausa": "ha",
"Hawaiian": "haw",
"Hebrew": "he or iw",
"Hindi": "hi",
"Hmong": "hmn",
"Hungarian": "hu",
"Icelandic": "is",
"Igbo": "ig",
"Indonesian": "id",
"Irish": "ga",
"Italian": "it",
"Japanese": "ja",
"Javanese": "jv",
"Kannada": "kn",
"Kazakh": "kk",
"Khmer": "km",
"Kinyarwanda": "rw",
"Korean": "ko",
"Kurdish": "ku",
"Kyrgyz": "ky",
"Lao": "lo",
"Latin": "la",
"Latvian": "lv",
"Lithuanian": "lt",
"Luxembourgish": "lb",
"Macedonian": "mk",
"Malagasy": "mg",
"Malay": "ms",
"Malayalam": "ml",
"Maltese": "mt",
"Maori": "mi",
"Marathi": "mr",
"Mongolian": "mn",
"Myanmar (Burmese)": "my",
"Nepali": "ne",
"Norwegian": "no",
"Nyanja (Chichewa)": "ny",
"Odia (Oriya)": "or",
"Pashto": "ps",
"Persian": "fa",
"Polish": "pl",
"Portuguese (Portugal, Brazil)": "pt",
"Punjabi": "pa",
"Romanian": "ro",
"Russian": "ru",
"Samoan": "sm",
"Scots Gaelic": "gd",
"Serbian": "sr",
"Sesotho": "st",
"Shona": "sn",
"Sindhi": "sd",
"Sinhala (Sinhalese)": "si",
"Slovak": "sk",
"Slovenian": "sl",
"Somali": "so",
"Spanish": "es",
"Sundanese": "su",
"Swahili": "sw",
"Swedish": "sv",
"Tagalog (Filipino)": "tl",
"Tajik": "tg",
"Tamil": "ta",
"Tatar": "tt",
"Telugu": "te",
"Thai": "th",
"Turkish": "tr",
"Turkmen": "tk",
"Ukrainian": "uk",
"Urdu": "ur",
"Uyghur": "ug",
"Uzbek": "uz",
"Vietnamese": "vi",
"Welsh": "cy",
"Xhosa": "xh",
"Yiddish": "yi",
"Yoruba": "yo",
"Zulu": "zu"
}
supported_tts_lang = [
 "af",
 "sq",
 "ar",
 "hy",
 "bn",
 "bs",
 "ca",
 "hr",
 "cs",
 "da",
 "nl",
 "en",
 "eo",
 "et",
 "tl",
 "fi",
 "fr",
 "de",
 "el",
 "gu",
 "hi",
 "hu",
 "is",
 "id",
 "it",
 "ja",
 "jw",
 "kn",
 "km",
 "ko",
 "la",
 "lv",
 "mk",
 "ml",
 "mr",
 "my",
 "ne",
 "no",
 "pl",
 "pt",
 "ro",
 "ru",
 "sr",
 "si",
 "sk",
 "es",
 "su",
 "sw",
 "sv",
 "ta",
 "te",
 "th",
 "tr",
 "uk",
 "ur",
 "vi",
 "cy",
 "zh-cn",
 "zh-tw",
 "en-us",
 "en-ca",
 "en-uk",
 "en-gb",
 "en-au",
 "en-gh",
 "en-in",
 "en-ie",
 "en-nz",
 "en-ng",
 "en-ph",
 "en-za",
 "en-tz",
 "fr-ca",
 "fr-fr",
 "pt-br",
 "pt-pt",
 "es-es",
 "es-us"]
