from NumberScript.interpreter import Interpreter
import argparse
import os
from datetime import datetime

now = datetime.now()

current_time = now.strftime("%H:%M:%S")

parser = argparse.ArgumentParser()

parser.add_argument("-f", "--file", help="file to interpret")

args = parser.parse_args()
run = True

space = ""
for j in range(0, 16):
    space += " "

for k in range(0, len(os.name)):
    space = space.replace(" ", "", 1)

if args.file:
    with open(args.file, "r") as file:
        code = file.read()
        Interpreter.interpret(code)
else:
    print(f"""
        +------------------------------------------+
        | NumberScript Shell: Type 'exit' to exit. |
        | Version: 1.0 Machine: {os.name} {space}  |
        | Type 'help' for more information.        |
        | {current_time}                                 |
        +------------------------------------------+
    """)
    while run:
        code = input(">")
        if code == "exit":
            run = False
        else:
            Interpreter.interpret(code)