//////////// THIS FILE MUST BE CREATED BY EXECUTING WriteAttributeDefinitionFile ////////////
//////////// DO NOT MODIFY THIS FILE MANUALLY ///////////////////////////////////////////////

#ifndef __NOMAD400_RUNATTRIBUTESDEFINITION__
#define __NOMAD400_RUNATTRIBUTESDEFINITION__

_definition = {
{ "SEED",  "int",  "0",  " The seed for the pseudo-random number generator ",  " \n  \n . Random seed \n  \n . Argument: one nonnegative integer (max UINT32_MAX), or -1, or the string 'DIFF' \n  \n . The default value is used for each run if the parameter is not provided. \n  \n . If '-1' or 'DIFF' is entered the seed is different for each run (PID is used). \n  \n . The seed is used in the output file names \n  \n . Example: SEED 123456 \n  \n . Default: 0\n\n",  "  advanced seed seeds random number run  "  , "true" , "true" , "true" },
{ "ADD_SEED_TO_FILE_NAMES",  "bool",  "true",  " The flag to add seed to the file names ",  " \n  \n . If \'yes\', the seed is added to the name of output file provided by STATS_FILE \n  \n . Argument: one boolean (\'yes\' or \'no\') \n  \n . Example: ADD_SEED_TO_FILE_NAMES no \n  \n . Default: true\n\n",  "  advanced seed seeds random number run stat stats file history solution solutions  "  , "false" , "false" , "true" },
{ "NB_THREADS_OPENMP",  "int",  "-1",  " The number of threads when OpenMP parallel evaluations \n are enabled ",  " \n  \n . Set the number of threads to be used by OpenMP. \n  \n . Argument: One positive integer, or -1. A value of -1 means OpenMP decides \n   by itself. \n  \n . Example: NB_THREADS_OPENMP 8 \n  \n . Default: -1\n\n",  "  advanced thread threads openmp parallel eval evals evaluation evaluations  "  , "true" , "false" , "true" },
{ "HOT_RESTART_READ_FILES",  "bool",  "false",  " Flag to read hot restart files ",  " \n  \n . If true, the hot restart files (hotRestart.txt and CACHE_FILE) are read \n   when NOMAD is started. If NOMAD is ran twice, the second run starts from \n   where the first run ended. \n  \n . If false, the hot restart files are ignored when NOMAD is started. Two runs \n   in a row will start from the same configuration. \n  \n . See also: HOT_RESTART_WRITE_FILES, CACHE_FILE \n  \n . Default: false\n\n",  "  advanced hot restart file files interrupt  "  , "false" , "false" , "true" },
{ "HOT_RESTART_WRITE_FILES",  "bool",  "false",  " Flag to write hot restart files ",  " \n  \n . If true, when NOMAD ends, write the hot restart files (hotRestart.txt and \n   CACHE_FILE). \n  \n . See also: HOT_RESTART_READ_FILES, CACHE_FILE \n  \n . Default: false\n\n",  "  advanced hot restart file files interrupt  "  , "false" , "false" , "true" },
{ "HOT_RESTART_ON_USER_INTERRUPT",  "bool",  "false",  " Flag to perform a hot restart on user interrupt ",  " \n  \n . If true, when NOMAD runs and the user does an interruption (CTRL+C), \n   then the parameters can be modified. Upon pressing CTRL+D, the resolution \n   continues where it was stopped, using the modified parameters. \n  \n . If false, when NOMAD runs and the user does an interruption (CTRL+C), \n   the resolution ends. \n  \n . Default: false\n\n",  "  advanced hot restart file files interrupt  "  , "false" , "false" , "true" },
{ "HOT_RESTART_FILE",  "std::string",  "hotrestart.txt",  " The name of the hot restart file ",  " \n  \n . Name of the file where the information about hot restart is kept. \n  \n  \n . Default: hotrestart.txt\n\n",  "  advanced hot restart file files file interrupt  "  , "false" , "false" , "true" },
{ "REJECT_UNKNOWN_PARAMETERS",  "bool",  "false",  " Flag to reject unknown parameters when checking validity of parameters ",  " \n  \n . If true, when reading a parameters file, NOMAD will ignore unknown parameters. \n  \n . If false, when reading a parameters file, NOMAD will exit if unknown \n   parameters are present. \n  \n . Default: false\n\n",  "  advanced valid param params parameter parameters ignore  "  , "false" , "false" , "true" },
{ "LH_SEARCH",  "NOMAD::LHSearchType",  "-",  " Latin Hypercube Sampling Search method ",  " \n  \n . Latin-Hypercube sampling (search) \n  \n . Arguments: two size_t p0 and pi \n  \n . p0: number of initial LH search points \n  \n . pi: LH search points at each iteration \n  \n . The search can be opportunistic or not \n   (parameter OPPORTUNISTIC_EVAL) \n  \n . Example: LH_SEARCH 100 0 \n  \n . No default value.\n\n",  "  basic search latin hypercube sampling opportunistic_lh  "  , "true" , "true" , "true" },
{ "LH_EVAL",  "size_t",  "0",  " Latin Hypercube Sampling of points (no optimization) ",  " \n  \n . Latin-Hypercube sampling (evaluations) \n  \n . Argument: A positive integer p < INF \n  \n . p: number of LH points \n  \n . All points will be evaluated (no opportunism). This options will deactivate \n   any optimization strategy. \n  \n . The LH sampling requires to have both lower and upper bounds defined. \n  \n . Example: LH_EVAL 100 \n  \n . Default: 0\n\n",  "  basic latin hypercube sampling  "  , "true" , "true" , "true" },
{ "SGTELIB_MODEL_EVAL",  "bool",  "0",  " Sgtelib Model Sampling of points ",  " \n  \n . Sgtelib Model sampling \n  \n . Argument: bool \n  \n . Best points are taken from the cache \n  \n . A model is computed \n  \n . The most promising points according to that model are evaluated \n  \n . No opportunism \n  \n . This option deactivates other optimization strategies. \n  \n . Example: SGTELIB_MODEL_EVAL true \n  \n . Default: 0\n\n",  "  advanced sgtelib model sampling  "  , "true" , "false" , "true" },
{ "H_MAX_0",  "NOMAD::Double",  "NOMAD::INF",  " Initial value of hMax. ",  " \n . Initial value of hMax. Used for progressive barrier (PB) constraints. \n  \n . Argument: one positive real. \n  \n . Points x such that h(x) > hMax are rejected. h measures the feasibility, or \n   how much the constraints are violated. \n  \n . Example: H_MAX_0 100.0 \n  \n . Default: NOMAD::INF\n\n",  "  advanced hmax h_max constraint constraints pb feasibility progressive barrier  "  , "true" , "false" , "true" },
{ "SGTELIB_SEARCH",  "bool",  "false",  " Model search using Sgtelib ",  " \n  \n . MADS model search, using Bastien Talgorn's Sgtelib \n  \n . This replaces the MODEL_SEARCH parameter from NOMAD 3 \n  \n . Argument: one boolean ('yes' or 'no') \n  \n . Disabled for more than 50 variables \n  \n . Example: SGTELIB_SEARCH yes \n  \n . See also: DISABLE \n . Default: false\n\n",  "  basic mads model search sgtelib model_search  "  , "true" , "true" , "true" },
{ "QUAD_MODEL_SEARCH",  "bool",  "false",  " Quad model search using Sgtelib ",  " \n  \n . MADS model search, using Bastien Talgorn's Sgtelib with quad models \n  \n . Argument: one boolean ('yes' or 'no') \n  \n . Disabled for more than 50 variables \n  \n . Example: QUAD_MODEL_SEARCH yes \n  \n . See also: DISABLE \n . Default: false\n\n",  "  basic mads quad model search sgtelib model_search  "  , "true" , "true" , "true" },
{ "MODEL_DISPLAY",  "std::string",  "",  " Display of a model ",  " \n . Control the display of the quad model search and quad model optimization. \n   These details are only shown if DISPLAY_DEGREE is FULL (3) or more. \n  \n . Arguments: a string containing one or several of the following letters \n  \n . \"S\": General information on the model (sgtelib or quad) search or optimization \n  \n . \"F\": Details of the filter step \n  \n . \"O\": Details of the models optimization \n  \n . \"P\": Details of the projection \n  \n . \"U\": Details of the model update \n  \n . \"I\": Advancement of the model optimization \n  \n . \"X\": Display of all of the model evaluations \n  \n . Example: MODEL_DISPLAY SPF # display the general information on the search \n                                        and on the filter and projection steps \n . Default: Empty string.\n\n",  "  developer advanced model quad sgtelib  "  , "false" , "false" , "true" },
{ "QUAD_MODEL_OPTIMIZATION",  "bool",  "false",  " Quad model stand alone optimization for constrained and unconstrained pbs ",  " \n  \n . Quadratic model optimization for constrained and unconstrained \n   optimization \n  \n . Argument: bool \n  \n . Stand alone quadratic model optimization will deactivate any optimization \n   strategy. \n  \n . Example: QUAD_MODEL_OPTIMIZATION true \n  \n . Default: false\n\n",  "  advanced sgtelib quadratic quad optimization simplex  "  , "true" , "false" , "true" },
{ "SGTELIB_MODEL_DEFINITION",  "NOMAD::ArrayOfString",  "",  " Definition of the surrogate model ",  " \n . Argument: Array of string that represent the Sgtelib model definition. See sgtelib manual. \n  \n . Example: TYPE PRS DEGREE 1 # builds a linear model \n .          TYPE PRS DEGREE 2 # builds a quadratic model \n .          TYPE RBF          # builds an RBF model \n .          TYPE ENSEMBLE     # builds an ensemble of models \n            # builds a lowess model with local linear regression \n            # and optimized kernel shape: \n .          TYPE LOWESS DEGREE 1 KERNEL_COEF OPTIM \n .          # Variation that gives good results: \n            TYPE LOWESS DEGREE 1 KERNEL_SHAPE OPTIM KERNEL_COEF OPTIM RIDGE 0 METRIC AOECV \n . Default: Empty string.\n\n",  "  advanced sgtelib search model model_search interpolation regression  "  , "true" , "true" , "true" },
{ "SGTELIB_MODEL_TRIALS",  "size_t",  "1",  " Max number of sgtelib model search failures before going to the poll step ",  " \n . Max number of sgtelib model search failures before going to the poll step. \n  \n . Argument: one positive integer \n  \n . Note: The minimum between this parameter and MAX_ITERATION_PER_MEGAITERATION \n   will be used. \n  \n . Example: SGTELIB_MODEL_TRIALS 5 \n . Default: 1\n\n",  "  developer trials sgtelib model search  "  , "true" , "true" , "true" },
{ "SGTELIB_MODEL_FORMULATION",  "NOMAD::SgtelibModelFormulationType",  "FS",  " Formulation of the surrogate problem ",  " \n . Formulation of the surrogate problem. \n  \n . Argument: one string in {'FS', 'EIS', 'FSP', \n                            'EFI', 'EFIS','EFIM','EFIC', \n                            'PFI', \n                            'D', \n                            'EXTERN'} \n  \n . Description of the surrogate problem formulations : \n     (FS)   min f    -d.sigma_f \n            st  c_j  -d.sigma_j <= 0 \n  \n     (EIS)  min -EI  -d.sigma_f \n            st  c_j  -d.sigma_j <= 0 \n  \n     (FSP)  min f    -d.sigma_f \n            st  P >= 1/2 \n  \n     (EFI)  min -EFI \n  \n     (EFIS) min -EFI -d.sigma_f \n  \n     (EFIM) min -EFI -d.sigma_f.mu \n  \n     (EFIM) min -EFI -d.(EI.mu+P.sigma_f) \n  \n     (PFI)  min -PFI \n  \n     (D)    min -distance_to_closest \n  \n . Example: SGTELIB_MODEL_FORMULATION EFI \n . Default: FS\n\n",  "  developer advanced surrogate problem expected improvement diversification model sgtelib  "  , "true" , "true" , "true" },
{ "SGTELIB_MODEL_FEASIBILITY",  "NOMAD::SgtelibModelFeasibilityType",  "C",  " Method used to model the feasibility of a point ",  " \n . Method used to model the feasibility of a point. \n  \n . Arguments: one character in {'C', 'H', 'M', 'P'} \n  \n . Example: SGTELIB_MODEL_FEASIBILITY C  # 1 model per constraint \n            SGTELIB_MODEL_FEASIBILITY H  # 1 model of the aggregate constraint \n            SGTELIB_MODEL_FEASIBILITY M  # 1 model of the max of the constraints \n            SGTELIB_MODEL_FEASIBILITY B  # 1 binary model of the feasibility \n . Default: C\n\n",  "  developer advanced feasibility constraints interpolation regression model sgtelib  "  , "true" , "true" , "true" },
{ "SGTELIB_MODEL_DIVERSIFICATION",  "NOMAD::Double",  "0.01",  " Coefficient of the exploration term in the surrogate problem ",  " \n . Coefficient of the exploration term in the surrogate problem. \n  \n . Argument: one positive real \n  \n . Example: SGTELIB_MODEL_DIVERSIFICATION 0    # no exploration \n            SGTELIB_MODEL_DIVERSIFICATION 0.01 # light exploration \n            SGTELIB_MODEL_DIVERSIFICATION 0.1  # medium exploration \n            SGTELIB_MODEL_DIVERSIFICATION 1    # strong exploration \n . Default: 0.01\n\n",  "  developer advanced model sgtelib  "  , "true" , "true" , "true" },
{ "SGTELIB_MODEL_EXCLUSION_AREA",  "NOMAD::Double",  "0.0",  " Exclusion area for the sgtelib model search around points of the cache ",  " \n . Defines an exclusion area for the sgtelib model search around points of the cache \n  \n . Arguments: one real number in [0, 0.5] \n  \n . Example: SGTELIB_MODEL_EXCLUSION_AREA 0 # no exclusion area \n            SGTELIB_MODEL_EXCLUSION_AREA 0.1 # small exclusion area \n            SGTELIB_MODEL_EXCLUSION_AREA 0.5 # large exclusion area \n  \n . Default: 0.0\n\n",  "  developer advanced model sgtelib  "  , "true" , "true" , "true" },
{ "SGTELIB_MODEL_CANDIDATES_NB",  "int",  "-1",  " Number of candidates returned by the sgtelib model search ",  " \n . Number of candidates returned by the sgtelib model search. \n  \n . Argument: one integer \n  \n . If smaller or equal to 0, then the number of candidates \n   will be the largest value between BB_MAX_BLOCK_SIZE and \n   2 * DIMENSION \n  \n . Example: SGTELIB_MODEL_CANDIDATES_NB 8 \n . Default: -1\n\n",  "  developer advanced model sgtelib  "  , "true" , "true" , "true" },
{ "SGTELIB_MIN_POINTS_FOR_MODEL",  "size_t",  "1",  " Minimum number of valid points necessary to build a model ",  " \n . Defines the minimum number of valid points beyond which no model will \n   be build \n  \n . Arguments: one positive integer \n  \n . Example: SGTELIB_MIN_POINTS_FOR_MODEL 5 \n  \n . Default: 1\n\n",  "  developer advanced model sgtelib  "  , "true" , "true" , "true" },
{ "SGTELIB_MAX_POINTS_FOR_MODEL",  "size_t",  "100",  " Maximum number of valid points used to build a model ",  " \n . Defines the maximum number of valid points kept to build a model. \n   Extra points are ignored. \n  \n . Arguments: one positive integer \n  \n . Example: SGTELIB_MAX_POINTS_FOR_MODEL 96 \n  \n . Default: 100\n\n",  "  developer advanced model sgtelib  "  , "true" , "true" , "true" },
{ "SGTELIB_MODEL_FILTER",  "std::string",  "2345",  " Methods used in the sgtelib search filter to return several search candidates ",  " \n . Methods used in the sgtelib search filter to return several search candidates \n  \n . Arguments: a string containing several integers from 0 to 5 \n  \n . Method 0: Select the best candidate \n  \n . Method 1: Select the most remote candidate \n  \n . Method 2: Select the best candidate, with minimal distance to the cache \n  \n . Method 3: Select the best candidate, with minimal margin in feasibility \n  \n . Method 4: Select the candidate with the best isolation number \n  \n . Method 5: Select the candidate with the best density number \n  \n . Examples: SGTELIB_MODEL_FILTER 0    # Only method 0 will be used \n             SGTELIB_MODEL_FILTER 01   # Alternate between method 0 and 1 \n             SGTELIB_MODEL_FILTER 2345 # Cycle through methods 2, 3, 4 and 5 \n . Default: 2345\n\n",  "  developer advanced model sgtelib  "  , "true" , "true" , "true" },
{ "MODEL_SEARCH_PROJ_TO_MESH",  "bool",  "true",  " Model search trial points are projected to the mesh ",  " \n . True if model search trial points are projected to the mesh \n  \n . Argument: one boolean ('yes' or 'no') \n  \n . Example: MODEL_SEARCH_PROJ_TO_MESH no \n . Default: true\n\n",  "  developer models sgtelib  "  , "true" , "true" , "true" },
{ "SPECULATIVE_SEARCH",  "bool",  "true",  " MADS speculative search method ",  " \n  \n . MADS speculative search (optimistic strategy) \n  \n . Argument: one boolean ('yes' or 'no') \n  \n . Example: SPECULATIVE_SEARCH no \n  \n . Default: true\n\n",  "  basic mads search speculative  "  , "true" , "true" , "true" },
{ "SPECULATIVE_SEARCH_MAX",  "size_t",  "1",  " MADS speculative search method ",  " \n  \n . Number of points to generate using the MADS speculative search (optimistic \n   strategy) \n  \n . Argument: one positive integer \n  \n . Example: SPECULATIVE_SEARCH_MAX 2 \n  \n . Default: 1\n\n",  "  advanced mads search speculative  "  , "true" , "true" , "true" },
{ "ANISOTROPIC_MESH",  "bool",  "true",  " MADS uses anisotropic mesh for generating directions ",  " \n  \n . MADS uses anisotropic mesh for generating directions \n  \n . Argument: one boolean ('yes' or 'no') \n  \n . Example: ANISOTROPIC_MESH no \n  \n . Default: true\n\n",  "  advanced mads direction directions anisotropic anisotropy aniso  "  , "true" , "true" , "true" },
{ "ANISOTROPY_FACTOR",  "NOMAD::Double",  "0.1",  " MADS anisotropy factor for mesh size change ",  " \n  \n . Set anisotropy_factor for mesh relative coarsening/refining if the anisotropic \n   mesh is enabled. \n  \n . Argument: one positive real \n  \n . Example: ANISOTROPY_FACTOR 0.05 \n  \n . Default: 0.1\n\n",  "  advanced mads direction directions anisotropic anisotropy aniso  "  , "true" , "true" , "true" },
{ "GENERATE_ALL_POINTS_BEFORE_EVAL",  "bool",  "false",  " Evaluate points generated from Search and Poll steps all at once ",  " \n . If true, generate all points from Search and Poll steps, and then \n   start evaluation. This method is preferred when multiple processes \n   are available in parallel to evaluate points. This way, more processes \n   will work on evaluating points simultaneously. \n  \n . If false, generate points from Search, evaluate them, and then continue \n   to Poll, or to next Search. This is the classic way of evaluation. \n   If multiple processes are available for evaluation, and the Search step \n   generated a single point, only that point is evaluated while the other \n   processes do nothing. \n  \n . Default: false\n\n",  "  advanced  "  , "true" , "true" , "true" },
{ "USER_CALLS_ENABLED",  "bool",  "true",  " Controls the automatic calls to user function ",  " \n . If true the user functions are called (update_iteration, ...) \n  \n . Default: true\n\n",  "  advanced user users callback function functions  "  , "false" , "true" , "true" },
{ "FRAME_CENTER_USE_CACHE",  "bool",  "false",  " Find best points in the cache and use them as frame centers ",  " \n . When this parameter is true, when the Update step occurs, the points with \n   the best values are found in the Cache. Multiple points may have the same \n   value. These points are all used as frame centers for the next Search and \n   Poll steps. \n  \n . When this parameter is false, the frame centers (one feasible and one \n   infeasible) are kept from previous iterations. This is the classical \n   MADS algorithm. \n  \n . Default: false\n\n",  "  advanced  "  , "true" , "true" , "true" },
{ "MAX_TIME",  "size_t",  "INF",  " Maximum wall-clock time in seconds ",  " \n . Argument: one positive integer. INF means there is no maximum. \n  \n . Example: MAX_TIME 3600 # one hour max \n  \n . Default: INF\n\n",  "  basic clock stop time  "  , "false" , "true" , "true" },
{ "NM_OPTIMIZATION",  "bool",  "false",  " Nelder Mead stand alone optimization for constrained and unconstrained pbs ",  " \n  \n . Nelder Mead optimization for constrained and unconstrained optimization \n  \n . Argument: bool \n  \n . Stand alone Nelder Mead optimization will deactivate any optimization strategy. \n  \n . Example: NM_OPTIMIZATION true \n  \n . Default: false\n\n",  "  advanced nelder mead simplex  "  , "true" , "false" , "true" },
{ "NM_SEARCH",  "bool",  "true",  " Nelder Mead optimization used as a search step for Mads ",  " \n  \n . Nelder Mead optimization as a search step for Mads \n  \n . Argument: bool \n  \n . If NM_OPTIMIZATION is true, no optimization algorithm will be performed. \n  \n . Example: NM_SEARCH fase \n  \n . Default: true\n\n",  "  advanced nelder mead simplex mads search "  , "true" , "true" , "true" },
{ "NM_SIMPLEX_INCLUDE_LENGTH",  "NOMAD::Double",  "INF",  " Construct NM simplex using points in cache.",  " \n  \n . Construct NM simplex using points in cache within a given distance of poll \n   center in absolute value. \n  \n . Argument: Positive double. INF means all points are considered. \n  \n . Example: NM_SIMPLEX_INCLUDE_LENGTH 0.2 \n  \n . Default: INF\n\n",  "  advanced nelder mead simplex length "  , "true" , "true" , "true" },
{ "NM_SIMPLEX_INCLUDE_FACTOR",  "size_t",  "8",  " Construct NM simplex using points in cache.",  " \n  \n . Construct NM simplex using points in cache within a given length of frame center \n   relative. The length equals the include factor multiplied by the frame size. \n   Used only if the mesh is defined. \n  \n . Argument: Positive integer. INF means all points are considered. \n  \n . Example: NM_SIMPLEX_INCLUDE_FACTOR 10 \n  \n . Default: 8\n\n",  "  advanced nelder mead simplex include factor length poll  "  , "true" , "true" , "true" },
{ "NM_DELTA_E",  "NOMAD::Double",  "2",  " NM expansion parameter delta_e.",  " \n  \n . Nelder Mead expansion parameter \n  \n . Argument: Positive NOMAD::Double > 1 \n  \n . Example: NM_DELTA_E 2.5 \n  \n . Default: 2\n\n",  "  advanced nelder mead simplex expansion  "  , "true" , "true" , "true" },
{ "NM_DELTA_IC",  "NOMAD::Double",  "-0.5",  " NM inside contraction parameter delta_ic.",  " \n  \n . Nelder Mead inside contraction parameter \n  \n . Argument: Negative NOMAD::Double \n  \n . Example: NM_DELTA_IC -1 \n  \n . Default: -0.5\n\n",  "  advanced nelder mead simplex inside contraction  "  , "true" , "true" , "true" },
{ "NM_DELTA_OC",  "NOMAD::Double",  "0.5",  " NM outside contraction parameter delta_oc.",  " \n  \n . Nelder Mead outside contraction parameter \n  \n . Argument: Positive NOMAD::Double <= 1 \n  \n . Example: NM_DELTA_OC 0.8 \n  \n . Default: 0.5\n\n",  "  advanced nelder mead simplex outside contraction  "  , "true" , "true" , "true" },
{ "NM_GAMMA",  "NOMAD::Double",  "0.5",  " NM shrink parameter gamma.",  " \n  \n . Nelder Mead shrink parameter \n  \n . Argument: Positive NOMAD::Double <= 1 \n  \n . Example: NM_GAMMA 0.8 \n  \n . Default: 0.5\n\n",  "  advanced nelder mead simplex shrink  "  , "true" , "true" , "true" },
{ "NM_SEARCH_MAX_TRIAL_PTS_NFACTOR",  "size_t",  "80",  " NM-Mads search stopping criterion.",  " \n  \n . NM-Mads stopping criterion. Max number of trial pts < dimension * NFactor \n  \n . Argument: Positive integer. INF disables this criterion. \n  \n . Example: NM_SEARCH_MAX_TRIAL_PTS_NFACTOR 100 \n  \n . Default: 80\n\n",  "  advanced nelder mead mads search stop trial  "  , "true" , "true" , "true" },
{ "NM_SEARCH_RANK_EPS",  "NOMAD::Double",  "0.01",  " NM-Mads epsilon for the rank of DZ.",  " \n  \n . Precision to detect when a vector increases the rank or not. \n  \n . Argument: Positive double. \n  \n . Example: NM_SEARCH_RANK_EPS 1E-4 \n  \n . Default: 0.01\n\n",  "  advanced nelder mead mads search rank DZ  "  , "true" , "true" , "true" },
{ "NM_SEARCH_STOP_ON_SUCCESS",  "bool",  "false",  " NM-Mads search stops on success.",  " \n  \n . NM-Mads search opportunistically stops on success. \n  \n . Argument: boolean. \n  \n . Example: NM_SEARCH_STOP_ON_SUCCESS false \n  \n . Default: false\n\n",  "  advanced nelder mead mads search opportunistic success  "  , "true" , "true" , "true" },
{ "DISABLE",  "NOMAD::ArrayOfString",  "",  "Forcefully disable a feature",  " \n . This parameter is used to forcefully disable a feature. \n  \n . Argument: MODELS or EVAL_SORT \n  \n . DISABLE MODELS disables all uses of models. It is equivalent to set: \n       QUAD_MODEL_SEARCH and SGTELIB_SEARCH no \n  \n . WARNING: Settings of SGTELIB_SEARCH will be ignored \n  \n . DISABLE EVAL_SORT enforces that points remain in lexicographical order \n   before being send to evaluation. \n  \n . Default: Empty string.\n\n",  "  advanced model  "  , "true" , "true" , "false" },
{ "MODEL_RADIUS_FACTOR",  "NOMAD::Double",  "4.0",  " Model radius factor ",  " \n . Model radius factor \n  \n . This parameter is used to select points to build the model \n  \n . Frame size is multiplied by this factor to get the search radius \n  \n . Points inside a circle centered on the poll center, within this radius, \n   are selected to build the model \n  \n . Arguments: one strictly positive real \n  \n . Example: MODEL_RADIUS_FACTOR 1.0 \n . Default: 4.0\n\n",  "  developer model  "  , "true" , "true" , "true" },
{ "MAX_ITERATIONS",  "size_t",  "INF",  " The maximum number of iterations of the MADS algorithm ",  " \n  \n . Maximum number of iterations \n  \n . Argument: one positive integer. INF means there is no maximum. \n  \n . Example: MAX_ITERATIONS 1000 \n  \n . Default: INF\n\n",  "  advanced max maximum iteration iterations stop stops stopping criterion criterions  "  , "true" , "true" , "true" },
{ "MAX_ITERATION_PER_MEGAITERATION",  "size_t",  "10",  " Maximum number of Iterations to generate for each MegaIteration. ",  " \n . Maximum number of Iterations to generate for each MegaIteration. \n  \n . Argument: one positive integer. INF means there is no maximum. \n  \n . If there are few points in the barrier, this parameter has no effect. \n  \n . If FRAME_CENTER_USE_CACHE is false, this parameter has no effect. \n  \n . If there are many points in the barrier, this parameter limits \n   the number of iterations generated. \n   A mixture of feasible and infeasible points of the barrier is used to \n   generate iterations. \n   Each iteration uses a point of the barrier as frame center. \n  \n . Default: 10\n\n",  "  advanced  "  , "true" , "true" , "true" },
{ "PSD_MADS_OPTIMIZATION",  "bool",  "0",  " PSD-MADS optimization algorithm ",  " \n  \n . Use PSD-MADS algorithm. \n  \n . Argument: bool \n  \n . Description: Parallel Space Decomposition with Mads (no parallelism) \n  \n . This option deactivates any other optimization strategy. \n  \n . Example: PSD_MADS_OPTIMIZATION true \n  \n . Default: 0\n\n",  "  advanced psd mads parallel decomposition  "  , "true" , "false" , "true" },
{ "PSD_MADS_NB_VAR_IN_SUBPROBLEM",  "size_t",  "2",  " Number of variables in PSD-MADS subproblems ",  " \n  \n . When using Parallel Space Decomposition (PSD) MADS algorithm, select the \n   number of variables in Mads subproblems. \n  \n . Argument: size_t \n  \n . Description: Size of subroblems in PSD-Mads. \n  \n . This attribute is used only when PSD-Mads optimization is active. \n  \n . Example: PSD_MADS_NB_VAR_IN_SUBPROBLEM 3 \n  \n . Default: 2\n\n",  "  advanced psd mads parallel decomposition subproblem  "  , "true" , "false" , "true" },
{ "PSD_MADS_NB_SUBPROBLEM",  "size_t",  "INF",  " Number of PSD-MADS subproblems ",  " \n  \n . When using Parallel Space Decomposition (PSD) MADS algorithm, select the number of \n   Mads subproblems. By default (INF), the number of subproblems is adjusted to \n   cover all variables. \n  \n . Argument: size_t \n  \n . This attribute is used only when PSD-Mads optimization is active. \n  \n . Example: PSD_MADS_NB_SUBPROBLEM 2 \n  \n . Default: INF\n\n",  "  advanced psd mads parallel decomposition subproblem  "  , "true" , "false" , "true" },
{ "PSD_MADS_ITER_OPPORTUNISTIC",  "bool",  "true",  " Opportunistic strategy between the Mads subproblems in PSD-MADS ",  " \n  \n . When using Parallel Space Decomposition (PSD) MADS algorithm, the launch \n   of Mads subproblems during an iteration can be opportunistically stopped when \n   a success is obtained by a Mads subproblem. \n  \n . Argument: bool \n  \n . This attribute is used only when PSD-Mads optimization is active. \n  \n . Example: PSD_MADS_OPPORTUNISTIC false \n  \n . Default: true\n\n",  "  advanced parallel space mads parallel decomposition subproblem opportunistic  "  , "true" , "false" , "true" },
{ "PSD_MADS_ORIGINAL",  "bool",  "false",  " Use NOMAD 3 strategy for mesh update in PSD-MADS ",  " \n  \n . When using Parallel Space Decomposition (PSD) MADS algorithm,  \n   NOMAD 3 strategy is to always update the mesh whenever a new pollster is launched. \n   NOMAD 4 strategy is more defined as for which conditions must be met for \n   the mesh to be updated. \n  \n . Argument: bool \n  \n . This attribute is used only when PSD-Mads optimization is active. \n  \n . Example: PSD_MADS_ORIGINAL false \n  \n . Default: false\n\n",  "  advanced parallel space mads parallel decomposition subproblem original  "  , "true" , "false" , "true" },
{ "PSD_MADS_SUBPROBLEM_PCT_COVERAGE",  "NOMAD::Double",  "70",  " Percentage of variables that must be covered in subproblems before updating mesh ",  " \n  \n . When using Parallel Space Decomposition (PSD) MADS algorithm,  \n   update (enlarge or refine) the mesh when this percentage of variables is \n   covered by subproblems. \n  \n - A lower value makes for more frequent updates. A larger value makes \n   mesh updates less frequent. \n  \n . Argument: Double between 0 and 100 \n  \n . This attribute is used only when PSD-Mads optimization is active. \n  \n . Example: PSD_MADS_SUBPROBLEM_PCT_COVERAGE 80 \n  \n . Default: 70\n\n",  "  advanced parallel space mads parallel subproblem  "  , "true" , "false" , "true" },
{ "SSD_MADS_OPTIMIZATION",  "bool",  "0",  " SSD-MADS optimization algorithm ",  " \n  \n . Use SSD-MADS algorithm. \n  \n . Argument: bool \n  \n . Description: Sequential Space Decomposition with Mads (no parallelism) \n  \n . This option deactivates any other optimization strategy. \n  \n . Example: SSD_MADS_OPTIMIZATION true \n  \n . Default: 0\n\n",  "  advanced ssd mads sequential decomposition  "  , "true" , "false" , "true" },
{ "SSD_MADS_NB_VAR_IN_SUBPROBLEM",  "size_t",  "2",  " Number of variables in SSD-MADS subproblems ",  " \n  \n . When using Sequential Space Decomposition (SSD) MADS algorithm, select the \n   number of variables in Mads subproblems. \n  \n . Argument: size_t \n  \n . Description: Size of subroblems in SSD-Mads. \n  \n . This attribute is used only when SSD-Mads optimization is active. \n  \n . Example: SSD_MADS_NB_VAR_IN_SUBPROBLEM 3 \n  \n . Default: 2\n\n",  "  advanced ssd mads sequential decomposition subproblem  "  , "true" , "false" , "true" },
{ "SSD_MADS_NB_SUBPROBLEM",  "size_t",  "INF",  " Number of SSD-MADS subproblems ",  " \n  \n . When using Sequential Space Decomposition (SSD) MADS algorithm, select the number of \n   Mads subproblems. By default (INF), the number of subproblems is adjusted to \n   cover all variables. \n  \n . Argument: size_t \n  \n . This attribute is used only when SSD-Mads optimization is active. \n  \n . Example: SSD_MADS_NB_SUBPROBLEM 2 \n  \n . Default: INF\n\n",  "  advanced ssd mads sequential decomposition subproblem  "  , "true" , "false" , "true" },
{ "SSD_MADS_RESET_VAR_PICKUP_SUBPROBLEM",  "bool",  "false",  " Reset random variable pick-up for each subproblem ",  " \n  \n . Argument: bool \n  \n . This attribute is used only when SSD-Mads optimization is active. \n  \n . Example: SSD_MADS_RESET_VAR_PICKUP_SUBPROBLEM true \n  \n . Default: false\n\n",  "  advanced ssd mads sequential decomposition subproblem  "  , "true" , "false" , "true" },
{ "SSD_MADS_ITER_OPPORTUNISTIC",  "bool",  "true",  " Opportunistic strategy between the Mads subproblems in SSD-MADS ",  " \n  \n . When using Sequential Space Decomposition (SSD) MADS algorithm, the sequence \n   of Mads subproblems during an iteration can be opportunistically stopped when \n   a success is obtained by a Mads subproblem. \n  \n . Argument: bool \n  \n . This attribute is used only when SSD-Mads optimization is active. \n  \n . Example: SSD_MADS_OPPORTUNISTIC false \n  \n . Default: true\n\n",  "  advanced sequential space ssd mads decomposition subproblem opportunistic  "  , "true" , "false" , "true" } };

#endif
