import { Construct } from '@aws-cdk/core';
import { NotificationType } from './NotificationType';
import { TimeUnit } from './TimeUnit';
/**
 * Configuration options of the {@link BudgetNotifier | BudgetNotifier}.
 *
 * @stability stable
 */
export interface BudgetNotifierProps {
    /**
     * Budget notifications will be sent to each of the recipients (e-mail addresses).
     *
     * A maximum of 10 recipients is allowed.
     *
     * @stability stable
     */
    readonly recipients?: Array<string>;
    /**
     * @stability stable
     */
    readonly topicArn?: string;
    /**
     * If specified the availability zones will be added as tag filter.
     *
     * @stability stable
     */
    readonly availabilityZones?: Array<string>;
    /**
     * If specified the application name will be added as tag filter.
     *
     * @stability stable
     */
    readonly application?: string;
    /**
     * If specified the cost center will be added as tag filter.
     *
     * @stability stable
     */
    readonly costCenter?: string;
    /**
     * If specified the service will be added as tag filter.
     *
     * @stability stable
     */
    readonly service?: string;
    /**
     * The threshold value in percent (0-100).
     *
     * @stability stable
     */
    readonly threshold: number;
    /**
     * The length of time until a budget resets the actual and forecasted spend.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-timeunit
     * @stability stable
     */
    readonly timeUnit?: TimeUnit;
    /**
     * The cost associated with the budget threshold.
     *
     * @stability stable
     */
    readonly limit: number;
    /**
     * The unit of measurement that is used for the budget threshold, such as dollars or GB.
     *
     * @stability stable
     */
    readonly unit: string;
    /**
     * Whether the notification is for how much you have spent (ACTUAL) or for how much you're forecasted to spend (FORECASTED).
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-notificationtype
     * @stability stable
     */
    readonly notificationType?: NotificationType;
}
/**
 * @stability stable
 */
export declare class BudgetNotifier extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: BudgetNotifierProps);
    private validateProperties;
    private createSubscribers;
    private createCostFilters;
}
