# Python API for Nanosurf controllers

Package for data acquisition and control of Nanosurf atomic force microscopes.

![Nanosurf Python](https://www.nanosurf.com/images/logos/nsf_python.png)

### Prerequisites

* Python >=3.9 installed on Windows OS.
* A Nanosurf controller software running and a controller connected to the PC.
* Nanosurf Scripting Interface option activated

### Installation and upgrading

Assuming that a Python interpreter is already installed on your PC.

To install the package, open a Windows Command Prompt and run:
```
pip install nanosurf
```

To upgrade your nanosurf package to the newest version,
open Windows Command Prompt and run:
```
pip install nanosurf -U
```

If for some reason pip does not work, unzip the content of the package
into a folder and in this folder run:
```
python setup.py install
```

### Get help, where are the examples ?

In the library nanosurf provides documentation, script demos and full fledged application templates to give you a quick start.
But where are these files placed after the installation?

They are in the nanosurf package sub folders "app" and "doc". 
But where are they on your system? Package folders can be at very different places depending on the python installation.

Therefore we installed also script which finds these folders on your system:

Open Windows Command Prompt and type:
```
nanosurf_help
```

If this does not work:
Open Windows Command Prompt and type:
```
python 
>>> import nanosurf
>>> nanosurf.help()
```

Open the examples in Visual Studio Code (or any other python IDE) and run them

### Usage Example
```
import nanosurf

spm = nanosurf.SPM()  # or .C3000() or .CX(), or .CoreAFM()
application = spm.application

scan = application.Scan
opmode = application.OperatingMode
approach = application.Approach
zcontrol = application.ZController
head = application.ScanHead

# Set file mask
mask = "TestSample-"
application.SetGalleryHistoryFilenameMask(mask)

# Choose cantilever
head.CantileverByGUID = spm.CantileverGUID.Dyn190Al

# Operating mode
opmode.OperatingMode = spm.OperatingMode.DynamicAFM
opmode.VibratingAmpl = 0.5 # [V] 

# Set scan parameters
scan.ImageWidth = 5e-6 # [m]
scan.ImageHeight = 5e-6 # [m]
scan.Scantime = 0.55 # s
scan.Points = 256 # points per line
scan.Lines = 256 # lines
scan.CenterPosX = 10e-6 # [m]
scan.CenterPosY = 10e-6 # [m]
scan.SlopeX = 0.0 # degree
scan.SlopeY = 0.0 # degree
scan.Overscan = 5 #%

# Set Z controller parameters
zcontrol.SetPoint = 70 # [%]
zcontrol.PGain = 3100
zcontrol.IGain = 3500

# Start scan
scan.StartFrameUp()

# Check if scanning
scanning = scan.IsScanning
print(scanning)

# Stop scan
scan.Stop()

# Get image
scan.StartCapture()

del spm

```

### Scripting Manual

Full list of objects and methods can be found in the Scripting Manual
in Nanosurf controller software under Help tab:
Help -> Manuals -> Script Programmers Manual, or [here](https://www.nanosurf.com/downloads/programmers-manual.pdf).


### License
[MIT License](https://en.wikipedia.org/wiki/MIT_License)
