/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class ArrayUtils {
    public static double[] nanArray(int len) {
        double[] arr = new double[len];
        for (int i2 = 0; i2 < len; ++i2) {
            arr[i2] = Double.NaN;
        }
        return arr;
    }

    public static double l2norm(double[] x2) {
        return Math.sqrt(ArrayUtils.l2norm2(x2));
    }

    public static double l2norm2(double[] x2) {
        return ArrayUtils.l2norm2(x2, false);
    }

    public static double l2norm2(double[] x2, boolean skipLast) {
        int last = x2.length - (skipLast ? 1 : 0);
        double sum = 0.0;
        for (int i2 = 0; i2 < last; ++i2) {
            sum += x2[i2] * x2[i2];
        }
        return sum;
    }

    public static double[] flat(double[][] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return null;
        }
        int tlen = 0;
        for (double[] t2 : arr) {
            tlen += t2 != null ? t2.length : 0;
        }
        double[] result = Arrays.copyOf(arr[0], tlen);
        int j2 = arr[0].length;
        for (int i2 = 1; i2 < arr.length; ++i2) {
            if (arr[i2] == null) continue;
            System.arraycopy(arr[i2], 0, result, j2, arr[i2].length);
            j2 += arr[i2].length;
        }
        return result;
    }

    public static double[] eleDiff(double[] from) {
        int arryLen = from.length - 1;
        double[] cumsumR = new double[arryLen];
        for (int index = 0; index < arryLen; ++index) {
            cumsumR[index] = from[index + 1] - from[index];
        }
        return cumsumR;
    }

    public static int[] subtract(int[] from, int val) {
        int arryLen = from.length;
        int[] cumsumR = new int[arryLen];
        for (int index = 0; index < arryLen; ++index) {
            cumsumR[index] = from[index] - val;
        }
        return cumsumR;
    }

    public static int[] subtract(int[] from, int[] val) {
        int arryLen = from.length;
        int[] cumsumR = new int[arryLen];
        for (int index = 0; index < arryLen; ++index) {
            cumsumR[index] = from[index] - val[index];
        }
        return cumsumR;
    }

    public static boolean isBoolColumn(String[] domains) {
        if (domains != null) {
            if (domains.length == 2) {
                if (domains[0].equalsIgnoreCase("true") && domains[1].equalsIgnoreCase("false")) {
                    return true;
                }
                if (domains[1].equalsIgnoreCase("true") && domains[0].equalsIgnoreCase("false")) {
                    return true;
                }
            } else if (domains.length == 1 && (domains[0].equalsIgnoreCase("true") || domains[0].equalsIgnoreCase("false"))) {
                return true;
            }
        }
        return false;
    }

    public static int maxIndex(double[] from, Random rand) {
        assert (rand != null);
        int result = 0;
        int maxCount = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (from[i2] > from[result]) {
                result = i2;
                maxCount = 1;
                continue;
            }
            if (from[i2] != from[result] || rand.nextInt(++maxCount) != 0) continue;
            result = i2;
        }
        return result;
    }

    public static int maxIndex(double[] from) {
        int result = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (!(from[i2] > from[result])) continue;
            result = i2;
        }
        return result;
    }

    public static void sort(int[] idxs, double[] values) {
        ArrayUtils.sort(idxs, values, 500);
    }

    public static void sort(int[] idxs, final double[] values, int cutoff) {
        if (idxs.length < cutoff) {
            for (int i2 = 0; i2 < idxs.length; ++i2) {
                for (int j2 = i2; j2 > 0 && values[idxs[j2 - 1]] > values[idxs[j2]]; --j2) {
                    int tmp = idxs[j2];
                    idxs[j2] = idxs[j2 - 1];
                    idxs[j2 - 1] = tmp;
                }
            }
        } else {
            int i3;
            Integer[] d2 = new Integer[idxs.length];
            for (i3 = 0; i3 < idxs.length; ++i3) {
                d2[i3] = idxs[i3];
            }
            Arrays.sort(d2, new Comparator<Integer>(){

                @Override
                public int compare(Integer x2, Integer y2) {
                    return values[x2] < values[y2] ? -1 : (values[x2] > values[y2] ? 1 : 0);
                }
            });
            for (i3 = 0; i3 < idxs.length; ++i3) {
                idxs[i3] = d2[i3];
            }
        }
    }

    public static void sort(int[] idxs, float[] values, int fromIndex, int toIndex, boolean abs, int increasing) {
        ArrayUtils.sort(idxs, values, fromIndex, toIndex, abs, increasing, 500);
    }

    public static void sort(int[] idxs, final float[] values, int fromIndex, int toIndex, final boolean abs, final int increasing, int cutoff) {
        assert (toIndex > fromIndex) : "toIndex must be > fromIndex";
        if (toIndex - fromIndex < cutoff) {
            block0: for (int i2 = fromIndex; i2 < toIndex; ++i2) {
                for (int j2 = i2; j2 > fromIndex; --j2) {
                    float f2 = (abs ? Math.abs(values[idxs[j2 - 1]]) : values[idxs[j2 - 1]]) * (float)increasing;
                    float f3 = abs ? Math.abs(values[idxs[j2]]) : values[idxs[j2]];
                    if (!(f2 > f3 * (float)increasing)) continue block0;
                    int tmp = idxs[j2];
                    idxs[j2] = idxs[j2 - 1];
                    idxs[j2 - 1] = tmp;
                }
            }
        } else {
            int i3;
            Integer[] d2 = new Integer[idxs.length];
            for (i3 = 0; i3 < idxs.length; ++i3) {
                d2[i3] = idxs[i3];
            }
            Arrays.sort(d2, fromIndex, toIndex, new Comparator<Integer>(){

                @Override
                public int compare(Integer x2, Integer y2) {
                    return Float.compare((abs ? Math.abs(values[x2]) : values[x2]) * (float)increasing, (abs ? Math.abs(values[y2]) : values[y2]) * (float)increasing);
                }
            });
            for (i3 = 0; i3 < idxs.length; ++i3) {
                idxs[i3] = d2[i3];
            }
        }
    }

    public static String[] append(String[] a2, String ... b2) {
        if (a2 == null) {
            return b2;
        }
        String[] tmp = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, tmp, a2.length, b2.length);
        return tmp;
    }

    public static String[][] append(String[][] a2, String[] ... b2) {
        if (a2 == null) {
            return b2;
        }
        String[][] tmp = (String[][])Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, tmp, a2.length, b2.length);
        return tmp;
    }

    public static int[] append(int[] a2, int ... b2) {
        if (a2 == null) {
            return b2;
        }
        int[] tmp = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, tmp, a2.length, b2.length);
        return tmp;
    }

    public static double[] signum(double[] array) {
        double[] signArray = new double[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            signArray[i2] = array[i2] > 0.0 ? 1.0 : (array[i2] < 0.0 ? -1.0 : 0.0);
        }
        return signArray;
    }

    public static double[] difference(double[] array) {
        double[] difference = new double[array.length - 1];
        for (int i2 = 0; i2 < array.length - 1; ++i2) {
            difference[i2] = array[i2 + 1] - array[i2];
        }
        return difference;
    }

    public static void multArray(double[] a2, double[][] bT, double[] result) {
        int resultDim = result.length;
        int vectorSize = a2.length;
        Arrays.fill(result, 0.0);
        for (int index = 0; index < resultDim; ++index) {
            for (int innerIndex = 0; innerIndex < vectorSize; ++innerIndex) {
                int n2 = index;
                result[n2] = result[n2] + a2[innerIndex] * bT[index][innerIndex];
            }
        }
    }

    public static int[] range(int start, int end) {
        int[] r2 = new int[end - start + 1];
        for (int i2 = 0; i2 < r2.length; ++i2) {
            r2[i2] = i2 + start;
        }
        return r2;
    }
}

