/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.google.gson.JsonObject;
import hex.genmodel.attributes.ModelJsonReader;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.parameters.KeyValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class VariableImportances
implements Serializable {
    public final String[] _variables;
    public final double[] _importances;

    public VariableImportances(String[] variableNames, double[] relativeImportances) {
        this._variables = variableNames;
        this._importances = relativeImportances;
    }

    protected static VariableImportances extractFromJson(JsonObject modelJson) {
        Table table = ModelJsonReader.readTable(modelJson, "output.variable_importances");
        if (table == null) {
            return null;
        }
        double[] relativeVarimps = new double[table.rows()];
        String[] varNames = new String[table.rows()];
        int varImportanceCol = table.findColumnIndex("Relative Importance");
        int varNameCol = table.findColumnIndex("Variable");
        if (varImportanceCol == -1) {
            return null;
        }
        if (varNameCol == -1) {
            return null;
        }
        for (int i2 = 0; i2 < table.rows(); ++i2) {
            relativeVarimps[i2] = (Double)table.getCell(varImportanceCol, i2);
            varNames[i2] = (String)table.getCell(varNameCol, i2);
        }
        return new VariableImportances(varNames, relativeVarimps);
    }

    public KeyValue[] topN(int n2) {
        if (n2 <= 0 || n2 > this._importances.length) {
            n2 = this._importances.length;
        }
        KeyValue[] sortedImportances = new KeyValue[this._importances.length];
        for (int i2 = 0; i2 < this._importances.length; ++i2) {
            sortedImportances[i2] = new KeyValue(this._variables[i2], this._importances[i2]);
        }
        Arrays.sort(sortedImportances, new Comparator<KeyValue>(){

            @Override
            public int compare(KeyValue o1, KeyValue o2) {
                return o1.getValue() > o2.getValue() ? -1 : 0;
            }
        });
        return Arrays.copyOfRange(sortedImportances, 0, n2);
    }
}

