/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.pca;

import hex.genmodel.MojoModel;

public class PCAMojoModel
extends MojoModel {
    double[][] _eigenvectors_raw;
    public int[] _catOffsets;
    public int[] _permutation;
    public int _ncats;
    public int _nnums;
    public double[] _normSub;
    public double[] _normMul;
    public boolean _use_all_factor_levels;
    public String _pca_method;
    public String _pca_impl;
    public int _k;
    public int _eigenVectorSize;

    public PCAMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        assert (row != null) : "input data row is null";
        double[] tpred = preds == null ? new double[this._k] : preds;
        int numStart = this._catOffsets[this._ncats];
        assert (row.length == this._nnums + this._ncats) : "assert dataset input size does not eqaul to expected size";
        for (int i2 = 0; i2 < this._k; ++i2) {
            tpred[i2] = 0.0;
            for (int j2 = 0; j2 < this._ncats; ++j2) {
                double tmp = row[this._permutation[j2]];
                if (Double.isNaN(tmp)) continue;
                int last_cat = this._catOffsets[j2 + 1] - this._catOffsets[j2] - 1;
                int level = (int)tmp - (this._use_all_factor_levels ? 0 : 1);
                if (level < 0 || level > last_cat) continue;
                int n2 = i2;
                tpred[n2] = tpred[n2] + this._eigenvectors_raw[this._catOffsets[j2] + level][i2];
            }
            int dcol = this._ncats;
            int vcol = numStart;
            for (int j3 = 0; j3 < this._nnums; ++j3) {
                int n3 = i2;
                tpred[n3] = tpred[n3] + (row[this._permutation[dcol]] - this._normSub[j3]) * this._normMul[j3] * this._eigenvectors_raw[vcol][i2];
                ++dcol;
                ++vcol;
            }
        }
        return tpred;
    }

    @Override
    public int getPredsSize() {
        return this._k;
    }

    @Override
    public int nclasses() {
        return this._k;
    }

    @Override
    public String[] getOutputNames() {
        String[] names = new String[this._k];
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = "PC" + (i2 + 1);
        }
        return names;
    }
}

