/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glrm;

import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.MathUtils;
import java.util.Random;

public enum GlrmRegularizer {
    None{

        @Override
        public double regularize(double[] u2) {
            return 0.0;
        }

        @Override
        public double[] rproxgrad(double[] u2, double delta, Random rand) {
            return u2;
        }

        @Override
        public double[] project(double[] u2, Random rand) {
            return u2;
        }
    }
    ,
    Quadratic{

        @Override
        public double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            double ureg = 0.0;
            for (double ui : u2) {
                ureg += ui * ui;
            }
            return ureg;
        }

        @Override
        public double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] v2 = new double[u2.length];
            double f2 = 1.0 / (1.0 + 2.0 * delta);
            for (int i2 = 0; i2 < u2.length; ++i2) {
                v2[i2] = u2[i2] * f2;
            }
            return v2;
        }

        @Override
        public double[] project(double[] u2, Random rand) {
            return u2;
        }
    }
    ,
    L2{

        @Override
        public double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            double ureg = 0.0;
            for (double ui : u2) {
                ureg += ui * ui;
            }
            return Math.sqrt(ureg);
        }

        @Override
        public double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] v2 = new double[u2.length];
            double weight = 1.0 - delta / ArrayUtils.l2norm(u2);
            if (weight < 0.0) {
                return v2;
            }
            for (int i2 = 0; i2 < u2.length; ++i2) {
                v2[i2] = weight * u2[i2];
            }
            return v2;
        }

        @Override
        public double[] project(double[] u2, Random rand) {
            return u2;
        }
    }
    ,
    L1{

        @Override
        public double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            double ureg = 0.0;
            for (double ui : u2) {
                ureg += Math.abs(ui);
            }
            return ureg;
        }

        @Override
        public double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] v2 = new double[u2.length];
            for (int i2 = 0; i2 < u2.length; ++i2) {
                v2[i2] = Math.max(u2[i2] - delta, 0.0) + Math.min(u2[i2] + delta, 0.0);
            }
            return v2;
        }

        @Override
        public double[] project(double[] u2, Random rand) {
            return u2;
        }
    }
    ,
    NonNegative{

        @Override
        public double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            for (double ui : u2) {
                if (!(ui < 0.0)) continue;
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }

        @Override
        public double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] v2 = new double[u2.length];
            for (int i2 = 0; i2 < u2.length; ++i2) {
                v2[i2] = Math.max(u2[i2], 0.0);
            }
            return v2;
        }

        @Override
        public double[] project(double[] u2, Random rand) {
            return u2 == null ? null : this.rproxgrad(u2, 1.0, rand);
        }
    }
    ,
    OneSparse{

        @Override
        public double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            int card = 0;
            for (double ui : u2) {
                if (ui < 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                if (!(ui > 0.0)) continue;
                ++card;
            }
            return card == 1 ? 0.0 : Double.POSITIVE_INFINITY;
        }

        @Override
        public double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] v2 = new double[u2.length];
            int idx = ArrayUtils.maxIndex(u2, rand);
            double d2 = u2[idx] > 0.0 ? u2[idx] : 1.0E-6;
            v2[idx] = d2;
            return v2;
        }

        @Override
        public double[] project(double[] u2, Random rand) {
            return u2 == null ? null : this.rproxgrad(u2, 1.0, rand);
        }
    }
    ,
    UnitOneSparse{

        @Override
        public double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            int ones = 0;
            int zeros = 0;
            for (double ui : u2) {
                if (ui == 1.0) {
                    ++ones;
                    continue;
                }
                if (ui == 0.0) {
                    ++zeros;
                    continue;
                }
                return Double.POSITIVE_INFINITY;
            }
            return ones == 1 && zeros == u2.length - 1 ? 0.0 : Double.POSITIVE_INFINITY;
        }

        @Override
        public double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] v2 = new double[u2.length];
            int idx = ArrayUtils.maxIndex(u2, rand);
            v2[idx] = 1.0;
            return v2;
        }

        @Override
        public double[] project(double[] u2, Random rand) {
            return u2 == null ? null : this.rproxgrad(u2, 1.0, rand);
        }
    }
    ,
    Simplex{

        @Override
        public double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            double sum = 0.0;
            double absum = 0.0;
            for (double ui : u2) {
                if (ui < 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                sum += ui;
                absum += Math.abs(ui);
            }
            return MathUtils.equalsWithinRecSumErr(sum, 1.0, u2.length, absum) ? 0.0 : Double.POSITIVE_INFINITY;
        }

        @Override
        public double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            int n2 = u2.length;
            int[] idxs = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                idxs[i2] = i2;
            }
            ArrayUtils.sort(idxs, u2);
            double[] ucsum = new double[n2];
            ucsum[n2 - 1] = u2[idxs[n2 - 1]];
            for (int i3 = n2 - 2; i3 >= 0; --i3) {
                ucsum[i3] = ucsum[i3 + 1] + u2[idxs[i3]];
            }
            double t2 = (ucsum[0] - 1.0) / (double)n2;
            for (int i4 = n2 - 1; i4 >= 1; --i4) {
                double tmp = (ucsum[i4] - 1.0) / (double)(n2 - i4);
                if (!(tmp >= u2[idxs[i4 - 1]])) continue;
                t2 = tmp;
                break;
            }
            double[] x2 = new double[u2.length];
            for (int i5 = 0; i5 < u2.length; ++i5) {
                x2[i5] = Math.max(u2[i5] - t2, 0.0);
            }
            return x2;
        }

        @Override
        public double[] project(double[] u2, Random rand) {
            double reg = this.regularize(u2);
            if (reg == 0.0) {
                return u2;
            }
            return this.rproxgrad(u2, 1.0, rand);
        }
    };


    public abstract double regularize(double[] var1);

    public final double regularize(double[][] u2) {
        if (u2 == null || this == None) {
            return 0.0;
        }
        double ureg = 0.0;
        for (double[] uarr : u2) {
            if (Double.isInfinite(ureg += this.regularize(uarr))) break;
        }
        return ureg;
    }

    public abstract double[] rproxgrad(double[] var1, double var2, Random var4);

    public abstract double[] project(double[] var1, Random var2);
}

