/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.customconverter;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;

public class ConvertSplitOnWhitespace<T>
extends AbstractBeanField<T> {
    @Override
    protected Object convert(String value) {
        ArrayList<String> l2 = null;
        if (!StringUtils.isEmpty(value)) {
            l2 = new ArrayList<String>(Arrays.asList(value.split("\\s+")));
        }
        return l2;
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        String result = "";
        try {
            if (value != null) {
                List values = (List)value;
                result = StringUtils.join(values, ' ');
            }
        }
        catch (ClassCastException e2) {
            CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(ResourceBundle.getBundle("convertSplitOnWhitespace", this.errorLocale).getString("wrong.type"));
            csve.initCause(e2);
            throw csve;
        }
        return result;
    }
}

