/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OCommonMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import com.google.gson.JsonObject;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all metrics that shared across all algorithms supporting regression.")
@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u001b\t!\u0002JM(SK\u001e\u0014Xm]:j_:lU\r\u001e:jGNT!a\u0001\u0003\u0002\u000f5,GO]5dg*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u0013M\u0004\u0018M]6mS:<'BA\u0005\u000b\u0003\rA'g\u001c\u0006\u0002\u0017\u0005\u0011\u0011-[\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\t\u0001\u0002JM(D_6lwN\\'fiJL7m\u001d\u0005\t'\u0001\u0011)\u0019!C!)\u0005\u0019Q/\u001b3\u0016\u0003U\u0001\"A\u0006\u000f\u000f\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0002\rA\u0013X\rZ3g\u0013\tibD\u0001\u0004TiJLgn\u001a\u0006\u00037aA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0005k&$\u0007\u0005C\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0015\u0002\"a\u0004\u0001\t\u000bM\t\u0003\u0019A\u000b\t\u000b\t\u0002A\u0011A\u0014\u0015\u0003\u0011Bq!\u000b\u0001C\u0002\u0013E!&\u0001\u0002seU\t1\u0006\u0005\u0002-m5\tQF\u0003\u0002/_\u0005)\u0001/\u0019:b[*\u0011Q\u0001\r\u0006\u0003cI\nQa\u001d9be.T!a\r\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0014aA8sO&\u0011q'\f\u0002\f\t>,(\r\\3QCJ\fW\u000e\u0003\u0004:\u0001\u0001\u0006IaK\u0001\u0004eJ\u0002\u0003bB\u001e\u0001\u0005\u0004%\tBK\u0001\u0015[\u0016\fgNU3tS\u0012,\u0018\r\u001c#fm&\fgnY3\t\ru\u0002\u0001\u0015!\u0003,\u0003UiW-\u00198SKNLG-^1m\t\u00164\u0018.\u00198dK\u0002Bqa\u0010\u0001C\u0002\u0013E!&A\u0002nC\u0016Da!\u0011\u0001!\u0002\u0013Y\u0013\u0001B7bK\u0002Bqa\u0011\u0001C\u0002\u0013E!&A\u0003s[NdW\r\u0003\u0004F\u0001\u0001\u0006IaK\u0001\u0007e6\u001cH.\u001a\u0011\t\u000b\u001d\u0003A\u0011\u0001%\u0002\u000b\u001d,GO\u0015\u001a\u0015\u0003%\u0003\"a\u0006&\n\u0005-C\"A\u0002#pk\ndW\rC\u0003N\u0001\u0011\u0005\u0001*A\fhKRlU-\u00198SKNLG-^1m\t\u00164\u0018.\u00198dK\")q\n\u0001C\u0001\u0011\u00061q-\u001a;N\u0003\u0016CQ!\u0015\u0001\u0005\u0002!\u000b\u0001bZ3u%6\u001bF*\u0012\u0005\u0006'\u0002!\t\u0005V\u0001\u000bg\u0016$X*\u001a;sS\u000e\u001cHcA+YIB\u0011qCV\u0005\u0003/b\u0011A!\u00168ji\")\u0011L\u0015a\u00015\u0006!!n]8o!\tY&-D\u0001]\u0015\tif,\u0001\u0003hg>t'BA0a\u0003\u00199wn\\4mK*\t\u0011-A\u0002d_6L!a\u0019/\u0003\u0015)\u001bxN\\(cU\u0016\u001cG\u000fC\u0003f%\u0002\u0007Q#A\u0004d_:$X\r\u001f;\t\u000b\u001d\u0004A\u0011\t5\u0002\t\r|\u0007/\u001f\u000b\u0003S*l\u0011\u0001\u0001\u0005\u0006W\u001a\u0004\r\u0001\\\u0001\u0006Kb$(/\u0019\t\u0003Y5L!A\\\u0017\u0003\u0011A\u000b'/Y7NCBDC\u0001\u00019tiB\u0011q\"]\u0005\u0003e\n\u0011!#T3ue&\u001c7\u000fR3tGJL\u0007\u000f^5p]\u0006YA-Z:de&\u0004H/[8oC\u0005)\u0018A\u0018+iK\u0002\u001aG.Y:tA5\f7.Z:!CZ\f\u0017\u000e\\1cY\u0016\u0004\u0013\r\u001c7![\u0016$(/[2tAQD\u0017\r\u001e\u0011tQ\u0006\u0014X\r\u001a\u0011bGJ|7o\u001d\u0011bY2\u0004\u0013\r\\4pe&$\b.\\:!gV\u0004\bo\u001c:uS:<\u0007E]3he\u0016\u001c8/[8o]\u0001")
public class H2ORegressionMetrics
extends H2OCommonMetrics {
    private final String uid;
    private final DoubleParam r2;
    private final DoubleParam meanResidualDeviance;
    private final DoubleParam mae;
    private final DoubleParam rmsle;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam r2() {
        return this.r2;
    }

    public DoubleParam meanResidualDeviance() {
        return this.meanResidualDeviance;
    }

    public DoubleParam mae() {
        return this.mae;
    }

    public DoubleParam rmsle() {
        return this.rmsle;
    }

    public double getR2() {
        return BoxesRunTime.unboxToDouble(this.$(this.r2()));
    }

    public double getMeanResidualDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.meanResidualDeviance()));
    }

    public double getMAE() {
        return BoxesRunTime.unboxToDouble(this.$(this.mae()));
    }

    public double getRMSLE() {
        return BoxesRunTime.unboxToDouble(this.$(this.rmsle()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMetrics(JsonObject json, String context) {
        Params params;
        Params params2;
        Params params3;
        super.setMetrics(json, context);
        if (json.has("r2")) {
            try {
                params3 = this.set("r2", BoxesRunTime.boxToDouble((double)json.get("r2").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                String string = System.getProperty("spark.testing", "false");
                String string2 = "true";
                if (string == null) {
                    if (string2 == null) throw throwable;
                } else if (string.equals(string2)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'r2' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params3 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'r2' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string3 = "true";
            if (string == null) {
                if (string3 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string3)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            params3 = BoxedUnit.UNIT;
        }
        if (json.has("mean_residual_deviance")) {
            try {
                params2 = this.set("meanResidualDeviance", BoxesRunTime.boxToDouble((double)json.get("mean_residual_deviance").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                if (throwable4 == null) throw throwable;
                Throwable throwable5 = throwable4;
                String string = System.getProperty("spark.testing", "false");
                String string4 = "true";
                if (string == null) {
                    if (string4 == null) throw throwable;
                } else if (string.equals(string4)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'mean_residual_deviance' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable5);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params2 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'mean_residual_deviance' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string5 = "true";
            if (string == null) {
                if (string5 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string5)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            params2 = BoxedUnit.UNIT;
        }
        if (json.has("mae")) {
            try {
                params = this.set("mae", BoxesRunTime.boxToDouble((double)json.get("mae").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable6 = throwable;
                if (throwable6 == null) throw throwable;
                Throwable throwable7 = throwable6;
                String string = System.getProperty("spark.testing", "false");
                String string6 = "true";
                if (string == null) {
                    if (string6 == null) throw throwable;
                } else if (string.equals(string6)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'mae' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable7);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'mae' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (string == null) {
                if (string7 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string7)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            params = BoxedUnit.UNIT;
        }
        if (json.has("rmsle")) {
            try {
                this.set("rmsle", BoxesRunTime.boxToDouble((double)json.get("rmsle").getAsDouble()));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 == null) throw throwable;
                Throwable throwable9 = throwable8;
                String string = System.getProperty("spark.testing", "false");
                String string8 = "true";
                if (string == null) {
                    if (string8 == null) throw throwable;
                } else if (string.equals(string8)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'rmsle' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable9);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'rmsle' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null) {
                if (string9 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string9)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$4;

                public final String apply() {
                    return this.message$4;
                }
                {
                    this.message$4 = message$4;
                }
            });
            return;
        }
    }

    @Override
    public H2ORegressionMetrics copy(ParamMap extra) {
        return (H2ORegressionMetrics)this.defaultCopy(extra);
    }

    public H2ORegressionMetrics(String uid) {
        this.uid = uid;
        this.r2 = this.doubleParam("r2", "The R^2 for this scoring run.");
        this.meanResidualDeviance = this.doubleParam("meanResidualDeviance", "The mean residual deviance for this scoring run.");
        this.mae = this.doubleParam("mae", "The mean absolute error for this scoring run.");
        this.rmsle = this.doubleParam("rmsle", "The root mean squared log error for this scoring run.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.r2().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.meanResidualDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.mae().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.rmsle().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2ORegressionMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2ORegressionMetrics"));
    }
}

