/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OCommonMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import ai.h2o.sparkling.ml.params.NullableDataFrameParam;
import com.google.gson.JsonObject;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all metrics that shared across all algorithms supporting multinomial classification.")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\u0001\u0003\u00015\u0011Q\u0003\u0013\u001aP\u001bVdG/\u001b8p[&\fG.T3ue&\u001c7O\u0003\u0002\u0004\t\u00059Q.\u001a;sS\u000e\u001c(BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005I1\u000f]1sW2Lgn\u001a\u0006\u0003\u0013)\t1\u0001\u001b\u001ap\u0015\u0005Y\u0011AA1j\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!\u0001\u0005%3\u001f\u000e{W.\\8o\u001b\u0016$(/[2t\u0011!\u0019\u0002A!b\u0001\n\u0003\"\u0012aA;jIV\tQ\u0003\u0005\u0002\u001799\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\u00051\u0001K]3eK\u001aL!!\b\u0010\u0003\rM#(/\u001b8h\u0015\tY\u0002\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u0011)\u0018\u000e\u001a\u0011\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!S\u0005\u0005\u0002\u0010\u0001!)1#\ta\u0001+!)!\u0005\u0001C\u0001OQ\tA\u0005C\u0004*\u0001\t\u0007I\u0011\u0003\u0016\u0002\u0005I\u0014T#A\u0016\u0011\u000512T\"A\u0017\u000b\u00059z\u0013!\u00029be\u0006l'BA\u00031\u0015\t\t$'A\u0003ta\u0006\u00148N\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<\u0017BA\u001c.\u0005-!u.\u001e2mKB\u000b'/Y7\t\re\u0002\u0001\u0015!\u0003,\u0003\r\u0011(\u0007\t\u0005\bw\u0001\u0011\r\u0011\"\u0005=\u00035A\u0017\u000e\u001e*bi&|G+\u00192mKV\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002A\t\u00051\u0001/\u0019:b[NL!AQ \u0003-9+H\u000e\\1cY\u0016$\u0015\r^1Ge\u0006lW\rU1sC6Da\u0001\u0012\u0001!\u0002\u0013i\u0014A\u00045jiJ\u000bG/[8UC\ndW\r\t\u0005\b\r\u0002\u0011\r\u0011\"\u0005=\u0003=\u0019wN\u001c4vg&|g.T1ue&D\bB\u0002%\u0001A\u0003%Q(\u0001\td_:4Wo]5p]6\u000bGO]5yA!9!\n\u0001b\u0001\n#Q\u0013a\u00027pO2|7o\u001d\u0005\u0007\u0019\u0002\u0001\u000b\u0011B\u0016\u0002\u00111|w\r\\8tg\u0002BqA\u0014\u0001C\u0002\u0013E!&A\tnK\u0006t\u0007+\u001a:DY\u0006\u001c8/\u0012:s_JDa\u0001\u0015\u0001!\u0002\u0013Y\u0013AE7fC:\u0004VM]\"mCN\u001cXI\u001d:pe\u0002BqA\u0015\u0001C\u0002\u0013E!&A\u0002bk\u000eDa\u0001\u0016\u0001!\u0002\u0013Y\u0013\u0001B1vG\u0002BqA\u0016\u0001C\u0002\u0013E!&A\u0003qe\u0006,8\r\u0003\u0004Y\u0001\u0001\u0006IaK\u0001\u0007aJ\fWo\u0019\u0011\t\u000fi\u0003!\u0019!C\ty\u0005\u0019R.\u001e7uS:|W.[1m\u0003V\u001bE+\u00192mK\"1A\f\u0001Q\u0001\nu\nA#\\;mi&tw.\\5bY\u0006+6\tV1cY\u0016\u0004\u0003b\u00020\u0001\u0005\u0004%\t\u0002P\u0001\u0016[VdG/\u001b8p[&\fG\u000e\u0015*B+\u000e#\u0016M\u00197f\u0011\u0019\u0001\u0007\u0001)A\u0005{\u00051R.\u001e7uS:|W.[1m!J\u000bUk\u0011+bE2,\u0007\u0005C\u0003c\u0001\u0011\u00051-A\u0003hKR\u0014&\u0007F\u0001e!\t9R-\u0003\u0002g1\t1Ai\\;cY\u0016DQ\u0001\u001b\u0001\u0005\u0002%\f\u0001cZ3u\u0011&$(+\u0019;j_R\u000b'\r\\3\u0015\u0003)\u0004\"a[>\u000f\u00051DhBA7w\u001d\tqWO\u0004\u0002pi:\u0011\u0001o]\u0007\u0002c*\u0011!\u000fD\u0001\u0007yI|w\u000e\u001e \n\u0003UJ!a\r\u001b\n\u0005E\u0012\u0014BA<1\u0003\r\u0019\u0018\u000f\\\u0005\u0003sj\fq\u0001]1dW\u0006<WM\u0003\u0002xa%\u0011A0 \u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!!\u001f>\t\u000b}\u0004A\u0011A5\u0002%\u001d,GoQ8oMV\u001c\u0018n\u001c8NCR\u0014\u0018\u000e\u001f\u0005\u0007\u0003\u0007\u0001A\u0011A2\u0002\u0015\u001d,G\u000fT8hY>\u001c8\u000f\u0003\u0004\u0002\b\u0001!\taY\u0001\u0015O\u0016$X*Z1o!\u0016\u00148\t\\1tg\u0016\u0013(o\u001c:\t\r\u0005-\u0001\u0001\"\u0001d\u0003\u00199W\r^!V\u0007\"1\u0011q\u0002\u0001\u0005\u0002\r\f\u0001bZ3u!J\u000bUk\u0011\u0005\u0007\u0003'\u0001A\u0011A5\u0002-\u001d,G/T;mi&tw.\\5bY\u0006+6\tV1cY\u0016Da!a\u0006\u0001\t\u0003I\u0017\u0001G4fi6+H\u000e^5o_6L\u0017\r\u001c)S\u0003V\u001bE+\u00192mK\"9\u00111\u0004\u0001\u0005B\u0005u\u0011AC:fi6+GO]5dgR1\u0011qDA\u0013\u0003{\u00012aFA\u0011\u0013\r\t\u0019\u0003\u0007\u0002\u0005+:LG\u000f\u0003\u0005\u0002(\u0005e\u0001\u0019AA\u0015\u0003\u0011Q7o\u001c8\u0011\t\u0005-\u0012\u0011H\u0007\u0003\u0003[QA!a\f\u00022\u0005!qm]8o\u0015\u0011\t\u0019$!\u000e\u0002\r\u001d|wn\u001a7f\u0015\t\t9$A\u0002d_6LA!a\u000f\u0002.\tQ!j]8o\u001f\nTWm\u0019;\t\u000f\u0005}\u0012\u0011\u0004a\u0001+\u000591m\u001c8uKb$\bbBA\"\u0001\u0011\u0005\u0013QI\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0002H\u0005%S\"\u0001\u0001\t\u0011\u0005-\u0013\u0011\ta\u0001\u0003\u001b\nQ!\u001a=ue\u0006\u00042\u0001LA(\u0013\r\t\t&\f\u0002\t!\u0006\u0014\u0018-\\'ba\":\u0001!!\u0016\u0002\\\u0005u\u0003cA\b\u0002X%\u0019\u0011\u0011\f\u0002\u0003%5+GO]5dg\u0012+7o\u0019:jaRLwN\\\u0001\fI\u0016\u001c8M]5qi&|g.\t\u0002\u0002`\u0005qG\u000b[3!G2\f7o\u001d\u0011nC.,7\u000fI1wC&d\u0017M\u00197fA\u0005dG\u000eI7fiJL7m\u001d\u0011uQ\u0006$\be\u001d5be\u0016$\u0007%Y2s_N\u001c\b%\u00197mA\u0005dwm\u001c:ji\"l7\u000fI:vaB|'\u000f^5oO\u0002jW\u000f\u001c;j]>l\u0017.\u00197!G2\f7o]5gS\u000e\fG/[8o]\u0001")
public class H2OMultinomialMetrics
extends H2OCommonMetrics {
    private final String uid;
    private final DoubleParam r2;
    private final NullableDataFrameParam hitRatioTable;
    private final NullableDataFrameParam confusionMatrix;
    private final DoubleParam logloss;
    private final DoubleParam meanPerClassError;
    private final DoubleParam auc;
    private final DoubleParam prauc;
    private final NullableDataFrameParam multinomialAUCTable;
    private final NullableDataFrameParam multinomialPRAUCTable;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam r2() {
        return this.r2;
    }

    public NullableDataFrameParam hitRatioTable() {
        return this.hitRatioTable;
    }

    public NullableDataFrameParam confusionMatrix() {
        return this.confusionMatrix;
    }

    public DoubleParam logloss() {
        return this.logloss;
    }

    public DoubleParam meanPerClassError() {
        return this.meanPerClassError;
    }

    public DoubleParam auc() {
        return this.auc;
    }

    public DoubleParam prauc() {
        return this.prauc;
    }

    public NullableDataFrameParam multinomialAUCTable() {
        return this.multinomialAUCTable;
    }

    public NullableDataFrameParam multinomialPRAUCTable() {
        return this.multinomialPRAUCTable;
    }

    public double getR2() {
        return BoxesRunTime.unboxToDouble(this.$(this.r2()));
    }

    public Dataset<Row> getHitRatioTable() {
        return this.$(this.hitRatioTable());
    }

    public Dataset<Row> getConfusionMatrix() {
        return this.$(this.confusionMatrix());
    }

    public double getLogloss() {
        return BoxesRunTime.unboxToDouble(this.$(this.logloss()));
    }

    public double getMeanPerClassError() {
        return BoxesRunTime.unboxToDouble(this.$(this.meanPerClassError()));
    }

    public double getAUC() {
        return BoxesRunTime.unboxToDouble(this.$(this.auc()));
    }

    public double getPRAUC() {
        return BoxesRunTime.unboxToDouble(this.$(this.prauc()));
    }

    public Dataset<Row> getMultinomialAUCTable() {
        return this.$(this.multinomialAUCTable());
    }

    public Dataset<Row> getMultinomialPRAUCTable() {
        return this.$(this.multinomialPRAUCTable());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMetrics(JsonObject json, String context) {
        Params params;
        Params params2;
        Params params3;
        Params params4;
        Params params5;
        Params params6;
        Params params7;
        Params params8;
        super.setMetrics(json, context);
        if (json.has("r2")) {
            try {
                params8 = this.set("r2", BoxesRunTime.boxToDouble((double)json.get("r2").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                String string = System.getProperty("spark.testing", "false");
                String string2 = "true";
                if (string == null) {
                    if (string2 == null) throw throwable;
                } else if (string.equals(string2)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'r2' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params8 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'r2' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string3 = "true";
            if (string == null) {
                if (string3 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string3)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            params8 = BoxedUnit.UNIT;
        }
        if (json.has("hit_ratio_table")) {
            try {
                params7 = this.set("hitRatioTable", this.jsonFieldToDataFrame(json, "hit_ratio_table"));
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                if (throwable4 == null) throw throwable;
                Throwable throwable5 = throwable4;
                String string = System.getProperty("spark.testing", "false");
                String string4 = "true";
                if (string == null) {
                    if (string4 == null) throw throwable;
                } else if (string.equals(string4)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'hit_ratio_table' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable5);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params7 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'hit_ratio_table' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string5 = "true";
            if (string == null) {
                if (string5 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string5)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            params7 = BoxedUnit.UNIT;
        }
        if (json.has("cm")) {
            try {
                params6 = this.set("confusionMatrix", this.jsonFieldToDataFrame(json.getAsJsonObject("cm"), "table"));
            }
            catch (Throwable throwable) {
                Throwable throwable6 = throwable;
                if (throwable6 == null) throw throwable;
                Throwable throwable7 = throwable6;
                String string = System.getProperty("spark.testing", "false");
                String string6 = "true";
                if (string == null) {
                    if (string6 == null) throw throwable;
                } else if (string.equals(string6)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'cm' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable7);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params6 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'cm' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (string == null) {
                if (string7 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string7)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            params6 = BoxedUnit.UNIT;
        }
        if (json.has("logloss")) {
            try {
                params5 = this.set("logloss", BoxesRunTime.boxToDouble((double)json.get("logloss").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 == null) throw throwable;
                Throwable throwable9 = throwable8;
                String string = System.getProperty("spark.testing", "false");
                String string8 = "true";
                if (string == null) {
                    if (string8 == null) throw throwable;
                } else if (string.equals(string8)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'logloss' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable9);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params5 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'logloss' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null) {
                if (string9 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string9)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$4;

                public final String apply() {
                    return this.message$4;
                }
                {
                    this.message$4 = message$4;
                }
            });
            params5 = BoxedUnit.UNIT;
        }
        if (json.has("mean_per_class_error")) {
            try {
                params4 = this.set("meanPerClassError", BoxesRunTime.boxToDouble((double)json.get("mean_per_class_error").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable10 = throwable;
                if (throwable10 == null) throw throwable;
                Throwable throwable11 = throwable10;
                String string = System.getProperty("spark.testing", "false");
                String string10 = "true";
                if (string == null) {
                    if (string10 == null) throw throwable;
                } else if (string.equals(string10)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'mean_per_class_error' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable11);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params4 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'mean_per_class_error' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string11 = "true";
            if (string == null) {
                if (string11 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string11)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$5;

                public final String apply() {
                    return this.message$5;
                }
                {
                    this.message$5 = message$5;
                }
            });
            params4 = BoxedUnit.UNIT;
        }
        if (json.has("AUC")) {
            try {
                params3 = this.set("auc", BoxesRunTime.boxToDouble((double)json.get("AUC").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable12 = throwable;
                if (throwable12 == null) throw throwable;
                Throwable throwable13 = throwable12;
                String string = System.getProperty("spark.testing", "false");
                String string12 = "true";
                if (string == null) {
                    if (string12 == null) throw throwable;
                } else if (string.equals(string12)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'AUC' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable13);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params3 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'AUC' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string13 = "true";
            if (string == null) {
                if (string13 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string13)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$6;

                public final String apply() {
                    return this.message$6;
                }
                {
                    this.message$6 = message$6;
                }
            });
            params3 = BoxedUnit.UNIT;
        }
        if (json.has("pr_auc")) {
            try {
                params2 = this.set("prauc", BoxesRunTime.boxToDouble((double)json.get("pr_auc").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable14 = throwable;
                if (throwable14 == null) throw throwable;
                Throwable throwable15 = throwable14;
                String string = System.getProperty("spark.testing", "false");
                String string14 = "true";
                if (string == null) {
                    if (string14 == null) throw throwable;
                } else if (string.equals(string14)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'pr_auc' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable15);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params2 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'pr_auc' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string15 = "true";
            if (string == null) {
                if (string15 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string15)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$7;

                public final String apply() {
                    return this.message$7;
                }
                {
                    this.message$7 = message$7;
                }
            });
            params2 = BoxedUnit.UNIT;
        }
        if (json.has("multinomial_auc_table")) {
            try {
                params = this.set("multinomialAUCTable", this.jsonFieldToDataFrame(json, "multinomial_auc_table"));
            }
            catch (Throwable throwable) {
                Throwable throwable16 = throwable;
                if (throwable16 == null) throw throwable;
                Throwable throwable17 = throwable16;
                String string = System.getProperty("spark.testing", "false");
                String string16 = "true";
                if (string == null) {
                    if (string16 == null) throw throwable;
                } else if (string.equals(string16)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'multinomial_auc_table' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable17);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'multinomial_auc_table' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string17 = "true";
            if (string == null) {
                if (string17 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string17)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$8;

                public final String apply() {
                    return this.message$8;
                }
                {
                    this.message$8 = message$8;
                }
            });
            params = BoxedUnit.UNIT;
        }
        if (json.has("multinomial_aucpr_table")) {
            try {
                this.set("multinomialPRAUCTable", this.jsonFieldToDataFrame(json, "multinomial_aucpr_table"));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable18 = throwable;
                if (throwable18 == null) throw throwable;
                Throwable throwable19 = throwable18;
                String string = System.getProperty("spark.testing", "false");
                String string18 = "true";
                if (string == null) {
                    if (string18 == null) throw throwable;
                } else if (string.equals(string18)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'multinomial_aucpr_table' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable19);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'multinomial_aucpr_table' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string19 = "true";
            if (string == null) {
                if (string19 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string19)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$9;

                public final String apply() {
                    return this.message$9;
                }
                {
                    this.message$9 = message$9;
                }
            });
            return;
        }
    }

    @Override
    public H2OMultinomialMetrics copy(ParamMap extra) {
        return (H2OMultinomialMetrics)this.defaultCopy(extra);
    }

    public H2OMultinomialMetrics(String uid) {
        this.uid = uid;
        this.r2 = this.doubleParam("r2", "The R^2 for this scoring run.");
        this.hitRatioTable = this.nullableDataFrameParam("hitRatioTable", "The hit ratio table for this scoring run.");
        this.confusionMatrix = this.nullableDataFrameParam("confusionMatrix", "The ConfusionMatrix object for this scoring run.");
        this.logloss = this.doubleParam("logloss", "The logarithmic loss for this scoring run.");
        this.meanPerClassError = this.doubleParam("meanPerClassError", "The mean misclassification error per class.");
        this.auc = this.doubleParam("auc", "The average AUC for this scoring run.");
        this.prauc = this.doubleParam("prauc", "The average precision-recall AUC for this scoring run.");
        this.multinomialAUCTable = this.nullableDataFrameParam("multinomialAUCTable", "The multinomial AUC values.");
        this.multinomialPRAUCTable = this.nullableDataFrameParam("multinomialPRAUCTable", "The multinomial PR AUC values.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.r2().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.hitRatioTable().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.confusionMatrix().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.logloss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.meanPerClassError().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.auc().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.prauc().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.multinomialAUCTable().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.multinomialPRAUCTable().$minus$greater(null)}));
    }

    public H2OMultinomialMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OMultinomialMetrics"));
    }
}

