/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import java.lang.reflect.Method;

public class Base64Utils {
    private static final Base64Iface DELEGATE;

    private Base64Utils() {
    }

    public static byte[] encode(byte[] src) {
        return DELEGATE.encode(src);
    }

    public static byte[] decode(byte[] src) {
        return DELEGATE.decode(src);
    }

    public static byte[] encodeUrl(byte[] src) {
        return DELEGATE.encodeUrl(src);
    }

    public static byte[] decodeUrl(byte[] src) {
        return DELEGATE.decodeUrl(src);
    }

    public static byte[] decodeUrl(String src) {
        return !Base64Utils.isEmpty(src) ? DELEGATE.decodeUrl(src.getBytes()) : null;
    }

    static Class<?> tryLoadFirst(String klazzName, ClassLoader ... classLoaders) {
        for (ClassLoader c2 : classLoaders) {
            try {
                return c2.loadClass(klazzName);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    static boolean allNotNull(Object ... objs) {
        for (Object o2 : objs) {
            if (o2 != null) continue;
            return false;
        }
        return true;
    }

    static Object scall(Class<?> klazz, String name) {
        try {
            Method m2 = klazz.getMethod(name, new Class[0]);
            return m2.invoke(null, new Object[0]);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static boolean isEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }

    static {
        Class<?> base64Klazz = Base64Utils.tryLoadFirst("java.util.Base64", Base64Utils.class.getClassLoader());
        Base64Iface delegate = null;
        if (base64Klazz != null) {
            delegate = Base64Java8.create(base64Klazz);
        } else {
            Class<?> datatypeConvertorKlazz = Base64Utils.tryLoadFirst("javax.xml.bind.DatatypeConverter", Base64Utils.class.getClassLoader());
            if (datatypeConvertorKlazz != null) {
                delegate = Base64Java7.create(datatypeConvertorKlazz);
            }
        }
        if (delegate == null) {
            throw new LinkageError("Cannot find suitable implementation for Base64 utilities!");
        }
        DELEGATE = delegate;
    }

    private static class Base64Java7
    implements Base64Iface {
        private final Method encoder;
        private final Method decoder;

        private Base64Java7(Method encoder, Method decoder) {
            this.encoder = encoder;
            this.decoder = decoder;
        }

        @Override
        public byte[] encode(byte[] src) {
            try {
                return ((String)this.encoder.invoke(null, new Object[]{src})).getBytes();
            }
            catch (Exception e2) {
                return null;
            }
        }

        @Override
        public byte[] decode(byte[] src) {
            return this.decode(new String(src));
        }

        @Override
        public byte[] encodeUrl(byte[] src) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public byte[] decodeUrl(byte[] src) {
            return this.decodeUrl(new String(src));
        }

        private byte[] decode(String in) {
            if (in != null) {
                try {
                    return (byte[])this.decoder.invoke(null, in);
                }
                catch (Exception e2) {
                    return null;
                }
            }
            return null;
        }

        private byte[] decodeUrl(String in) {
            if (in != null) {
                String base64 = in.replace('-', '+').replace('_', '/');
                return this.decode(base64);
            }
            return null;
        }

        static Base64Java7 create(Class<?> datatypeConvertorKlazz) {
            Method encoder = Base64Java7.getMethod(datatypeConvertorKlazz, "printBase64Binary", byte[].class);
            Method decoder = Base64Java7.getMethod(datatypeConvertorKlazz, "parseBase64Binary", String.class);
            if (Base64Utils.allNotNull(encoder, decoder)) {
                return new Base64Java7(encoder, decoder);
            }
            return null;
        }

        static Method getMethod(Class<?> klazz, String methodName, Class<?> paramType) {
            try {
                return klazz.getMethod(methodName, paramType);
            }
            catch (NoSuchMethodException e2) {
                return null;
            }
        }
    }

    private static class Base64Java8
    implements Base64Iface {
        private final Object encoder;
        private final Method encoderEncode;
        private final Object encoderUrl;
        private final Method encoderUrlEncode;
        private final Object decoder;
        private final Method decoderDecode;
        private final Object decoderUrl;
        private final Method decoderUrlDecode;

        private Base64Java8(Object encoder, Method encoderEncode, Object encoderUrl, Method encoderUrlEncode, Object decoder, Method decoderDecode, Object decoderUrl, Method decoderUrlDecode) {
            this.encoder = encoder;
            this.encoderEncode = encoderEncode;
            this.encoderUrl = encoderUrl;
            this.encoderUrlEncode = encoderUrlEncode;
            this.decoder = decoder;
            this.decoderDecode = decoderDecode;
            this.decoderUrl = decoderUrl;
            this.decoderUrlDecode = decoderUrlDecode;
        }

        @Override
        public byte[] encode(byte[] src) {
            return this.call(this.encoder, this.encoderEncode, src);
        }

        @Override
        public byte[] decode(byte[] src) {
            return this.call(this.decoder, this.decoderDecode, src);
        }

        @Override
        public byte[] encodeUrl(byte[] src) {
            return this.call(this.encoderUrl, this.encoderUrlEncode, src);
        }

        @Override
        public byte[] decodeUrl(byte[] src) {
            return this.call(this.decoderUrl, this.decoderUrlDecode, src);
        }

        private byte[] call(Object o2, Method m2, byte[] src) {
            try {
                return (byte[])m2.invoke(o2, new Object[]{src});
            }
            catch (Exception e2) {
                return null;
            }
        }

        static Base64Java8 create(Class<?> base64Class) {
            Object encoder = Base64Utils.scall(base64Class, "getEncoder");
            Method encoderEncode = Base64Java8.getMethodBA(encoder, "encode");
            Object encoderUrl = Base64Utils.scall(base64Class, "getUrlEncoder");
            Method encoderUrlEncode = Base64Java8.getMethodBA(encoderUrl, "encode");
            Object decoder = Base64Utils.scall(base64Class, "getDecoder");
            Method decoderDecode = Base64Java8.getMethodBA(decoder, "decode");
            Object decoderUrl = Base64Utils.scall(base64Class, "getUrlDecoder");
            Method decoderUrlDecode = Base64Java8.getMethodBA(decoderUrl, "decode");
            if (Base64Utils.allNotNull(encoder, encoderEncode, encoderUrl, encoderUrlEncode, decoder, decoderDecode, decoderUrl, decoderUrlDecode)) {
                return new Base64Java8(encoder, encoderEncode, encoderUrl, encoderUrlEncode, decoder, decoderDecode, decoderUrl, decoderUrlDecode);
            }
            return null;
        }

        private static Method getMethodBA(Object o2, String name) {
            try {
                return o2.getClass().getMethod(name, byte[].class);
            }
            catch (NoSuchMethodException e2) {
                return null;
            }
        }
    }

    private static interface Base64Iface {
        public byte[] encode(byte[] var1);

        public byte[] decode(byte[] var1);

        public byte[] encodeUrl(byte[] var1);

        public byte[] decodeUrl(byte[] var1);
    }
}

