/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.AbstractProtobufList;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class FloatArrayList
extends AbstractProtobufList<Float>
implements Internal.FloatList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final FloatArrayList EMPTY_LIST = new FloatArrayList(new float[0], 0);
    private float[] array;
    private int size;

    public static FloatArrayList emptyList() {
        return EMPTY_LIST;
    }

    FloatArrayList() {
        this(new float[10], 0);
    }

    private FloatArrayList(float[] other, int size) {
        this.array = other;
        this.size = size;
    }

    @Override
    protected final void removeRange(int fromIndex, int toIndex) {
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= toIndex - fromIndex;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof FloatArrayList)) {
            return super.equals(o2);
        }
        FloatArrayList floatArrayList = (FloatArrayList)o2;
        if (this.size != floatArrayList.size) {
            return false;
        }
        float[] fArray = floatArrayList.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (Float.floatToIntBits(this.array[i2]) == Float.floatToIntBits(fArray[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            n2 = n2 * 31 + Float.floatToIntBits(this.array[i2]);
        }
        return n2;
    }

    @Override
    public final Internal.FloatList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new FloatArrayList(Arrays.copyOf(this.array, capacity), this.size);
    }

    @Override
    public final Float get(int index) {
        return Float.valueOf(this.getFloat(index));
    }

    @Override
    public final float getFloat(int index) {
        this.ensureIndexInRange(index);
        return this.array[index];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Float set(int index, Float element) {
        return Float.valueOf(this.setFloat(index, element.floatValue()));
    }

    @Override
    public final float setFloat(int index, float element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        float f2 = this.array[index];
        this.array[index] = element;
        return f2;
    }

    @Override
    public final void add(int index, Float element) {
        this.addFloat(index, element.floatValue());
    }

    @Override
    public final void addFloat(float element) {
        FloatArrayList floatArrayList = this;
        floatArrayList.addFloat(floatArrayList.size, element);
    }

    private void addFloat(int index, float element) {
        this.ensureIsMutable();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        } else {
            int n2 = this.size * 3 / 2 + 1;
            float[] fArray = new float[n2];
            System.arraycopy(this.array, 0, fArray, 0, index);
            System.arraycopy(this.array, index, fArray, index + 1, this.size - index);
            this.array = fArray;
        }
        this.array[index] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof FloatArrayList)) {
            return super.addAll(collection);
        }
        FloatArrayList floatArrayList = (FloatArrayList)collection;
        if (floatArrayList.size == 0) {
            return false;
        }
        int n2 = Integer.MAX_VALUE - this.size;
        if (n2 < floatArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n3 = this.size + floatArrayList.size;
        if (n3 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n3);
        }
        System.arraycopy(floatArrayList.array, 0, this.array, this.size, floatArrayList.size);
        this.size = n3;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object o2) {
        this.ensureIsMutable();
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!o2.equals(Float.valueOf(this.array[i2]))) continue;
            System.arraycopy(this.array, i2 + 1, this.array, i2, this.size - i2 - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public final Float remove(int index) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        float f2 = this.array[index];
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        ++this.modCount;
        return Float.valueOf(f2);
    }

    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index) {
        return "Index:" + index + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

