/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.AbstractProtobufList;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class DoubleArrayList
extends AbstractProtobufList<Double>
implements Internal.DoubleList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final DoubleArrayList EMPTY_LIST = new DoubleArrayList(new double[0], 0);
    private double[] array;
    private int size;

    public static DoubleArrayList emptyList() {
        return EMPTY_LIST;
    }

    DoubleArrayList() {
        this(new double[10], 0);
    }

    private DoubleArrayList(double[] other, int size) {
        this.array = other;
        this.size = size;
    }

    @Override
    protected final void removeRange(int fromIndex, int toIndex) {
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= toIndex - fromIndex;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof DoubleArrayList)) {
            return super.equals(o2);
        }
        DoubleArrayList doubleArrayList = (DoubleArrayList)o2;
        if (this.size != doubleArrayList.size) {
            return false;
        }
        double[] dArray = doubleArrayList.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (Double.doubleToLongBits(this.array[i2]) == Double.doubleToLongBits(dArray[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            long l2 = Double.doubleToLongBits(this.array[i2]);
            n2 = n2 * 31 + Internal.hashLong(l2);
        }
        return n2;
    }

    @Override
    public final Internal.DoubleList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new DoubleArrayList(Arrays.copyOf(this.array, capacity), this.size);
    }

    @Override
    public final Double get(int index) {
        return this.getDouble(index);
    }

    @Override
    public final double getDouble(int index) {
        this.ensureIndexInRange(index);
        return this.array[index];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Double set(int index, Double element) {
        return this.setDouble(index, element);
    }

    @Override
    public final double setDouble(int index, double element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        double d2 = this.array[index];
        this.array[index] = element;
        return d2;
    }

    @Override
    public final void add(int index, Double element) {
        this.addDouble(index, element);
    }

    @Override
    public final void addDouble(double element) {
        DoubleArrayList doubleArrayList = this;
        doubleArrayList.addDouble(doubleArrayList.size, element);
    }

    private void addDouble(int index, double element) {
        this.ensureIsMutable();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        } else {
            int n2 = this.size * 3 / 2 + 1;
            double[] dArray = new double[n2];
            System.arraycopy(this.array, 0, dArray, 0, index);
            System.arraycopy(this.array, index, dArray, index + 1, this.size - index);
            this.array = dArray;
        }
        this.array[index] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof DoubleArrayList)) {
            return super.addAll(collection);
        }
        DoubleArrayList doubleArrayList = (DoubleArrayList)collection;
        if (doubleArrayList.size == 0) {
            return false;
        }
        int n2 = Integer.MAX_VALUE - this.size;
        if (n2 < doubleArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n3 = this.size + doubleArrayList.size;
        if (n3 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n3);
        }
        System.arraycopy(doubleArrayList.array, 0, this.array, this.size, doubleArrayList.size);
        this.size = n3;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object o2) {
        this.ensureIsMutable();
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!o2.equals(this.array[i2])) continue;
            System.arraycopy(this.array, i2 + 1, this.array, i2, this.size - i2 - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public final Double remove(int index) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        double d2 = this.array[index];
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        ++this.modCount;
        return d2;
    }

    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index) {
        return "Index:" + index + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

