# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['catimage']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=7.2.0,<8.0.0']

extras_require = \
{'full': ['metprint>=2020.7.0,<2021.0.0', 'cli2gui>=2020.8.1,<2021.0.0']}

entry_points = \
{'console_scripts': ['catimage = catimage.catimage:cli']}

setup_kwargs = {
    'name': 'catimage',
    'version': '2020.6.0',
    'description': 'Use to cat an image to the terminal',
    'long_description': '[![Github top language](https://img.shields.io/github/languages/top/FHPythonUtils/CatImage.svg?style=for-the-badge)](../../)\n[![Codacy grade](https://img.shields.io/codacy/grade/6b3bd2d2569f44dca74a391e905042ac.svg?style=for-the-badge)](https://www.codacy.com/gh/FHPythonUtils/CatImage)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/CatImage.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/CatImage.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/CatImage.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/CatImage.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/CatImage.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/catimage.svg?style=for-the-badge)](https://pypi.org/project/catimage/)\n[![PyPI Version](https://img.shields.io/pypi/v/catimage.svg?style=for-the-badge)](https://pypi.org/project/catimage/)\n\n<!-- omit in toc -->\n# CatImage\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nCat an image to the terminal.\n\n- [Install Single Script](#install-single-script)\n\t- [Wget](#wget)\n\t- [Curl](#curl)\n- [Install With PIP](#install-with-pip)\n- [Example](#example)\n- [How To Use](#how-to-use)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [How to update, build and publish](#how-to-update-build-and-publish)\n- [Download](#download-1)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [License](#license)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n- [Screenshots](#screenshots)\n\t- [Desktop](#desktop)\n\n## Install Single Script\n### Wget\n```bash\nwget -O /usr/bin/catimage https://raw.githubusercontent.com/FHPythonUtils/CatImage/master/catimage.py && sudo chmod 774 /usr/bin/catimage\n```\n### Curl\n```bash\ncurl -o /usr/bin/catimage https://raw.githubusercontent.com/FHPythonUtils/CatImage/master/catimage.py && sudo chmod 774 /usr/bin/catimage\n```\n\n## Install With PIP\n\n```python\npip install catimage\n```\n\nHead to https://pypi.org/project/catimage/ for more info\n\n\n## Example\nOriginal Image:\n\n<img src="readme-assets/screenshots/desktop/example-0.png" alt="Screenshot 1" width="600">\n\nGreyscale Image:\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png -g\n```\n\n<img src="readme-assets/screenshots/desktop/example-1.png" alt="Screenshot 2" width="600">\n\nRegular Definition Image:\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png -r -t\n```\n\n<img src="readme-assets/screenshots/desktop/example-2.png" alt="Screenshot 3" width="600">\n\nRegular Definition Image with \'@\':\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png -r -c @ -t\n```\n\n<img src="readme-assets/screenshots/desktop/example-3.png" alt="Screenshot 4" width="600">\n\nHD Image:\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png -t\n```\n\n<img src="readme-assets/screenshots/desktop/example-4.png" alt="Screenshot 5" width="600">\n\nHD Image with right half block:\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png -c $\'\\u2590\' -t\n```\n\n<img src="readme-assets/screenshots/desktop/example-5.png" alt="Screenshot 6" width="600">\n\nHD Image True Colour:\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png\n```\n\n<img src="readme-assets/screenshots/desktop/example-6.png" alt="Screenshot 7" width="600">\n\n## How To Use\nUse to cat an image to the terminal, see the help text below for more\ninformation on using this tool from the command line:\n```bash\nusage: catimage [-h] [-u] [-b] [-c CHAR] [-t] [-g | -r] image\n\ncat an image to the terminal\n\npositional arguments:\n  image                 image file or url\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -u, --url             image is a URL\n  -b, --big             big image\n  -c CHAR, --char CHAR  char to use in colour print use $\'chr\' for escaped chars\n  -t, --disable-truecolour\n                        disable output in truecolour\n\nchoose one of the following:\n  use the following arguments to change the look of the image\n\n  -g, --greyscale       output image in greyscale (best for terminals that cannot handle ANSI)\n  -r, --regular         output image in regular definition\n```\n\nGUI\n\nUse the --cli2gui flag to launch a GUI\n\n<div>\n<img src="readme-assets/screenshots/desktop/gui-0.png" alt="GUI 1" width="600">\n<img src="readme-assets/screenshots/desktop/gui-1.png" alt="GUI 2" width="600">\n</div>\n\nAlternatively, import into your project and use:\n\n```python\ndef generateHDColour(imageName, maxLen, trueColour=True, char="\\u2584"):\n\t"""Iterate through image pixels to make a printable string\n\n\tArgs:\n\t\timageName (str): path of the image on the filesystem (relative of\n\t\tabsolute)\n\t\tmaxLen (int): maximum of width and height in chars\n\t\ttrueColour (bool, optional): print in true colour. Defaults to True.\n\t\tchar (str, optional): use this char for each pixel. Defaults to "\\u2584".\n\n\tReturns:\n\t\tstr: string to print\n\t"""\n\ndef generateColour(imageName, maxLen, trueColour=True, char="\\u2588"):\n\t"""Iterate through all of the pixels in an image and construct a printable\n\tstring\n\n\tArgs:\n\t\timageName (str): path of the image on the filesystem (relative of\n\t\tabsolute)\n\t\tmaxLen (int): maximum of width and height in chars\n\t\ttrueColour (bool, optional): print in true colour. Defaults to True.\n\t\tchar (str, optional): use this char for each pixel. Defaults to "\\u2588".\n\n\tReturns:\n\t\tstr: string to print\n\t"""\n\ndef generateGreyscale(imageName, maxLen):\n\t"""Iterate through image pixels to make a printable string\n\n\tArgs:\n\t\timageName (str): path of the image on the filesystem (relative of\n\t\tabsolute)\n\t\tmaxLen (int): maximum of width and height in chars\n\n\tReturns:\n\t\tstr: string to print\n\t"""\n```\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.8.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.8\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.8 interpreter is selected (Ctrl+Shift+P > Python:Select Interpreter > Python 3.8)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n## How to update, build and publish\n\n1. Ensure you have installed the following dependencies\n\tLinux\n\t```bash\n\twget dephell.org/install | python3.8\n\twget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python3.8\n\t```\n\tWindows\n\t```powershell\n\t(wget dephell.org/install -UseBasicParsing).Content | python\n\t(wget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py -UseBasicParsing).Content | python\n\t```\n2. Use poetry for the heavy lifting and dephell to generate requirements\n\t```bash\n\tpoetry update\n\tdephell deps convert\n\t```\n3. Build/ Publish\n\t```bash\n\tpoetry build\n\tpoetry publish\n\t```\n\tor\n\t```bash\n\tpoetry publish --build\n\t```\n\n\n## Download\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\n$ git clone https://github.com/FHPythonUtils/CatImage\n```\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n\n## Community Files\n### License\nMIT License\nCopyright (c) FredHappyface\n(See the [License](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nIn the interest of fostering an open and welcoming environment, we\nas contributors and maintainers pledge to make participation in our\nproject and our community a harassment-free experience for everyone.\nPlease see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md) for more information.\n\n### Contributing\nContributions are welcome, please see the [Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md) for more information.\n\n### Security\nThank you for improving the security of the project, please see the [Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md) for more information.\n\n\n## Screenshots\n\n### Desktop\n<div>\n<img src="readme-assets/screenshots/desktop/screenshot-0.png" alt="Screenshot 1" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-1.png" alt="Screenshot 2" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-2.png" alt="Screenshot 3" width="600">\n</div>\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FredHappyface/Python.CatImage',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
