YARP 3.0.1 (2018-07-25)                                                {#v3_0_1}
=======================

[TOC]

YARP 3.0.1 Release Notes
========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v3.0.1%22).


Important Changes
-----------------

* Optional dependency on YCM now requires version 0.9.0 or later.
* The `idl_tools` component is now required in order to use `yarp_idl_to_dir`
  and `yarp_add_idl`.

#### YARP_rosmsg

* Removed all `getTypeText()` and `typeText()` methods, replaced by
  `static constexpr const char* typeText` variable.

New Features
------------

* Python and ruby bindings tests are now integrated with ctest

### Libraries

#### YARP_rosmsg

* Added `static constexpr const char* typeName`,
  `static constexpr const char* typeChecksum` and
  `static constexpr const char* typeText` variables to all generated
  classes.


### Tools

#### `yarprobotinterface`

* Added parser for yarprobotinterface .xml format 3.0


Bug Fixes
---------

### Build System

* Fixed issue with vtk config files when looking for the `pcl` component.
* Fixed java bindings.
* Fixed static builds.
* Added components for private libraries (needed for static builds)
* Added components for yarpcar and yarpmod.
* When using YARP_MODULE_PATH a deprecation warning is printed (YCM should
  be used instead).
* Deprecation warnings when calling `find_package(YARP)` more than once are no
  longer printed.
* Fix configuration when `YARP_COMPILE_CARRIER_PLUGINS` and
  `YARP_COMPILE_DEVICE_PLUGINS` is set to OFF.
* When using `FeatureSummary`, `find_package(YARP)` adds the `DESCRIPTION` and
  `URL` properties.
* When using `FeatureSummary`, `find_package(YARP)` no longer adds `YCM` to the
  optional dependencies.
* Fixed behavior of `OPTIONAL_COMPONENTS` in `find_package(YARP)` calls when
  the `REQUIRED` option was passed on. Now, a YARP bundle will be considered
  not found if any of such components is missing.
* Plugins not enabled due to missing dependencies are now shown in `ccmake` and
  `cmake-gui` together with a list of dependencies that are not satisfied.
* Removed the NO_RECURSE argument to `yarp_idl_to_dir` and `yarp_add_idl`.


### Libraries

#### YARP_OS

* Fixed SharedLibraryClass::getContent(). Now a const and a non const version
  are available.
* Fixed SharedLibraryClassFactory::destroy(). Now it is const like create().
* Added initialization of `MultiNameSpace` in `Network::initMinimum`.

#### YARP_dev

* Fixed getCurrent/getCurrents. Now the `stateExt` port is used, and the methods
  are called through the `iCurrentControl` interface.
* Fixed deprecation message placement for the constructor of
  `IJoypadEventDriven`. It was failing enabling c++14 compiling with gcc(#1747).
* Fixed ImplementCurrentControl::getCurrentRanges(double*min, double *max):
  where conversion from Sensor to Ampere was missing.
* Fixed ImplementCurrentControl::getCurrentRanges(j, double *min, double *max):
  where conversion from Sensor to Ampere was missing.
* Fixed ImplementPositionControl::checkMotionDone(bool *flag) where axes
  conversion was missing.

#### YARP_math

* Fixed a regression in the build system that prevented YARP from being
  compiled if Eigen3 was available.

#### YARP_pcl

* Fixed missing isDense parmeter.

#### YARP_sig

* Fixed negative vocab(#1749).

#### YARP_rosmsg

* Fixed `message_definition` property for all classes.


### Tools

#### yarpidl_rosmsg

* Removed the --no-recurse option.
* The `message_definition` property is now properly generated.


### GUIs

#### yarpscope

* Fixed double free during the closure. It has been introduced by #1685
  (commit 02abf63).


### Devices

#### rplidar2

* Fixed compilation (#1689).

#### realsense2

* Fixed deadlock on macOS(see IntelRealSense/librealsense:#1855). Actually to
  fix it also are needed these changes IntelRealSense/librealsense:#2022.

#### multipleanalogsensorsremapper

* Fixed sensors name remapping in MultipleAnalogSensorsRemapper class.

#### batteryClient

* Fixed plugin name.

#### batteryWrapper

* Fixed plugin name.


Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v3.0.0..v3.0.1`):


```
    93	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
    28	Nicolò Genesio <nicolo.genesio@iit.it>
    24	Damiano Enerli <damiano.enerli@iit.it>
     5	Marco Randazzo <marco.randazzo@iit.it>
     3	Valentina Gaggero <valentina.gaggero@iit.it>
     2	Bartek Łukawski <bwmn.peter@gmail.com>
     2	Lorenzo Rapetti <lorenzo.rapetti@iit.it>
     2	Ugo Pattacini <ugo.pattacini@iit.it>
     1	Alberto Cardellino <alberto.cardellino@iit.it>
     1	Claudio Fantacci <claudio.fantacci@iit.it>
     1	Matteo Brunettini <matteo.brunettini@iit.it>
     1	Mohamed Babiker Mohamed Elobaid <mohamed.elobaid@iit.it>
     1	Nuno Guedelha <nuno.guedelha@iit.it>
```
