from sklearn.ensemble import RandomForestClassifier, AdaBoostClassifier, GradientBoostingClassifier, ExtraTreesClassifier
from sklearn.metrics import accuracy_score
from sklearn.model_selection import train_test_split
from sklearn import datasets, metrics, neighbors,  linear_model, svm
from sklearn.tree import DecisionTreeClassifier
from sklearn.naive_bayes import GaussianNB, MultinomialNB, BernoulliNB

def new_func():
    models = [
    ["SVM", lambda nu: linear_model.SGDOneClassSVM(nu=nu), [
         [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
         [True, False],
         [100, 200, 300, 400, 500, 600, 700, 800, 900, 1000],
         [0.001, 0.01, 0.1, 1, 10, 100, 1000],
         [True, False],
         [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
         [None, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
         ["constant", "optimal", "invscaling", "adaptive"],
         [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
         [True, False],
         [False, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    ]],
    ["logistic Regression", lambda penalty:  linear_model.LogisticRegression(penalty=penalty, max_iter=10000), [
        ['l2',  'none'],
        [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [True, False],
        [0.001, 0.01, 0.1, 1, 10, 100, 1000],
        [True, False],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        ["balanced", "balanced_subsample", ],
        [None, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        ["newton-cg", "lbfgs", "liblinear", "sag", "saga"],
        [100, 200, 300, 400, 500, 600, 700, 800, 900, 1000],
        ["ovr", "multinomial"],
        [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [True, False],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
    ]],
    ["Random Forest", lambda n_estimators: RandomForestClassifier(n_estimators=n_estimators), [
        [10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        ["gini", "entropy"],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [2, 3, 4, 5, 6, 7, 8, 9, 10],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        ["auto", "sqrt", "log2"],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [True, False],
        [True, False],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [None, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [True, False],
        ["balanced", "balanced_subsample", ],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [0.5, 0.6, 0.7, 0.8, 0.9, 1.0],
    ]],
    ["Gaussian Naive Bayes", lambda var_smoothing:  GaussianNB(var_smoothing=var_smoothing),
     [
         [1e-09, 1e-08, 1e-07, 1e-06, 1e-05, 1e-04, 1e-03, 1e-02, 1e-01, 1.0],
         [None, [0.5, 0.5], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [
             0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5]],
    ]
    ],
    ["KNN", lambda n_neighbors:  neighbors.KNeighborsClassifier(n_neighbors=n_neighbors), [
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        ["uniform", "distance"],
        ["auto", "ball_tree", "kd_tree", "brute"],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        ["euclidean", "minkowski", "manhattan", "chebyshev",
         "mahalanobis", "seuclidean", "wminkowski", "mahalanobis"],
        [None, {"p": 1, "V": None}, {"p": 2, "V": None}, {"p": 3, "V": None}, {"p": 1, "V": None}, {"V": None}, {
            "p": 1, "V": None}, {"p": 1, "V": None}, {"p": 1, "V": None}, {"p": 1, "V": None}, {"p": 1, "V": None}],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    ], ],
    ["Decision Tree", lambda criterion:  DecisionTreeClassifier(criterion=criterion), [
        ["gini", "entropy"],
        ["best", "random"],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [2, 3, 4, 5, 6, 7, 8, 9, 10],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        ["auto", "sqrt", "log2"],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [None, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        ["balanced", "balanced_subsample", ],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
    ]],
    # this doesn't work
    ["Multinomial Naive Bayes", lambda alpha: MultinomialNB(alpha=alpha), [
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [True, False],
        [None, [0.5, 0.5], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [
            0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5]],
    ]],
    ["Bernoulli Naive Bayes", lambda alpha:  BernoulliNB(alpha=alpha),  [
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [True, False],
        [None, [0.5, 0.5], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [
            0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5], [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5]],
    ]],
    ["AdaBoost", lambda base_estimator: AdaBoostClassifier(base_estimator=base_estimator,),
     [
         [None, DecisionTreeClassifier(), GaussianNB(),
          #   MultinomialNB(),
          BernoulliNB()],
         [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
         [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
         ["SAMME", "SAMME.R"],
         [None, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    ], ],
    ["Gradient Boosting", lambda learning_rate: GradientBoostingClassifier(learning_rate=learning_rate), [
        [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        ["deviance", "exponential"],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [0.5, 0.6, 0.7, 0.8, 0.9, 1],
        ["friedman_mse", "mse", "mae"],
        [2, 3, 4, 5, 6, 7, 8, 9, 10],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [None, "zero"],
        [None, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        ["auto", "sqrt", "log2"],
        [0, 1],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [True, False],
        [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [0.0001, 0.001, 0.01, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
    ]],
    ["Extra Trees", lambda n_estimators: ExtraTreesClassifier(n_estimators=n_estimators), [
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        ["gini", "entropy"],
        ["auto", "sqrt", "log2"],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [2, 3, 4, 5, 6, 7, 8, 9, 10],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [None, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
        [True, False],
        [True, False],
        [-1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [None, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        [0, 1],
        [True, False],
        [None, "balanced"],
        [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1],
        [0.5, 0.6, 0.7, 0.8, 0.9, 1],
    ]],
]
    
    return models
