import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Service Account as defined in Confluent Cloud IAM v2 API.
 *
 * @schema CfnServiceAccountProps
 */
export interface CfnServiceAccountProps {
    /**
     * The description associated with the Service Account
     *
     * @schema CfnServiceAccountProps#Description
     */
    readonly description?: string;
    /**
     * @schema CfnServiceAccountProps#Name
     */
    readonly name: string;
    /**
     * @schema CfnServiceAccountProps#ConfluentCloudCredentials
     */
    readonly confluentCloudCredentials: ConfluentCloudApiSecrets;
}
/**
 * Converts an object of type 'CfnServiceAccountProps' to JSON representation.
 */
export declare function toJson_CfnServiceAccountProps(obj: CfnServiceAccountProps | undefined): Record<string, any> | undefined;
/**
 * @schema ConfluentCloudAPISecrets
 */
export interface ConfluentCloudApiSecrets {
    /**
     * Confluent Cloud API Key
     *
     * @schema ConfluentCloudAPISecrets#ApiKey
     */
    readonly apiKey?: string;
    /**
     * Confluent Cloud API Secret
     *
     * @schema ConfluentCloudAPISecrets#ApiSecret
     */
    readonly apiSecret?: string;
}
/**
 * Converts an object of type 'ConfluentCloudApiSecrets' to JSON representation.
 */
export declare function toJson_ConfluentCloudApiSecrets(obj: ConfluentCloudApiSecrets | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `ConfluentCloud::IAM::ServiceAccount`
 *
 * @cloudformationResource ConfluentCloud::IAM::ServiceAccount
 * @stability external
 * @link https://github.com/JohnPreston/aws-cfn-confluentcloud-iam-serviceaccount
 */
export declare class CfnServiceAccount extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "ConfluentCloud::IAM::ServiceAccount";
    /**
     * Resource props.
     */
    readonly props: CfnServiceAccountProps;
    /**
     * Attribute `ConfluentCloud::IAM::ServiceAccount.ServiceAccountId`
     * @link https://github.com/JohnPreston/aws-cfn-confluentcloud-iam-serviceaccount
     */
    readonly attrServiceAccountId: string;
    /**
     * Create a new `ConfluentCloud::IAM::ServiceAccount`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnServiceAccountProps);
}
