
# テクプラWSI システム仕様書

## 1. プロジェクト概要

### 背景と目的

株式会社テクノプラズムは病理診断施設向けの「テクプラ病理診断」（pathology.technoplasm.jp）というクラウド病理診断管理システムを開発提供している。バックエンドは api.technoplasm.jp 。このバックエンドアは依頼発行用（ portal.tehcnoplas.jp ）や管理用（ admin.tehcnoplas.jp ）が共有しており、  api.technoplasm.jp 以下は
- `/pathology/v0/*`
- `/pathology/grapghql`
- `/portal/v0/*`
- `/portal/grapghql`
のように区切られ、DBは同じだが異なる認証機構を持っている。

本プロジェクトでは、WSI（Whole Slide Image）を管理し、ウェブで閲覧できる「テクプラWSI」を構築する。これは wsi.pathology.jp のウェブ管理画面と、 VPNを使ったファイル共有の2システムから成る。

**目指すビジョン:** 診断には顕微鏡を見る必要があるが、WSIをブラウザやVPN経由の共有フォルダなどで見られるようにすることで、遠隔病理診断の新時代を創る。

### ビジネス的側面

- クラウドWSIデポジットシステム
- セキュアなサーバーにVPN経由でアップロード
- どこでもWSI閲覧可能

### 基本仕様

- 認証はユーザーごとに行う
- ユーザーはセンター（病理診断施設）に所属し、複数所属も可能

---

## 2. システム構成

### 2.1 全体アーキテクチャ

システムは2つの軸で成り立つ:

#### (1) VPNを使ったファイル共有システム

- 利用者はWSIデータをVPN（Headscale）で株式会社テクノプラズムの管理するネットワークに接続
- 対応するデータストレージ（NASのフォルダ）はSAMBAになっており、WSIをアップロードや閲覧ができる
- アップロード先などのフォルダ指定は事前にWebから設定

#### (2) WSIウェブシステム（wsi.technoplasm.jp）

- ブラウザでWSIを見ることのできるシステム
- SAMBAのパーミッション（パスワードリセット・変更）なども管理する
- WSI
- アップロードされたWSIを選択し、パッチ分割してR2にアップロードしブラウザで見られるようにする
- AI処理などの実行の可否、AI結果の閲覧などを可能にする
- WSIシステムはステートレス基本を基本として、DBを持たない
- 認証やデータは逐次既存のpathologyシステムのAPIに問い合わせる
- wsi.technoplasm.jp はさらに独自のバックエンドを持つ？
- api.wsi.technoplasm.jp ？
- これはほぼステートレスで、 DB を持たない（ api.technoplasm.jp をさらに呼ぶ ）が、社内サーバーと同じネットワークに置く
- Cloudflare tunnelで公開する
- データストレージへのアクセスは LAN経由のNFS？ SAMBA もこの NFSに対して張る？


### 2.3 技術的特徴

**VPN技術（Headscale）:**

- VPNはHeadscale（サーバーは回線の速いどこかに設置、NTT網を活用？）
- Tailscaleは高い。VPNサーバーの中継を不要とするNAT超えP2Pが魅力だが高い。高い。
- オープン版のHeadscaleはそのP2Pがomitされているが、データサーバー自体がVPNサーバーと同じ場所になるのでデメリット無し

**データストレージ:**
- Windows/Macで簡単に使えるSAMBAを採用
- データストレージはWSIシステムのバックエンドと結合し、パーミッションをコントロール

---

## 3. 認証システム

### 3.1 Web認証

**方法1:**
1. wsi.technoplasm.jp に直接メールアドレス / PW 入力
2. api.wsi のバックエンドサーバーから api.technoplasm.jp/pathology/v1/auth/login もしくは api.technoplasm.jp/wsi/v0/auth/login を叩いて JWT もらう。それを元にさらに JWT 発行してクライアントに渡す
3. その後は JWT リレーして api. とやりとりする。

**方法2:** 
1. `httpOnly` で api.wsi. から api. の JWTを取得
2. それを使って認証チェックして、wsi. 用に JWT発行する

**責任範囲:** 基本はテクプラ病理診断の認証を使う。WSIシステムには、アップロードされたファイル一覧の確認機能などを追加することを検討。

### 3.2 SAMBA認証

**ユーザー命名規則:**

- **ユーザー名**: `guest_{pathologyシステムのuser_id}`
- **パスワード**: api.wsi のAPI経由で発行・リセット

**同期方式:**
pathologyの方でセンターやユーザーのパーミッションが変わったときに、SAMBAの認証状態の更新が必要

- Nightly batch？
- あるいはWSIに入ったときなど、定期的にpathology API側に問い合わせてSAMBAのパーミッションを書き直す


---

## 4. パーミッション管理

### 4.1 設計検討事項

**ユーザー所属とパーミッション:**

- ユーザーAがセンターX、センターYに所属する場合
- ユーザーはユーザーでユニークなID
- センターはグループに対応するようにSAMBA側のパーミッションを制御する
- センターごとにデータストレージ側のストレージを分けない
- 基本的には同一データストレージで、施設ごとにディレクトリを作り、パーミッションで対処

ユーザー・センターの構成が変わったとき、SAMBAにどう同期する？
- WSIへログイン？pathology側で変更時にWSI側に通知？


---

## 5. ファイル構造

```
/data/center_sapporo/
├── wsi/
│   └── 25-01234/              # 症例番号ディレクトリ
│       ├── 25-01234_1.ndpi
│       ├── 25-01234_2.ndpi
│       └── ...
├── h5/
│   └── 25-01234/              # パッチ分割後
│       ├── 25-01234_01.h5
│       ├── 25-01234_02.h5
│       └── ...
└── r2/                        # R2アップロード管理用メタデータ？いらないかも
```

**設計確認事項:**

- 症例番号ベースのディレクトリ構造を採用
- まずパッチ分割とh5変換を行う
- そこからR2アップロード
- さらにオプションでAI処理もできるといい

---

## 6. WSI処理フロー

### 6.1 症例ディレクトリ作成

```
Web UI → POST api.wsi.technoplasm.jp/v0/requests/{request_id}/wsi/prepare
→ Backend: mkdir /data/center_sapporo/wsi/25-01234
```

管理システムにログインし、症例に対応したアップロード場所がデータストレージに準備。

### 6.2 WSIアップロード

```
ユーザー（VPN + SAMBA経由）
→ /data/center_sapporo/wsi/25-01234/25-01234_1.ndpi をコピー
```

### 6.3 パッチ分割・h5変換

```
Web UI → 症例選択 → 「ウェブビュー変換」ボタン
→ POST api.wsi.technoplasm.jp/v0/wsi/25-01234/convert
→ Backend:
  - パッチ分割
  - h5保存: /data/center_sapporo/h5/25-01234/*.h5
  - R2アップロード
```

アップロードされたWSIを選択（選択元の詳細は後述）し、パッチ分割してR2にアップロード。

### 6.4 AI処理

```
Web UI → 「AI処理実行」ボタン
→ POST api.wsi.technoplasm.jp/v0/wsi/25-01234/analysis
→ h5ファイルを読み込んで処理
```

AI処理などの実行の可否、AI結果の閲覧などが可能。


