DZIエクスポート機能

使い方:
```
uv run python -m wsi_toolbox.cli export-dzi \
  -i ./data/samples/25-0452_1.h5 \
  -o viewer/dzi/25-0452_1 \
  --fill-empty
```

出力構造:

```
viewer/dzi/25-0452_1/
├── 25-0452_1.dzi          # DZI定義ファイル
├── 25-0452_1_files/       # タイルディレクトリ
│   ├── _empty.jpeg        # 空白タイル用テンプレート (1.7KB、使い回し)
│   ├── 0/                 # レベル0（最小）
│   ├── 1/
│   ...
│   └── 9/                 # レベル9（最大、元解像度）
```

**オプション**:
- `-i`, `--input`: 入力HDF5ファイル
- `-o`, `--output`: 出力ディレクトリ（この中にDZIファイルとタイルが作られる）
- `-q`: JPEG品質 (デフォルト: 90)
- `--fill-empty`: 空白パッチに黒画像を出力（全画面表示に必要）

**ビューア**:
- `viewer/server.py` を起動
- `dzi/*/*.dzi` パターンで自動スキャン
- ファイル名から表示名を取得
